package com.tenqube.visual_third.api.resource;

import com.tenqube.visual_third.model.api.AnalysisResponse;
import com.tenqube.visual_third.model.api.NotificationPkgResponse;
import com.tenqube.visual_third.model.api.NotificationResponse;
import com.tenqube.visual_third.model.api.ParsingRuleKey;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;

import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Query;

public interface ResourceApi {

    String CATEGORY = "category";
    String ANALYSIS = "analysis";
    String PARSING_RULE = "parsingRule";

//    @GET("resource/version")


    @GET("resource")
    Call<SyncCategoryResponse> syncCategory(@Query("type") String type,
                                            @Query("clientVersion") int clientVersion,
                                            @Query("serverVersion") int serverVersion);

//    @GET("resource/v2")

    @GET("resource/notification-apps")
    Call<NotificationPkgResponse> syncNotificationApps();


    @GET("resource/parsing-rule/key")
    Call<ParsingRuleKey> syncParsingRuleKey();

    @GET("resource")
    Call<AnalysisResponse> syncAnalysis(@Query("type") String type,
                                        @Query("clientVersion") int clientVersion,
                                        @Query("serverVersion") int serverVersion);

    @GET("resource/notification")
    Call<NotificationResponse> syncNotification();

}
