/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.api.hana;

import android.text.TextUtils;
import android.util.Log;
import com.tenqube.visual_third.api.hana.HanaApi;
import com.tenqube.visual_third.api.hana.HanaApiService;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.SignatureManager;
import com.tenqube.visual_third.model.api.ParsingRuleResponse;
import com.tenqube.visual_third.model.api.TransactionRequest;
import com.tenqube.visual_third.model.api.VersionResponse;
import com.tenqube.visual_third.model.service.ApiInfo;
import com.tenqube.visual_third.util.Utils;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import tenqube.parser.model.ParsingRule;

public class HanaServiceImpl
implements HanaApiService {
    private static final String TAG = HanaServiceImpl.class.getSimpleName();
    private final HanaApi apiService;
    private final SignatureManager signatureManager;
    private final PrefManager prefManager;
    private static HanaApiService mInstance;

    private HanaServiceImpl(HanaApi apiService, SignatureManager signatureManager, PrefManager prefManager) {
        this.apiService = apiService;
        this.signatureManager = signatureManager;
        this.prefManager = prefManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HanaApiService getInstance(HanaApi apiService, SignatureManager signatureManager, PrefManager prefManager) {
        Class<HanaServiceImpl> clazz = HanaServiceImpl.class;
        synchronized (HanaServiceImpl.class) {
            if (mInstance == null) {
                mInstance = new HanaServiceImpl(apiService, signatureManager, prefManager);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return mInstance;
        }
    }

    private ApiInfo getApiInfo() {
        try {
            String apiInfoJson = this.prefManager.loadStringValue("TENQUBE_API_INFO", "");
            if (TextUtils.isEmpty((CharSequence)apiInfoJson)) {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("x-api-key", this.prefManager.loadStringValue("TENQUBE_RESOURCE_API_KEY", ""));
                return new ApiInfo(this.prefManager.loadStringValue("TENQUBE_RESOURCE_URL", ""), headers, this.prefManager.loadStringValue("TENQUBE_RESOURCE_URL", ""), headers, this.prefManager.loadStringValue("TENQUBE_RESOURCE_URL", ""), headers);
            }
            return Utils.fromJson(apiInfoJson, ApiInfo.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public VersionResponse syncVersion() {
        try {
            Log.i((String)"VisualAPI", (String)"syncVersion");
            ApiInfo apiInfo = this.getApiInfo();
            Log.i((String)"VisualAPI", (String)("syncVersion apiInfo.getVersionUrl()" + apiInfo.getVersionUrl()));
            Log.i((String)"VisualAPI", (String)("syncVersion apiInfo.getVersionHeader()" + apiInfo.getVersionHeader()));
            Response response = this.apiService.syncVersion(apiInfo.getVersionUrl(), apiInfo.getVersionHeader()).execute();
            if (response != null && response.isSuccessful()) {
                VersionResponse result = (VersionResponse)response.body();
                Log.i((String)"VisualAPI", (String)("syncVersion result " + result));
                Log.i((String)"VisualAPI", (String)("syncVersion response.code()" + response.code()));
                Log.i((String)"VisualAPI", (String)("syncVersion response.message()" + response.message()));
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void saveTransactions(TransactionRequest transactionRequest, Callback<Void> callback) {
        Log.i((String)"VisualAPI", (String)"saveTransactions");
        String apiInfoJson = this.prefManager.loadStringValue("TENQUBE_API_INFO", "");
        Log.i((String)"VisualAPI", (String)("saveTransactions apiInfoJson" + apiInfoJson));
        if (TextUtils.isEmpty((CharSequence)apiInfoJson)) {
            callback.onResponse(null, null);
        } else {
            ApiInfo apiInfo = Utils.fromJson(apiInfoJson, ApiInfo.class);
            if (apiInfo != null) {
                if (apiInfo != null) {
                    Log.i((String)"VisualAPI", (String)("saveTransactions apiInfo.getTransactionUrl()" + apiInfo.getTransactionUrl()));
                    Log.i((String)"VisualAPI", (String)("saveTransactions apiInfo.getTranHeader()" + apiInfo.getTranHeader()));
                }
                Call<Void> call = this.apiService.saveTransactions(apiInfo.getTransactionUrl(), apiInfo.getTranHeader(), transactionRequest);
                call.enqueue(callback);
            } else {
                Log.i((String)"VisualAPI", (String)"saveTransactions apiInfo null");
                callback.onResponse(null, null);
            }
        }
    }

    @Override
    public ParsingRule syncParsingRule(int clientVersion, int serverVersion) {
        block6: {
            try {
                ResponseBody response;
                Log.i((String)"VisualAPI", (String)("syncParsingRule" + clientVersion + "server" + serverVersion));
                if (serverVersion <= clientVersion) break block6;
                ApiInfo apiInfo = this.getApiInfo();
                if (apiInfo != null) {
                    Log.i((String)"VisualAPI", (String)("syncParsingRule apiInfo.getSmsUrl()" + apiInfo.getSmsUrl()));
                    Log.i((String)"VisualAPI", (String)("syncParsingRule apiInfo.getSmsHeader()" + apiInfo.getSmsHeader()));
                }
                Response ruleResponse = this.apiService.syncParsingRule(apiInfo.getSmsUrl(), apiInfo.getSmsHeader(), "parsingRule", clientVersion, serverVersion).execute();
                Log.i((String)"VisualAPI", (String)("syncParsingRule ruleResponse.code()" + ruleResponse.code()));
                Log.i((String)"VisualAPI", (String)("syncParsingRule ruleResponse.message()" + ruleResponse.message()));
                if (!ruleResponse.isSuccessful() || (response = (ResponseBody)ruleResponse.body()) == null) break block6;
                try {
                    JSONObject jsonObject = new JSONObject(response.string());
                    String signature = jsonObject.getString("signature");
                    String resource = jsonObject.getString("resource");
                    ParsingRuleResponse parsingRuleResponse = Utils.fromJson(resource, ParsingRuleResponse.class);
                    boolean isValid = this.signatureManager.isValid(clientVersion, parsingRuleResponse.securityKey, serverVersion, resource, signature);
                    Log.i((String)"VisualAPI", (String)("syncParsingRule isValid" + isValid));
                    if (isValid) {
                        ParsingRule parsingRule = new ParsingRule(parsingRuleResponse.securityKey, parsingRuleResponse.tranCount, parsingRuleResponse.ruleVersion, parsingRuleResponse.regDatas, parsingRuleResponse.senders, parsingRuleResponse.banks);
                        return parsingRule;
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

