package com.tenqube.visual_third.api.hana;

import com.tenqube.visual_third.model.api.TransactionRequest;
import com.tenqube.visual_third.model.api.VersionResponse;

import java.util.Map;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HeaderMap;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.Url;

public interface HanaApi {

    @POST
    Call<Void> saveTransactions(@Url String url, @HeaderMap Map<String, String> headers, @Body TransactionRequest transactionRequest);


    @GET
    Call<ResponseBody> syncParsingRule(@Url String url, @HeaderMap Map<String, String> headers,
                                       @Query("type") String type,
                                       @Query("clientVersion") int clientVersion,
                                       @Query("serverVersion") int serverVersion);
    @GET
    Call<VersionResponse> syncVersion(@Url String url,
                                      @HeaderMap Map<String, String> headers);
}
