package com.tenqube.visual_third.api.resource;

import com.tenqube.visual_third.BuildConfig;
import com.tenqube.visual_third.manager.PrefManager;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

import static com.tenqube.visual_third.api.search.SearchHeaderInterceptor.X_API_KEY;

public class ResourceHeaderInterceptor implements Interceptor {

    private static final String SERVICE = "service";
    private final PrefManager prefManager;

    public ResourceHeaderInterceptor(PrefManager prefManager) {
        this.prefManager = prefManager;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {

        Request.Builder builder = chain.request()
                .newBuilder()
                .addHeader(X_API_KEY, "iZNnFACxmN7w7RERSwGSa6h6KdONndJP33UYTurl")
                .addHeader(SERVICE, BuildConfig.SERVICE);

        return chain.proceed(builder.build());
    }


}
