package com.tenqube.visual_third.api.hana;

import android.text.TextUtils;
import android.util.Log;

import com.tenqube.visual_third.api.resource.ResourceApi;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.SignatureManager;
import com.tenqube.visual_third.model.api.ParsingRuleResponse;
import com.tenqube.visual_third.model.api.TransactionRequest;
import com.tenqube.visual_third.model.api.VersionResponse;
import com.tenqube.visual_third.model.service.ApiInfo;
import com.tenqube.visual_third.util.Utils;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.util.HashMap;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import tenqube.parser.model.ParsingRule;

public class HanaServiceImpl implements HanaApiService {

    private static final String TAG = HanaServiceImpl.class.getSimpleName();

    private final HanaApi apiService;

    private final SignatureManager signatureManager;

    private final PrefManager prefManager;

    private HanaServiceImpl(HanaApi apiService, SignatureManager signatureManager, PrefManager prefManager) {

        this.apiService = apiService;
        this.signatureManager = signatureManager;
        this.prefManager = prefManager;
    }

    private static HanaApiService mInstance;

    public static HanaApiService getInstance(HanaApi apiService, SignatureManager signatureManager, PrefManager prefManager) {
        synchronized (HanaServiceImpl.class) {
            if (mInstance == null) {
                mInstance = new HanaServiceImpl(apiService, signatureManager, prefManager);
            }
        }
        return mInstance;
    }

    private ApiInfo getApiInfo() {
        try {

            String apiInfoJson = prefManager.loadStringValue(PrefManager.API_INFO, "");
            if (TextUtils.isEmpty(apiInfoJson)) {
                HashMap<String, String> headers = new HashMap<>();
                headers.put("x-api-key", prefManager.loadStringValue(PrefManager.RESOURCE_API_KEY, ""));
                return new ApiInfo(prefManager.loadStringValue(PrefManager.RESOURCE_URL, ""), headers,
                        prefManager.loadStringValue(PrefManager.RESOURCE_URL, ""), headers,
                        prefManager.loadStringValue(PrefManager.RESOURCE_URL, ""), headers);
            } else {
                return Utils.fromJson(apiInfoJson, ApiInfo.class);
            }
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    public VersionResponse syncVersion() {
        try {
            Log.i("VisualAPI", "syncVersion");

            ApiInfo apiInfo = getApiInfo();

            Log.i("VisualAPI", "syncVersion apiInfo.getVersionUrl()" + apiInfo.getVersionUrl());
            Log.i("VisualAPI", "syncVersion apiInfo.getVersionHeader()" + apiInfo.getVersionHeader());

            Response<VersionResponse> response = apiService.syncVersion(apiInfo.getVersionUrl(), apiInfo.getVersionHeader()).execute();
            if (response != null) {



                if (response.isSuccessful()) {
                    VersionResponse result = response.body();
                    Log.i("VisualAPI", "syncVersion result " + result);
                    Log.i("VisualAPI", "syncVersion response.code()" + response.code());
                    Log.i("VisualAPI", "syncVersion response.message()" + response.message());

                    return result;
                }
            }

        } catch (Exception e) {

        }

        return null;

    }

    @Override
    public void saveTransactions(TransactionRequest transactionRequest, Callback<Void> callback) {
        Log.i("VisualAPI", "saveTransactions");



        String apiInfoJson = prefManager.loadStringValue(PrefManager.API_INFO, "");

        Log.i("VisualAPI", "saveTransactions apiInfoJson" + apiInfoJson);


        if (TextUtils.isEmpty(apiInfoJson)) {
            callback.onResponse(null, null);
        } else {

            ApiInfo apiInfo = Utils.fromJson(apiInfoJson, ApiInfo.class);

            if(apiInfo != null) {
                if(apiInfo != null) {
                    Log.i("VisualAPI", "saveTransactions apiInfo.getTransactionUrl()" + apiInfo.getTransactionUrl());
                    Log.i("VisualAPI", "saveTransactions apiInfo.getTranHeader()" + apiInfo.getTranHeader());

                }
                Call<Void> call = apiService.saveTransactions(apiInfo.getTransactionUrl(), apiInfo.getTranHeader(), transactionRequest);
                call.enqueue(callback);

            } else {
                Log.i("VisualAPI", "saveTransactions apiInfo null");

                callback.onResponse(null, null);

            }

        }

    }

    @Override
    public ParsingRule syncParsingRule(int clientVersion, int serverVersion) {
        try {

            Log.i("VisualAPI", "syncParsingRule" + clientVersion + "server" + serverVersion);

            if(serverVersion > clientVersion) {


                ApiInfo apiInfo = getApiInfo();

                if(apiInfo != null) {
                    Log.i("VisualAPI", "syncParsingRule apiInfo.getSmsUrl()" + apiInfo.getSmsUrl());
                    Log.i("VisualAPI", "syncParsingRule apiInfo.getSmsHeader()" + apiInfo.getSmsHeader());

                }

                Response<ResponseBody> ruleResponse = apiService.syncParsingRule(
                        apiInfo.getSmsUrl(),
                        apiInfo.getSmsHeader(),
                        ResourceApi.PARSING_RULE,
                        clientVersion,
                        serverVersion).execute();

                Log.i("VisualAPI", "syncParsingRule ruleResponse.code()" + ruleResponse.code());
                Log.i("VisualAPI", "syncParsingRule ruleResponse.message()" + ruleResponse.message());


                Log.i("VisualAPI", "syncParsingRule ruleResponse.isSuccessful()" + ruleResponse.isSuccessful());


                if(ruleResponse.isSuccessful()) {
                    ResponseBody response = ruleResponse.body();

                    if(response != null) {
                        try {
                            JSONObject jsonObject = new JSONObject(response.string());
                            String signature = jsonObject.getString("signature");
                            String resource = jsonObject.getString("resource");

                            ParsingRuleResponse parsingRuleResponse = Utils.fromJson(resource, ParsingRuleResponse.class);

                            boolean isValid = signatureManager.isValid(clientVersion, parsingRuleResponse.securityKey, serverVersion, resource, signature);
                            Log.i("VisualAPI", "syncParsingRule isValid" + isValid);

                            if(true) {
                                ParsingRule parsingRule = new ParsingRule(parsingRuleResponse.securityKey,
                                        parsingRuleResponse.tranCount,
                                        parsingRuleResponse.ruleVersion,
                                        parsingRuleResponse.regDatas,
                                        parsingRuleResponse.senders,
                                        parsingRuleResponse.banks);

                                Log.i("VisualAPI", "syncParsingRule parsingRule" + parsingRule.toString());

                                return parsingRule;
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                    }
                }
            }

        } catch (IOException e) {

        }

        return null;
    }



}
