/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.api.resource;

import android.text.TextUtils;
import com.tenqube.visual_third.api.resource.ResourceApi;
import com.tenqube.visual_third.api.resource.ResourceService;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.SignatureManager;
import com.tenqube.visual_third.model.api.AnalysisResponse;
import com.tenqube.visual_third.model.api.NotificationPkgResponse;
import com.tenqube.visual_third.model.api.NotificationResponse;
import com.tenqube.visual_third.model.api.ParsingRuleKey;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import com.tenqube.visual_third.model.service.ApiInfo;
import com.tenqube.visual_third.util.Utils;
import java.io.IOException;
import java.util.HashMap;
import retrofit2.Response;

public class ResourceServiceImpl
implements ResourceService {
    private static final String TAG = ResourceServiceImpl.class.getSimpleName();
    private final ResourceApi resourceApi;
    private final SignatureManager signatureManager;
    private final PrefManager prefManager;
    private static ResourceService mInstance;

    private ResourceServiceImpl(ResourceApi resourceApi, SignatureManager signatureManager, PrefManager prefManager) {
        this.resourceApi = resourceApi;
        this.signatureManager = signatureManager;
        this.prefManager = prefManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceService getInstance(ResourceApi resourceApi, SignatureManager signatureManager, PrefManager prefManager) {
        Class<ResourceServiceImpl> clazz = ResourceServiceImpl.class;
        synchronized (ResourceServiceImpl.class) {
            if (mInstance == null) {
                mInstance = new ResourceServiceImpl(resourceApi, signatureManager, prefManager);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return mInstance;
        }
    }

    private ApiInfo getApiInfo() {
        try {
            String apiInfoJson = this.prefManager.loadStringValue("TENQUBE_API_INFO", "");
            if (TextUtils.isEmpty((CharSequence)apiInfoJson)) {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("x-api-key", this.prefManager.loadStringValue("TENQUBE_RESOURCE_API_KEY", ""));
                return new ApiInfo(this.prefManager.loadStringValue("TENQUBE_RESOURCE_URL", ""), headers, this.prefManager.loadStringValue("TENQUBE_RESOURCE_URL", ""), headers, this.prefManager.loadStringValue("TENQUBE_RESOURCE_URL", ""), headers);
            }
            return Utils.fromJson(apiInfoJson, ApiInfo.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public SyncCategoryResponse syncCategory(int clientVersion, int serverVersion) {
        if (serverVersion > clientVersion) {
            try {
                Response response = this.resourceApi.syncCategory("category", clientVersion, serverVersion).execute();
                if (response.isSuccessful()) {
                    return (SyncCategoryResponse)response.body();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public NotificationPkgResponse syncNotificationApps() {
        try {
            Response response = this.resourceApi.syncNotificationApps().execute();
            if (response.isSuccessful()) {
                return (NotificationPkgResponse)response.body();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public AnalysisResponse syncAnalysis(int clientVersion, int serverVersion) {
        if (serverVersion > clientVersion) {
            try {
                Response response = this.resourceApi.syncAnalysis("analysis", clientVersion, serverVersion).execute();
                if (response.isSuccessful()) {
                    return (AnalysisResponse)response.body();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public NotificationResponse syncNotification() {
        try {
            Response response = this.resourceApi.syncNotification().execute();
            if (response.isSuccessful()) {
                return (NotificationResponse)response.body();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public ParsingRuleKey syncParsingRuleKey() {
        try {
            Response response = this.resourceApi.syncParsingRuleKey().execute();
            if (response != null && response.isSuccessful()) {
                return (ParsingRuleKey)response.body();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

