package com.tenqube.visual_third.manager;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeAppInstallAdView;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeContentAdView;
import com.tenqube.visual_third.OnAdLoadedListener;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.entity.Advertisement;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.GoOpenMarketUtil;

public class AdManager {

    public static final String TAG = AdManager.class.getSimpleName();

    public static final String AD_ID = "ca-app-pub-1003660361092577~7068892221";
    public static final String POPUP_UNIT_ID = "ca-app-pub-1003660361092577/1816565547";

    private static AdManager mInstance = null;
    private VisualRepository repository;
    private Context mContext;

    public com.tenqube.visual_third.model.js.AdRequest adRequest;

//    private MobonManage

    public static AdManager getInstance(Context ctx) {

        synchronized (AdManager.class) {
            if (mInstance == null) {
                mInstance = new AdManager(ctx.getApplicationContext());
            }
        }
        return mInstance;
    }

    private AdManager(Context context) {
        this.mContext = context;

        this.repository = RepositoryHolder.getInstance(context).getVisualRepository();
        MobileAds.initialize(mContext, AD_ID);
    }

    /**
     * 1. Visual Api 호출
     * 2. 만족하는 광고 체크
     * 3. 없는경우 구글 admob 호출
     * 4. 로드 실패한경우 디폴트 광고 호출
     * @param listener
     */
    public void loadAd(com.tenqube.visual_third.model.js.AdRequest adRequest,  @NonNull OnAdLoadedListener listener) {
        this.adRequest = adRequest;
        loadAdmob(adRequest.unitId, listener);
    }

    private View populateAppInstallAdView(NativeAppInstallAd nativeAd, NativeAppInstallAdView adView) {

        String bgColor;
        String titleColor;
        String msgColor;
        String linkToColor;
        String linkToBgColor;

        if(adRequest.container != null) {
            bgColor = adRequest.container.bgColor;
            titleColor = adRequest.container.textColor;
        } else {
            bgColor = "#f0fbff";
            titleColor = "#000000";
        }

        if(adRequest.button != null) {
            linkToColor = adRequest.button.textColor;
            linkToBgColor = adRequest.button.bgColor;
        } else {
            linkToColor = "#ffffff";
            linkToBgColor = "#3684ff";
        }

        setBgColor(adView, bgColor);

        adView.setHeadlineView(adView.findViewById(R.id.title));
        adView.setIconView(adView.findViewById(R.id.icon_image));
        adView.setBodyView(adView.findViewById(R.id.msg));
        adView.setCallToActionView(adView.findViewById(R.id.link_text));


        // The headline is guaranteed to be in every UnifiedNativeAd.
        if(TextUtils.isEmpty(nativeAd.getHeadline())) {
            return null;
        }

        if(TextUtils.isEmpty(nativeAd.getCallToAction())) {
            return null;
        }

        ((TextView) adView.getHeadlineView()).setText(nativeAd.getHeadline());
        setTextColor(((TextView) adView.getHeadlineView()), titleColor);
        // These assets aren't guaranteed to be in every UnifiedNativeAd, so it's important to
        // check before trying to display them.
        if (nativeAd.getBody() == null) {
            adView.getBodyView().setVisibility(View.INVISIBLE);
        } else {
            adView.getBodyView().setVisibility(View.VISIBLE);
            ((TextView) adView.getBodyView()).setText(nativeAd.getBody());
        }

        adView.getCallToActionView().setVisibility(View.VISIBLE);
        ((TextView) adView.getCallToActionView()).setText(nativeAd.getCallToAction());
        setTextColor(((TextView) adView.getCallToActionView()), linkToColor);
        setBgColor(adView.findViewById(R.id.linkto), linkToBgColor);

        if (nativeAd.getIcon() == null || nativeAd.getIcon().getDrawable() == null) {
            adView.getIconView().setVisibility(View.GONE);
            adView.findViewById(R.id.icon_image_container).setVisibility(View.GONE);
        } else {
            ((ImageView) adView.getIconView()).setImageDrawable(
                    nativeAd.getIcon().getDrawable());
            adView.getIconView().setVisibility(View.VISIBLE);
        }
        adView.setNativeAd(nativeAd);

        return adView;

    }


    private View populateContentAdView(NativeContentAd nativeAd, NativeContentAdView adView) {

        String bgColor;
        String titleColor;
        String msgColor;
        String linkToColor;
        String linkToBgColor;

        if(adRequest.container != null) {
            bgColor = adRequest.container.bgColor;
            titleColor = adRequest.container.textColor;
        } else {
            bgColor = "#f0fbff";
            titleColor = "#000000";
        }

        if(adRequest.button != null) {
            linkToColor = adRequest.button.textColor;
            linkToBgColor = adRequest.button.bgColor;
        } else {
            linkToColor = "#ffffff";
            linkToBgColor = "#3684ff";
        }

        setBgColor(adView, bgColor);

        adView.setHeadlineView(adView.findViewById(R.id.title));
        adView.setLogoView(adView.findViewById(R.id.icon_image));
        adView.setBodyView(adView.findViewById(R.id.msg));
        adView.setCallToActionView(adView.findViewById(R.id.link_text));

        if(TextUtils.isEmpty(nativeAd.getHeadline())) {
            return null;
        }

        if(TextUtils.isEmpty(nativeAd.getCallToAction())) {
            return null;
        }

        String title = nativeAd.getHeadline().toString();
        String msg = nativeAd.getBody().toString();
        String callToAction = nativeAd.getCallToAction().toString();

        // The headline is guaranteed to be in every UnifiedNativeAd.
        ((TextView) adView.getHeadlineView()).setText(title);
        setTextColor(((TextView) adView.getHeadlineView()), titleColor);
        // These assets aren't guaranteed to be in every UnifiedNativeAd, so it's important to
        // check before trying to display them.
        if (nativeAd.getBody() == null) {
            adView.getBodyView().setVisibility(View.INVISIBLE);
        } else {
            adView.getBodyView().setVisibility(View.VISIBLE);
            ((TextView) adView.getBodyView()).setText(msg);
        }

        adView.getCallToActionView().setVisibility(View.VISIBLE);
        ((TextView) adView.getCallToActionView()).setText(callToAction);
        setTextColor(((TextView) adView.getCallToActionView()), linkToColor);

        setBgColor(adView.findViewById(R.id.linkto), linkToBgColor);

        if (nativeAd.getLogo() == null || nativeAd.getLogo().getDrawable() == null) {
            adView.getLogoView().setVisibility(View.GONE);
            adView.findViewById(R.id.icon_image_container).setVisibility(View.GONE);
        } else {
            ((ImageView) adView.getLogoView()).setImageDrawable(
                    nativeAd.getLogo().getDrawable());
            adView.getLogoView().setVisibility(View.VISIBLE);
        }
        adView.setNativeAd(nativeAd);

        return adView;

    }

    void loadAdmob(String unitId, final OnAdLoadedListener listener) {
        AdLoader.Builder builder = new AdLoader.Builder(mContext, unitId);


        builder.forContentAd(new NativeContentAd.OnContentAdLoadedListener() {
            @Override
            public void onContentAdLoaded(NativeContentAd nativeContentAd) {
                NativeContentAdView adView = (NativeContentAdView) LayoutInflater.from(mContext)
                        .inflate(R.layout.visual_admob_view, null);

                View view = populateContentAdView(nativeContentAd, adView);
                if(listener != null && view != null) {
                    listener.onAdLoaded(view);
                }
            }
        });

        builder.forAppInstallAd(new NativeAppInstallAd.OnAppInstallAdLoadedListener() {
            @Override
            public void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
                NativeAppInstallAdView adView = (NativeAppInstallAdView) LayoutInflater.from(mContext)
                        .inflate(R.layout.visual_app_install_admob_view, null);

                View view = populateAppInstallAdView(nativeAppInstallAd, adView);

                if(listener != null && view != null) {
                    listener.onAdLoaded(view);
                }
            }
        });
//
        VideoOptions videoOptions = new VideoOptions.Builder()
                .setStartMuted(true)
                .build();

        NativeAdOptions adOptions = new NativeAdOptions.Builder()
                .setVideoOptions(videoOptions)
                .build();

        builder.withNativeAdOptions(adOptions);

        AdLoader adLoader = builder.withAdListener(new AdListener() {

            @Override
            public void onAdFailedToLoad(int errorCode) {

                if(listener != null) {
                    listener.onAdLoaded(null);
                }
            }
        }).build();


        AdRequest nativeAdRequest = new AdRequest.Builder()
                .build();
        adLoader.loadAd(nativeAdRequest);
    }

    private void goIntent(Advertisement ad) {

        try {

            if("app".equals(ad.getLinkToType())) {

                VisualWebActivity.startActivity(mContext, "");

            } else if("market".equals(ad.getLinkToType())) {

                GoOpenMarketUtil.openOnGooglePlayMarket(mContext, ad.getLinkTo());

            } else if("web".equals(ad.getLinkToType())) {
                Intent i = new Intent(Intent.ACTION_VIEW);
                i.setData(Uri.parse(ad.getLinkTo()));
                mContext.startActivity(i);
            }

        } catch (Exception e) {

        }
    }

    private void setBgColor(View view, String bgColor) {
        try {
            if(!TextUtils.isEmpty(bgColor)) {
                view.setBackgroundResource(R.drawable.round);
                GradientDrawable drawable = (GradientDrawable) view.getBackground();
                drawable.setColor(Color.parseColor(bgColor));
            }
        } catch (Exception e) {

        }
    }

    private void setTextColor(TextView view, String textColor) {
        try {
            if(!TextUtils.isEmpty(textColor)) {
                view.setTextColor(Color.parseColor(textColor));
            }
        } catch (Exception e) {

        }

    }
}
