/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third;

import android.app.Activity;
import android.content.Context;
import android.service.notification.StatusBarNotification;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.VisualCallback;
import com.tenqube.visual_third.VisualService;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.parser.catcher.NotiManager;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.OnResultListener;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.Validator;
import tenqube.parser.core.ParserService;

public class VisualServiceImpl
implements VisualService {
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    private Context context;
    private ParserService parserService;
    private VisualRepository repository;
    private VisualAlarmManager alarmManager;
    private NotiManager notiManager;

    private VisualServiceImpl(Builder builder) throws ParameterException {
        Validator.notNull(builder.context);
        Validator.isNotEmpty(builder.apiKey);
        Validator.isNotEmpty(builder.authority);
        Validator.in(builder.qualifier, "dev", "prod");
        this.context = builder.context;
        this.repository = RepositoryHolder.getInstance(this.context).getVisualRepository();
        this.repository.saveSDKInfo(builder.apiKey, builder.qualifier, builder.authority);
        this.repository.settingNotification(builder.smallIcon, builder.channel, builder.color);
        this.parserService = ParserService.getInstance((Context)this.context);
        this.alarmManager = VisualAlarmManager.getInstance(this.context);
        this.notiManager = NotiManager.getInstance(this.context.getApplicationContext());
    }

    @Override
    public void parseNoti(StatusBarNotification sbn) {
        this.notiManager.parseNoti(sbn);
    }

    @Override
    public void signUp(@NonNull String uid, @NonNull OnResultListener onResultListener) throws ParameterException {
        Validator.isNotEmpty(uid);
        Validator.notNull(onResultListener);
        this.repository.signUp(uid, onResultListener);
    }

    @Override
    public void startVisual(final @Nullable Activity activity, @NonNull String uid, final @NonNull String path, final @NonNull OnResultListener resultListener) throws ParameterException {
        Validator.isNotEmpty(uid);
        Validator.notNull(resultListener);
        Validator.notNull(path);
        this.repository.signUp(uid, new OnResultListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(Constants.SignUpResponse signUpResult, String msg) {
                try {
                    if (signUpResult == Constants.SignUpResponse.SUCCESS) {
                        AnswerManager.onKeyMetric(new LogRequest("startVisual"));
                        if (activity == null) {
                            VisualWebActivity.startActivity(VisualServiceImpl.this.context, path);
                        } else {
                            VisualWebActivity.startActivity(activity, path);
                        }
                    }
                }
                catch (AuthException e) {
                    signUpResult = Constants.SignUpResponse.FAIL;
                    msg = e.toString();
                }
                finally {
                    resultListener.onResult(signUpResult, msg);
                }
            }
        });
    }

    @Override
    public void signOut(Callback<Boolean> callback) {
        this.repository.signOut(new Callback<Boolean>(){

            @Override
            public void onDataLoaded(Boolean value) {
                VisualServiceImpl.this.alarmManager.setAlarms();
            }
        });
    }

    @Override
    public boolean isActiveTranPopup() {
        AnswerManager.onKeyMetric(new LogRequest("isActiveTranPopup"));
        return this.repository.isActiveTranPopup();
    }

    @Override
    public void setTranPopup(boolean isActive) {
        AnswerManager.onKeyMetric(new LogRequest("setTranPopup"));
        this.repository.setTranPopup(isActive);
    }

    @Override
    public void setReportAlarm(Constants.ReportAlarmType type, boolean isActive) {
        this.repository.setActiveNoti(type.name().toLowerCase(), isActive);
        this.alarmManager.setAlarms();
    }

    @Override
    public boolean isActiveReportAlarm(Constants.ReportAlarmType type) {
        return this.repository.isActiveNoti(type.name().toLowerCase());
    }

    @Override
    public void setReportTest(Constants.ReportAlarmType type, int second) {
        this.alarmManager.setReportTest(type.name().toLowerCase(), second);
    }

    @Override
    public void setLogger(boolean isActive) {
        if (this.isActive() && this.parserService != null) {
            this.parserService.setDebugMode(isActive);
        }
    }

    @Override
    public void initSDK() {
        if (this.isActive() && this.parserService != null) {
            this.parserService.initDb();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.repository.setEnabled(enabled);
        if (!enabled) {
            this.repository.setNotiAll(false);
            this.alarmManager.setAlarms();
        }
    }

    @Override
    public boolean isJoined() {
        return this.repository.isJoined();
    }

    @Override
    public void setAppNoti(boolean isActive) {
        this.repository.setAppNoti(isActive);
        this.alarmManager.setAlarms();
    }

    @Override
    public boolean isActiveAppNoti() {
        return this.repository.isAppNoti();
    }

    private boolean isActive() {
        return this.context != null;
    }

    public static class Builder {
        Context context;
        VisualCallback visualCallback;
        String apiKey;
        String qualifier;
        String authority;
        int smallIcon;
        String channel;
        int color;
        boolean logger;

        public Builder withContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder visualCallback(VisualCallback visualCallback) {
            this.visualCallback = visualCallback;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public Builder authority(String authority) {
            this.authority = authority;
            return this;
        }

        public Builder notification(int smallIcon, @NonNull String channel, int color) {
            this.smallIcon = smallIcon;
            this.channel = channel;
            this.color = color;
            return this;
        }

        public Builder logger(boolean logger) {
            this.logger = logger;
            return this;
        }

        public VisualService build() throws ParameterException {
            return new VisualServiceImpl(this);
        }
    }
}

