package com.tenqube.visual_third.analysis;

import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.model.analysis.AggregationValue;
import com.tenqube.visual_third.model.analysis.Transaction;

import java.util.ArrayList;
import java.util.HashMap;

import static com.tenqube.visual_third.analysis.AnalysisHelper.aggregate;
import static com.tenqube.visual_third.analysis.AnalysisHelper.filterTransactions12Weekly;

/**
 * Created by sagwangjin on 2018. 7. 22..
 */

public class Last12WeeklyAnalysis implements Runnable {
    private final ArrayList<Transaction> transactions;
    public HashMap<String, AggregationValue> last12weekly;

    Last12WeeklyAnalysis(ArrayList<Transaction> transactions) {
        this.transactions = transactions;
    }

    @Override
    public void run() {
        // 월간
        ArrayList<Transaction> filteredTransactions = filterTransactions12Weekly(transactions); //이번주

        last12weekly = aggregate(filteredTransactions, Constants.AggregateType.NONE);

    }
}
