package com.tenqube.visual_third.model.api;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.google.gson.annotations.SerializedName;
import com.tenqube.visual_third.exception.ParameterException;

import java.io.Serializable;

import static com.tenqube.visual_third.util.Validator.isStr;

public class UserRequest implements Serializable {

    @SerializedName("uid")
    private final String uid;

    @SerializedName("adId")
    private String adId;

    public UserRequest(@NonNull String uid, String adId) throws ParameterException {
        isStr(uid, 500);
        this.uid = uid;
        this.adId = adId;
    }

    public void setAdId(@Nullable String adId) {
        this.adId = adId;
    }

    public String getUid() {
        return uid;
    }

    public String getAdId() {
        return adId;
    }
}
