package com.tenqube.visual_third.manager;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.UnifiedNativeAdView;
import com.tenqube.visual_third.OnAdLoadedListener;
import com.tenqube.visual_third.R;

public class AdManager {

    public static final String TAG = AdManager.class.getSimpleName();

    public static final String AD_ID = "ca-app-pub-1003660361092577~7504035716";

    private static AdManager mInstance = null;
    private Context mContext;

    com.tenqube.visual_third.model.js.AdRequest adRequest;

    public static AdManager getInstance(Context ctx) {

        synchronized (AdManager.class) {
            if (mInstance == null) {
                mInstance = new AdManager(ctx.getApplicationContext());
            }
        }
        return mInstance;
    }

    private AdManager(Context context) {
        this.mContext = context;
        try {

            MobileAds.initialize(context, AdManager.AD_ID);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * 1. Visual Api 호출
     * 2. 만족하는 광고 체크
     * 3. 없는경우 구글 admob 호출
     * 4. 로드 실패한경우 디폴트 광고 호출
     * @param listener
     */
    public void loadAd(com.tenqube.visual_third.model.js.AdRequest adRequest,  @NonNull OnAdLoadedListener listener) {
        this.adRequest = adRequest;
        loadAdmob(adRequest.unitId, listener);
    }

    private View populateUnifiedNativeAdView(UnifiedNativeAd nativeAd, UnifiedNativeAdView adView) {

        String bgColor;
        String titleColor;
        String msgColor;
        String linkToColor;
        String linkToBgColor;

        if(adRequest.container != null) {
            bgColor = adRequest.container.bgColor;
            titleColor = adRequest.container.textColor;
        } else {
            bgColor = "#f0fbff";
            titleColor = "#000000";
        }

        if(adRequest.button != null) {
            linkToColor = adRequest.button.textColor;
            linkToBgColor = adRequest.button.bgColor;
        } else {
            linkToColor = "#ffffff";
            linkToBgColor = "#3684ff";
        }

        setBgColor(adView, bgColor);

        adView.setHeadlineView(adView.findViewById(R.id.title));
        adView.setIconView(adView.findViewById(R.id.icon_image));
        adView.setBodyView(adView.findViewById(R.id.msg));
        adView.setCallToActionView(adView.findViewById(R.id.link_text));


        // The headline is guaranteed to be in every UnifiedNativeAd.
        if(TextUtils.isEmpty(nativeAd.getHeadline())) {
            return null;
        }

        if(TextUtils.isEmpty(nativeAd.getCallToAction())) {
            return null;
        }

        ((TextView) adView.getHeadlineView()).setText(nativeAd.getHeadline());
        setTextColor(((TextView) adView.getHeadlineView()), titleColor);
        // These assets aren't guaranteed to be in every UnifiedNativeAd, so it's important to
        // check before trying to display them.
        if (nativeAd.getBody() == null) {
            adView.getBodyView().setVisibility(View.INVISIBLE);
        } else {
            adView.getBodyView().setVisibility(View.VISIBLE);
            ((TextView) adView.getBodyView()).setText(nativeAd.getBody());
        }

        adView.getCallToActionView().setVisibility(View.VISIBLE);
        ((TextView) adView.getCallToActionView()).setText(nativeAd.getCallToAction());
        setTextColor(((TextView) adView.getCallToActionView()), linkToColor);
        setBgColor(adView.findViewById(R.id.linkto), linkToBgColor);

        if (nativeAd.getIcon() == null || nativeAd.getIcon().getDrawable() == null) {
            adView.getIconView().setVisibility(View.GONE);
            adView.findViewById(R.id.icon_image_container).setVisibility(View.GONE);
        } else {
            ((ImageView) adView.getIconView()).setImageDrawable(
                    nativeAd.getIcon().getDrawable());
            adView.getIconView().setVisibility(View.VISIBLE);
        }
        adView.setNativeAd(nativeAd);

        return adView;

    }

    private void loadAdmob(String unitId, final OnAdLoadedListener listener) {
        AdLoader.Builder builder = new AdLoader.Builder(mContext, unitId);

        builder.forUnifiedNativeAd(new UnifiedNativeAd.OnUnifiedNativeAdLoadedListener() {
            @Override
            public void onUnifiedNativeAdLoaded(UnifiedNativeAd unifiedNativeAd) {

                UnifiedNativeAdView adView = (UnifiedNativeAdView) LayoutInflater.from(mContext)
                        .inflate(R.layout.visual_admob_view, null);

                populateUnifiedNativeAdView(unifiedNativeAd, adView);

                if(listener != null) {
                    listener.onAdLoaded(adView);
                }
            }

        });

        VideoOptions videoOptions = new VideoOptions.Builder()
                .setStartMuted(true)
                .build();

        NativeAdOptions adOptions = new NativeAdOptions.Builder()
                .setVideoOptions(videoOptions)
                .build();

        builder.withNativeAdOptions(adOptions);

        AdLoader adLoader = builder.withAdListener(new AdListener() {

            @Override
            public void onAdFailedToLoad(int errorCode) {
                if(listener != null) {
                    listener.onAdLoaded(null);
                }
            }
        }).build();


        AdRequest nativeAdRequest = new AdRequest.Builder()
                .build();
        adLoader.loadAd(nativeAdRequest);
    }

    private void setBgColor(View view, String bgColor) {
        try {
            if(!TextUtils.isEmpty(bgColor)) {
                view.setBackgroundResource(R.drawable.round);
                GradientDrawable drawable = (GradientDrawable) view.getBackground();
                drawable.setColor(Color.parseColor(bgColor));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void setTextColor(TextView view, String textColor) {
        try {
            if(!TextUtils.isEmpty(textColor)) {
                view.setTextColor(Color.parseColor(textColor));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
