/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.CardView;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.VisualServiceImpl;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.AdManager;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.ExcelManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.SecretKeyManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.model.parser.PopupData;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.parser.loader.BulkLoader;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.ResourceRepository;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.ActivityCallback;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.DatePickerFragment;
import com.tenqube.visual_third.ui.TimePickerFragment;
import com.tenqube.visual_third.ui.VisualPermissionActivity;
import com.tenqube.visual_third.ui.VisualProgressDialogFragment;
import com.tenqube.visual_third.util.PathUtil;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.Validator;
import com.tenqube.visual_third.util.WebViewHelper;
import com.tenqube.visual_third.util.permission.AfterPermissionGranted;
import com.tenqube.visual_third.util.permission.PermissionUtil;
import com.tenqube.visual_third.web.ActionImpl;
import com.tenqube.visual_third.web.ErrorImpl;
import com.tenqube.visual_third.web.LogImpl;
import com.tenqube.visual_third.web.RepoImpl;
import com.tenqube.visual_third.web.SystemImpl;
import com.tenqube.visual_third.web.UiImpl;
import com.tenqube.visual_third.web.VisualInterface;
import java.io.File;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualWebActivity
extends AppCompatActivity
implements TimePickerFragment.Callback,
DatePickerFragment.Callback,
PermissionUtil.PermissionCallbacks,
ActivityCallback {
    public static final String ARG_PATH = "ARG_PATH";
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    public static final int NOTIFICATION_REQUEST_CODE = 10;
    public static final int VISUAL_REQUEST_CODE = 512;
    public static final int PERMISSION_REQUEST_CODE = 0;
    public static final int FINISH = 10;
    public static final int PROGRESS = 11;
    public static final int SHOW_PROGRESS_BAR = 12;
    public static final int ERROR = 13;
    private VisualProgressDialogFragment progressDialog;
    private BulkLoader bulkLoader;
    private VisualRepository repository;
    private ResourceRepository resourceRepository;
    private VisualAlarmManager alarmManager;
    private boolean isPageLoaded;
    private String mFailingUrl;
    private String baseUrl = "";
    private String path;
    private WebView webview;
    private VisualInterface.Repo repoInterface;
    private VisualInterface.UI uiInterface;
    private VisualInterface.System systemInterface;
    private VisualInterface.Error errorInterface;
    private VisualInterface.Log logInterface;
    private VisualInterface.Action actionInterface;
    private SwipeRefreshLayout swipeRefreshLayout;
    private LinearLayout errorView;
    private boolean isError;
    private FrameLayout webContainer;
    private CardView adContainer;
    private BroadcastReceiver transactionReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                final int tranId = intent.getIntExtra("tranId", 0);
                Log.i((String)"VisualFlow", (String)("transactionReceiver: tranId" + tranId));
                VisualWebActivity.this.webview.post(new Runnable(){

                    @Override
                    public void run() {
                        if (tranId != 0) {
                            VisualWebActivity.this.webview.loadUrl("javascript:window.onTransactionReceived(" + tranId + ");");
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            try {
                LogUtil.LOGI((String)"VisualFlow", (String)("startBulk handleMessage" + msg.what), (boolean)ParserService.mIsDebug);
                switch (msg.what) {
                    case 11: {
                        Bundle bundle;
                        LogUtil.LOGI((String)"VisualFlow", (String)"startBulk handleMessage PROGRESS", (boolean)ParserService.mIsDebug);
                        if (VisualWebActivity.this.progressDialog != null && VisualWebActivity.this.progressDialog.isAdded() && (bundle = msg.getData()) != null) {
                            VisualWebActivity.this.progressDialog.setProgressValue(bundle.getInt("now"), bundle.getInt("total"), bundle.getInt("percent"));
                        }
                        break;
                    }
                    case 12: {
                        LogUtil.LOGI((String)"VisualFlow", (String)"startBulk handleMessage SHOW_PROGRESS_BAR", (boolean)ParserService.mIsDebug);
                        try {
                            if (VisualWebActivity.this.progressDialog == null) {
                                VisualWebActivity.this.progressDialog = VisualProgressDialogFragment.newInstance();
                                VisualWebActivity.this.progressDialog.setCancelable(false);
                            }
                            if (!VisualWebActivity.this.progressDialog.isAdded()) {
                                FragmentManager fragmentManager = VisualWebActivity.this.getSupportFragmentManager();
                                if (fragmentManager != null) {
                                    LogUtil.LOGI((String)"VisualFlow", (String)"startBulk handleMessage  progress beginTransaction", (boolean)ParserService.mIsDebug);
                                    fragmentManager.beginTransaction().add((Fragment)VisualWebActivity.this.progressDialog, VisualProgressDialogFragment.TAG).commitAllowingStateLoss();
                                    break;
                                }
                                LogUtil.LOGI((String)"VisualFlow", (String)"startBulk handleMessage fragmentManager null", (boolean)ParserService.mIsDebug);
                                break;
                            }
                            LogUtil.LOGI((String)"VisualFlow", (String)"startBulk handleMessage progressDialog.isAdded() false", (boolean)ParserService.mIsDebug);
                        }
                        catch (Exception e) {
                            LogUtil.LOGI((String)"VisualFlow", (String)("startBulk handleMessage  progress Exception" + e.toString()), (boolean)ParserService.mIsDebug);
                            VisualWebActivity.this.progressDialog = null;
                        }
                        break;
                    }
                    default: {
                        LogUtil.LOGI((String)"VisualFlow", (String)"startBulk handleMessage onBulkFinish", (boolean)ParserService.mIsDebug);
                        VisualWebActivity.this.onBulkFinish();
                    }
                }
            }
            catch (Exception e) {
                LogUtil.LOGI((String)"VisualFlow", (String)("startBulk handleMessage Exception" + e.toString()), (boolean)ParserService.mIsDebug);
                VisualWebActivity.this.onBulkFinish();
            }
            return false;
        }
    });
    public static final String[] PERMISSIONS_STORAGE = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
    public static final int STORAGE = 1;
    public Callback<Boolean> completion;

    @SuppressLint(value={"JavascriptInterface", "AddJavascriptInterface", "SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            LogUtil.LOGI((String)"VisualFlow", (String)"start VisualActivity", (boolean)ParserService.mIsDebug);
            this.changeStatusColor();
            if (Utils.isSDKDisabled(this.getApplicationContext())) {
                throw new Exception("SDK disabled");
            }
            AnswerManager.initFabric((Context)this);
            AnswerManager.onKeyMetric(new LogRequest("VisualWebActivity"));
            this.repository = RepositoryHolder.getInstance(this.getApplicationContext()).getVisualRepository();
            this.resourceRepository = RepositoryHolder.getInstance(this.getApplicationContext()).getResourceRepository();
            this.alarmManager = VisualAlarmManager.getInstance(this.getApplicationContext());
            this.path = this.getIntent().getStringExtra(ARG_PATH);
            if (this.path == null) {
                this.path = "";
            }
            this.setContentView(R.layout.activity_visual_web);
            this.swipeRefreshLayout = (SwipeRefreshLayout)this.findViewById(R.id.swipe_refresh_layout);
            this.swipeRefreshLayout.setEnabled(false);
            this.swipeRefreshLayout.setColorSchemeResources(new int[]{R.color.colorPopupRed, R.color.colorPopupRed, R.color.colorPopupRed});
            this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

                public void onRefresh() {
                    VisualWebActivity.this.swipeRefreshLayout.setRefreshing(false);
                    AnalysisServiceImpl.shouldRefresh = true;
                    VisualWebActivity.this.webview.reload();
                }
            });
            this.webContainer = (FrameLayout)this.findViewById(R.id.web_container);
            this.errorView = (LinearLayout)this.findViewById(R.id.error_container);
            this.errorView.setVisibility(8);
            this.findViewById(R.id.retry).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    VisualWebActivity.this.retry();
                }
            });
            this.webview = (WebView)this.findViewById(R.id.visual_web_view);
            this.errorInterface = new ErrorImpl(this, this.webview);
            this.logInterface = new LogImpl(this, this.webview, this.errorInterface);
            this.repoInterface = new RepoImpl(this, this.webview, this.errorInterface, this.repository, new AnalysisServiceImpl((Context)this, ""), this.alarmManager);
            this.uiInterface = new UiImpl(this, this.webview, this.errorInterface, new BottomDialog((Activity)this), AdManager.getInstance(this.getApplicationContext()));
            this.systemInterface = new SystemImpl(this, this.webview, this.errorInterface);
            this.actionInterface = new ActionImpl(this, this.webview);
            this.webview.addJavascriptInterface((Object)this.errorInterface, "visualError");
            this.webview.addJavascriptInterface((Object)this.repoInterface, "visualRepo");
            this.webview.addJavascriptInterface((Object)this.uiInterface, "visualUI");
            this.webview.addJavascriptInterface((Object)this.systemInterface, "visualSystem");
            this.webview.addJavascriptInterface((Object)this.logInterface, "visualLog");
            this.webview.addJavascriptInterface((Object)this.actionInterface, "visualAction");
            WebViewHelper.settings(this.webview, this.repository.isDev());
            this.webview.setWebViewClient(new WebViewClient(){

                public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                    if (!view.getUrl().contains(VisualWebActivity.this.baseUrl)) {
                        VisualWebActivity.this.finish();
                        return true;
                    }
                    return super.shouldOverrideUrlLoading(view, request);
                }

                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    if (!url.contains(VisualWebActivity.this.baseUrl)) {
                        VisualWebActivity.this.finish();
                        return true;
                    }
                    return super.shouldOverrideUrlLoading(view, url);
                }

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    VisualWebActivity.this.isError = true;
                    VisualWebActivity.this.mFailingUrl = failingUrl;
                    VisualWebActivity.this.loadErrorUrl();
                }

                public void onPageFinished(WebView view, String url) {
                    if (!VisualWebActivity.this.isError) {
                        VisualWebActivity.this.errorView.setVisibility(8);
                    }
                    VisualWebActivity.this.isError = false;
                    super.onPageFinished(view, url);
                }
            });
            if (this.shouldRequestOverlayPermission()) {
                VisualPermissionActivity.startActivity((Activity)this, 0);
            } else {
                this.startVisual();
            }
        }
        catch (Exception e) {
            this.finish();
        }
    }

    private void startVisual() {
        this.loadUrl(this.path);
        if (this.repository.shouldBulk()) {
            this.startBulkParsing();
        } else {
            LogUtil.LOGI((String)"VisualFlow", (String)"Already Done bulk", (boolean)ParserService.mIsDebug);
            this.alarmManager.setAlarms();
            this.resourceRepository.sync();
        }
    }

    private void onBulkFinish() {
        this.repository.saveBulk();
        if (this.progressDialog != null && this.progressDialog.isAdded()) {
            this.progressDialog.dismissAllowingStateLoss();
        }
        this.webview.reload();
    }

    private void startBulkParsing() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LogUtil.LOGI((String)"VisualFlow", (String)"startBulk parsing", (boolean)ParserService.mIsDebug);
                    LogUtil.LOGI((String)TAG, (String)"startBulkParsing start", (boolean)ParserService.mIsDebug);
                    VisualWebActivity.this.bulkLoader = new BulkLoader((Context)VisualWebActivity.this, VisualWebActivity.this.handler, new BulkLoader.OnSmsLoadFinished(){

                        @Override
                        public void onFinished(boolean isError) {
                            try {
                                if (VisualWebActivity.this.handler != null) {
                                    VisualWebActivity.this.handler.sendEmptyMessage(10);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    LogUtil.LOGI((String)TAG, (String)"2. \ud504\ub85c\uadf8\ub808\uc2a4 \ub2e4\uc774\uc5bc\ub85c\uadf8 show", (boolean)ParserService.mIsDebug);
                    VisualWebActivity.this.handler.sendEmptyMessage(12);
                    LogUtil.LOGI((String)TAG, (String)"3. \uc9c0\ub09c 6\uac1c\uc6d4 \ubb38\uc790 \ud30c\uc2f1 \uc2dc\uc791", (boolean)ParserService.mIsDebug);
                    VisualWebActivity.this.bulkLoader.doParsing();
                }
                catch (Exception e) {
                    VisualWebActivity.this.handler.sendEmptyMessage(13);
                }
            }
        }).start();
    }

    private void changeStatusColor() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().clearFlags(0x4000000);
            this.getWindow().addFlags(Integer.MIN_VALUE);
            this.getWindow().setStatusBarColor(Color.parseColor((String)"#20000000"));
            this.getWindow().setNavigationBarColor(Color.parseColor((String)"#333333"));
            this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(-1));
            if (Build.VERSION.SDK_INT >= 23) {
                this.getWindow().setStatusBarColor(0);
                View decor = this.getWindow().getDecorView();
                decor.setBackgroundColor(-1);
                decor.setSystemUiVisibility(8192);
            }
        }
    }

    @Override
    public void exportExcel(Callback<Boolean> callback) {
        this.completion = callback;
        this.exportExcel();
    }

    @Override
    public Context getContext() {
        return this.getApplicationContext();
    }

    public AppCompatActivity getActivity() {
        return this;
    }

    @Override
    public void onPagedLoaded() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                VisualWebActivity.this.isPageLoaded = true;
            }
        });
    }

    private void loadUrl(String path) {
        if (this.webview != null) {
            this.isPageLoaded = false;
            if (path == null) {
                path = "";
            }
            this.baseUrl = WebViewHelper.getBaseUrl(PrefManager.getInstance(this.getApplicationContext()));
            this.webview.loadUrl(this.baseUrl + path);
        }
    }

    private void loadErrorUrl() {
        this.isPageLoaded = false;
        if (this.swipeRefreshLayout != null) {
            this.swipeRefreshLayout.setEnabled(false);
        }
        this.errorView.setVisibility(0);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 10) {
            boolean isEnabled = Utils.isNotiEnabled(this.getApplicationContext());
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("isNotiEnabled", isEnabled);
                String json = jsonObject.toString();
                if (this.systemInterface != null) {
                    this.systemInterface.onNotiCallback(json);
                }
            }
            catch (JSONException jSONException) {}
        } else if (requestCode == 0) {
            if (this.shouldRequestOverlayPermission()) {
                this.finish();
            } else {
                this.startVisual();
            }
        }
    }

    public void onBackPressed() {
        try {
            if (this.isPageLoaded && this.uiInterface != null) {
                this.uiInterface.onFinish();
            } else {
                super.onBackPressed();
            }
        }
        catch (Exception e) {
            super.onBackPressed();
        }
    }

    public void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.transactionReceiver, new IntentFilter("tenqube.intent.action.ACTION_TRANSACTION_RECEIVED"));
        this.repository.setVisualActive(true);
        this.overridePendingTransition(0, 0);
    }

    public void onPause() {
        super.onPause();
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.transactionReceiver);
        this.repository.setVisualActive(false);
        this.overridePendingTransition(0, 0);
    }

    @Override
    public void onCalendar(String date, String callback) {
        this.uiInterface.onCalendar(date, callback);
    }

    @Override
    public void onScrollChanged(int pos) {
    }

    @Override
    public void setRefreshEnabled(final boolean enabled) {
        this.swipeRefreshLayout.post(new Runnable(){

            @Override
            public void run() {
                VisualWebActivity.this.swipeRefreshLayout.setEnabled(enabled);
            }
        });
    }

    @Override
    public void addAd(View view) {
        try {
            this.webContainer.addView((View)this.createCardView(view));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CardView createCardView(View view) {
        this.adContainer = new CardView((Context)this);
        this.adContainer.setCardElevation(this.getResources().getDimension(R.dimen.elevation));
        if (Build.VERSION.SDK_INT >= 21) {
            this.adContainer.setElevation(this.getResources().getDimension(R.dimen.elevation));
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.setMargins(Utils.dpToPx(10), Utils.dpToPx(16), Utils.dpToPx(10), Utils.dpToPx(16));
        params.gravity = 80;
        this.adContainer.setLayoutParams((ViewGroup.LayoutParams)params);
        this.adContainer.setRadius((float)Utils.dpToPx(13));
        this.adContainer.setCardBackgroundColor(Color.parseColor((String)"#00000000"));
        this.adContainer.addView(view);
        return this.adContainer;
    }

    @Override
    public void hideAd() {
        try {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (VisualWebActivity.this.adContainer != null) {
                        VisualWebActivity.this.webContainer.removeView((View)VisualWebActivity.this.adContainer);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public TransactionPopupInfo getPopUpInfo() {
        return null;
    }

    @Override
    public void setStatusBarColor(String color2) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                this.getWindow().setStatusBarColor(Color.parseColor((String)color2));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void reload() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualWebActivity.this.webview.reload();
                }
            });
        }
    }

    @Override
    public void retry() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualWebActivity.this.webview.loadUrl(VisualWebActivity.this.mFailingUrl);
                }
            });
        }
    }

    @AfterPermissionGranted(value=1)
    public void exportExcel() {
        if (PermissionUtil.hasPermissions((Context)this, PERMISSIONS_STORAGE)) {
            ExcelManager.getInstance((Context)this).export(new ExcelManager.Callback(){

                @Override
                public void onCompleted(File file) {
                    boolean isSuccess;
                    boolean bl = isSuccess = file != null;
                    if (isSuccess) {
                        String authority = VisualWebActivity.this.repository.getAuthority();
                        try {
                            Intent intent = new Intent("android.intent.action.SEND");
                            intent.setType("application/octet-stream");
                            intent.putExtra("android.intent.extra.STREAM", (Parcelable)Utils.getUri(VisualWebActivity.this.getApplicationContext(), authority, file));
                            VisualWebActivity.this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"\uacf5\uc720"));
                            Toast.makeText((Context)VisualWebActivity.this.getApplicationContext(), (CharSequence)VisualWebActivity.this.getString(R.string.visual_export_excel_success_msg, new Object[]{file.getName()}), (int)0).show();
                        }
                        catch (Exception e) {
                            String log = "authority:" + authority + "\n FileProvider Error";
                            Toast.makeText((Context)VisualWebActivity.this.getApplicationContext(), (CharSequence)log, (int)0).show();
                            VisualWebActivity.this.completion.onDataLoaded(false);
                            return;
                        }
                    }
                    VisualWebActivity.this.completion.onDataLoaded(isSuccess);
                }
            });
        } else {
            PermissionUtil.requestPermissions((Activity)this, 1, PERMISSIONS_STORAGE);
        }
    }

    @Override
    public void onPermissionsGranted(int requestCode, List<String> list) {
        if (requestCode == 1) {
            this.exportExcel();
        }
    }

    @Override
    public void onPermissionsDenied(int requestCode, List<String> list) {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"\uc5d1\uc140 \ud30c\uc77c \ub0b4\ubcf4\ub0b4\uae30\ub97c \uc704\ud574 \uc678\ubd80 \uc800\uc7a5\uc18c\uc5d0 \ub300\ud55c \uad8c\ud55c\uc774 \ud544\uc694\ud569\ub2c8\ub2e4. \uad8c\ud55c\uc774 \uc5c6\ub294 \uacbd\uc6b0 \uc5d1\uc140 \ud30c\uc77c \ub0b4\ubcf4\ub0b4\uae30 \uc0ac\uc6a9\uc774 \ubd88\uac00\ud569\ub2c8\ub2e4.", (int)0).show();
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PermissionUtil.onRequestPermissionsResult(requestCode, permissions, grantResults, this);
    }

    public static void startActivity(Activity activity, String path) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)SecretKeyManager.getInstance((Context)activity).getKey("TENQUBE_ACCESS_TOKEN"))) {
            throw new AuthException("Need to sign up");
        }
        Intent intent = new Intent((Context)activity, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        intent.addFlags(0x4020000);
        activity.startActivityForResult(intent, 512);
    }

    public static void startActivity(Context context, String path) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)SecretKeyManager.getInstance(context).getKey("TENQUBE_ACCESS_TOKEN"))) {
            throw new AuthException("Need to sign up");
        }
        Intent intent = new Intent(context, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        intent.addFlags(335675392);
        context.startActivity(intent);
    }

    public static void startActivity(@NonNull Context context, @NonNull PopupData popupData) throws AuthException, ParameterException {
        Validator.notNull(context);
        Validator.notNull(popupData);
        if (TextUtils.isEmpty((CharSequence)SecretKeyManager.getInstance(context).getKey("TENQUBE_ACCESS_TOKEN"))) {
            throw new AuthException("Need to sign up");
        }
        Intent intent = new Intent(context, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, PathUtil.makePath(popupData));
        intent.addFlags(335675392);
        context.startActivity(intent);
    }

    public boolean shouldRequestOverlayPermission() {
        return PermissionUtil.shouldRequestOverlayPermission(this.getApplication().getApplicationContext()) && this.repository.isActiveTranPopup();
    }
}

