package com.tenqube.visual_third.entity;

import java.io.Serializable;

public class UserCategory implements Serializable {

    private int id;
    private int code;
    private boolean isExcept;
    private boolean isMain;

    public UserCategory(int id, int code, boolean isExcept, boolean isMain) {
        this.id = id;
        this.code = code;
        this.isExcept = isExcept;
        this.isMain = isMain;
    }

    public String getInsertValue() {
        return "(" +
                id + "," +
                code + "," +
                (isExcept ?1:0) +  "," +
               (isMain ?1:0) + ")";
    }


    public int getId() {
        return id;
    }

    public int getCode() {
        return code;
    }

    public boolean isExcept() {
        return isExcept;
    }

    public boolean isMain() {
        return isMain;
    }

    @Override
    public String toString() {
        return "UserCategory{" +
                "id=" + id +
                ", code=" + code +
                ", isExcept=" + isExcept +
                ", isMain=" + isMain +
                '}';
    }
}
