package com.tenqube.visual_scraper.crawler;

import android.content.Context;
import android.webkit.WebView;

import com.tenqube.visual_scraper.crawler.manager.WebManager;
import com.tenqube.visual_scraper.crawler.model.CrawlerRequestData;
import com.tenqube.visual_scraper.crawler.model.CrawlerUrl;

import static com.tenqube.visual_scraper.crawler.ScrapInterface.SHOW_HTML_JS;

public class Crawler implements WebManager.OnWebInteractionListener {

    final WebManager webManager;

    final Context context;

    final CrawlerRequestData requestData;

    final CrawlerCallback crawlerCallback;

    CrawlerUrl mUrl;

    Crawler(Context context,
            CrawlerRequestData requestData,
            CrawlerCallback crawlerCallback) {

        this.context = context;
        this.requestData = requestData;
        this.crawlerCallback = crawlerCallback;

        this.webManager = new WebManager(context, this);
    }

    public void start() {
        loadUrl(getCrawlerUrl().getUrl());
    }

    void loadUrl(String url) {
        webManager.loadUrl(url);
    }

    public CrawlerUrl getCrawlerUrl() {
        mUrl = requestData.getUrls().poll();
        return mUrl;
    }

    @Override
    public int getTimeOut() {
        return requestData.getTimeOut();
    }

    @Override
    public void onTimeOut() {
        crawlerCallback.onFail("time out");
    }

    @Override
    public void showHtml(String html) {
        crawlerCallback.onComplete(html);
    }


    @Override
    public void checkHtml(String html) {

    }

    @Override
    public void onReceivedError(String msg) {
        crawlerCallback.onFail(msg);
    }

    @Override
    public void onPageFinished(WebView view, String url) {

        CrawlerUrl crawlerUrl = getCrawlerUrl();
        if(crawlerUrl == null) {
            loadUrl(SHOW_HTML_JS);
        } else {
            loadUrl(crawlerUrl.getUrl());
        }
    }


}
