/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db.entity;

import androidx.annotation.Nullable;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import com.tenqube.visual_scraper.db.converter.OrderRuleConverter;
import com.tenqube.visual_scraper.db.converter.QueryRuleConverter;
import com.tenqube.visual_scraper.db.entity.MallEntity;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import java.io.Serializable;

@Entity(tableName="login_web_rules", indices={@Index(value={"mall_id"}, unique=true)}, foreignKeys={@ForeignKey(entity=MallEntity.class, parentColumns={"m_id"}, childColumns={"mall_id"})})
@TypeConverters(value={QueryRuleConverter.class, OrderRuleConverter.class})
public class LoginWebRule
implements Serializable {
    @PrimaryKey(autoGenerate=true)
    @ColumnInfo(name="id")
    private int id;
    @ColumnInfo(name="mall_id")
    private final int mallId;
    @Nullable
    @ColumnInfo(name="web_url")
    private final QueryRuleBody url;
    @Nullable
    @ColumnInfo(name="loginScripts")
    private final QueryRuleBody loginScripts;
    @ColumnInfo(name="captcha_container")
    private final ParsingOrderRules captchaContainer;
    @ColumnInfo(name="fail_message")
    private final ParsingOrderRules failMessage;

    public LoginWebRule(int mallId, @Nullable QueryRuleBody url, @Nullable QueryRuleBody loginScripts, ParsingOrderRules captchaContainer, ParsingOrderRules failMessage) {
        this.mallId = mallId;
        this.url = url;
        this.loginScripts = loginScripts;
        this.captchaContainer = captchaContainer;
        this.failMessage = failMessage;
    }

    public int getId() {
        return this.id;
    }

    public int getMallId() {
        return this.mallId;
    }

    @Nullable
    public QueryRuleBody getUrl() {
        return this.url;
    }

    @Nullable
    public QueryRuleBody getLoginScripts() {
        return this.loginScripts;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ParsingOrderRules getCaptchaContainer() {
        return this.captchaContainer;
    }

    public ParsingOrderRules getFailMessage() {
        return this.failMessage;
    }

    public String toString() {
        return "LoginWebRule{id=" + this.id + ", mallId='" + this.mallId + '\'' + ", url='" + this.url + '\'' + ", loginScripts='" + this.loginScripts + '\'' + ", captchaContainer='" + this.captchaContainer + '\'' + ", failMessage='" + this.failMessage + '\'' + '}';
    }
}

