/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.tenqube.visual_scraper.db.converter.OrderRuleConverter;
import com.tenqube.visual_scraper.db.converter.QueryRuleConverter;
import com.tenqube.visual_scraper.db.dao.LoginWebRuleDao;
import com.tenqube.visual_scraper.db.entity.LoginWebRule;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import java.util.ArrayList;
import java.util.List;

public final class LoginWebRuleDao_Impl
implements LoginWebRuleDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<LoginWebRule> __insertionAdapterOfLoginWebRule;

    public LoginWebRuleDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfLoginWebRule = new EntityInsertionAdapter<LoginWebRule>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `login_web_rules` (`id`,`mall_id`,`web_url`,`loginScripts`,`captcha_container`,`fail_message`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, LoginWebRule value) {
                stmt.bindLong(1, (long)value.getId());
                stmt.bindLong(2, (long)value.getMallId());
                String _tmp = QueryRuleConverter.fromOrderRules(value.getUrl());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                String _tmp_1 = QueryRuleConverter.fromOrderRules(value.getLoginScripts());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                String _tmp_2 = OrderRuleConverter.fromOrderRules(value.getCaptchaContainer());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = OrderRuleConverter.fromOrderRules(value.getFailMessage());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> insertList(List<LoginWebRule> loginWebRule) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            List _result = this.__insertionAdapterOfLoginWebRule.insertAndReturnIdsList(loginWebRule);
            this.__db.setTransactionSuccessful();
            List list = _result;
            return list;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LoginWebRule> findAll() {
        String _sql = "SELECT * FROM login_web_rules ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM login_web_rules ", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfMallId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mall_id");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"web_url");
            int _cursorIndexOfLoginScripts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"loginScripts");
            int _cursorIndexOfCaptchaContainer = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"captcha_container");
            int _cursorIndexOfFailMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fail_message");
            ArrayList<LoginWebRule> _result = new ArrayList<LoginWebRule>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                int _tmpMallId = _cursor.getInt(_cursorIndexOfMallId);
                String _tmp = _cursor.getString(_cursorIndexOfUrl);
                QueryRuleBody _tmpUrl = QueryRuleConverter.toParsingOrderRule(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfLoginScripts);
                QueryRuleBody _tmpLoginScripts = QueryRuleConverter.toParsingOrderRule(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfCaptchaContainer);
                ParsingOrderRules _tmpCaptchaContainer = OrderRuleConverter.toParsingOrderRule(_tmp_2);
                String _tmp_3 = _cursor.getString(_cursorIndexOfFailMessage);
                ParsingOrderRules _tmpFailMessage = OrderRuleConverter.toParsingOrderRule(_tmp_3);
                LoginWebRule _item = new LoginWebRule(_tmpMallId, _tmpUrl, _tmpLoginScripts, _tmpCaptchaContainer, _tmpFailMessage);
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                _result.add(_item);
            }
            ArrayList<LoginWebRule> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoginWebRule findById(int mId) {
        String _sql = "SELECT * FROM login_web_rules WHERE mall_id = ? ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM login_web_rules WHERE mall_id = ? ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)mId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            LoginWebRule _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfMallId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mall_id");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"web_url");
            int _cursorIndexOfLoginScripts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"loginScripts");
            int _cursorIndexOfCaptchaContainer = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"captcha_container");
            int _cursorIndexOfFailMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fail_message");
            if (_cursor.moveToFirst()) {
                int _tmpMallId = _cursor.getInt(_cursorIndexOfMallId);
                String _tmp = _cursor.getString(_cursorIndexOfUrl);
                QueryRuleBody _tmpUrl = QueryRuleConverter.toParsingOrderRule(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfLoginScripts);
                QueryRuleBody _tmpLoginScripts = QueryRuleConverter.toParsingOrderRule(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfCaptchaContainer);
                ParsingOrderRules _tmpCaptchaContainer = OrderRuleConverter.toParsingOrderRule(_tmp_2);
                String _tmp_3 = _cursor.getString(_cursorIndexOfFailMessage);
                ParsingOrderRules _tmpFailMessage = OrderRuleConverter.toParsingOrderRule(_tmp_3);
                _result = new LoginWebRule(_tmpMallId, _tmpUrl, _tmpLoginScripts, _tmpCaptchaContainer, _tmpFailMessage);
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _result.setId(_tmpId);
            } else {
                _result = null;
            }
            LoginWebRule loginWebRule = _result;
            return loginWebRule;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Cursor findList() {
        String _sql = "SELECT * FROM login_web_rules ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM login_web_rules ", (int)0);
        Cursor _tmpResult = this.__db.query((SupportSQLiteQuery)_statement);
        return _tmpResult;
    }
}

