/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.shared.util;

import android.content.Context;
import android.util.Log;
import com.tenqube.visual_scraper.shared.error.FormatNotMatchedException;
import com.tenqube.visual_scraper.shared.util.CommonExtKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0014J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0014J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0004J\u0006\u0010\u001c\u001a\u00020\fJ\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004J\u001c\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010$2\u0006\u0010%\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006&"}, d2={"Lcom/tenqube/visual_scraper/shared/util/Utils;", "", "()V", "TAG", "", "isDebug", "", "()Z", "setDebug", "(Z)V", "convertCalendarToDateStr", "date", "Ljava/util/Calendar;", "convertCalendarToDateTimeStr", "convertCalendarToMonthStr", "convertCalendarToSyncDateStr", "convertCalendarToTimeStr", "convertDateStrToCalendar", "str", "convertDateStrToDate", "Ljava/util/Date;", "convertDateTimeStrToCalendar", "convertDateTimeStrToDate", "convertDateToDateStr", "convertDateToDateTimeStr", "convertHMSStrToDate", "convertTimeStrToCalendar", "convertTimeStrToDate", "getCurrentWeekMonday", "getJsonDataFromAsset", "context", "Landroid/content/Context;", "fileName", "logD", "", "className", "Ljava/lang/Class;", "msg", "app_release"})
public final class Utils {
    private static boolean isDebug;
    @NotNull
    public static final String TAG = "VisualSDK";
    public static final Utils INSTANCE;

    public final boolean isDebug() {
        return isDebug;
    }

    public final void setDebug(boolean bl) {
        isDebug = bl;
    }

    public final void logD(@NotNull Class<Object> className, @NotNull String msg) {
        Intrinsics.checkParameterIsNotNull(className, (String)"className");
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        if (isDebug) {
            Log.d((String)TAG, (String)(className.getSimpleName() + ' ' + msg));
        }
    }

    @NotNull
    public final String convertDateToDateTimeStr(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        String string = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.KOREA).format(date);
        if (string == null) {
            throw (Throwable)new FormatNotMatchedException("Date Format Not Matched");
        }
        return string;
    }

    @NotNull
    public final Date convertDateStrToDate(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Date date = new SimpleDateFormat("yyyy-MM-dd", Locale.KOREA).parse(str);
        if (date == null) {
            throw (Throwable)new FormatNotMatchedException("Date Format Not Matched");
        }
        return date;
    }

    @NotNull
    public final Date convertHMSStrToDate(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Date date = new SimpleDateFormat("HH:mm:ss", Locale.KOREA).parse(str);
        if (date == null) {
            throw (Throwable)new FormatNotMatchedException("Date Format Not Matched");
        }
        return date;
    }

    @NotNull
    public final String convertDateToDateStr(@NotNull Date str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        String string = new SimpleDateFormat("yyyy-MM-dd", Locale.KOREA).format(str);
        if (string == null) {
            throw (Throwable)new FormatNotMatchedException("Date Format Not Matched");
        }
        return string;
    }

    @NotNull
    public final Date convertDateTimeStrToDate(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.KOREA).parse(str);
        if (date == null) {
            throw (Throwable)new FormatNotMatchedException("Date Format Not Matched");
        }
        return date;
    }

    @NotNull
    public final Calendar convertDateTimeStrToCalendar(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Calendar calendar = Calendar.getInstance();
        boolean bl = false;
        boolean bl2 = false;
        Calendar $this$apply = calendar;
        boolean bl3 = false;
        $this$apply.setTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.KOREA).parse(str));
        Calendar calendar2 = calendar;
        if (calendar2 == null) {
            throw (Throwable)new FormatNotMatchedException("Date Format Not Matched");
        }
        return calendar2;
    }

    @NotNull
    public final Calendar convertDateStrToCalendar(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Calendar calendar = Calendar.getInstance();
        boolean bl = false;
        boolean bl2 = false;
        Calendar $this$apply = calendar;
        boolean bl3 = false;
        $this$apply.setTime(new SimpleDateFormat("yyyy-MM-dd", Locale.KOREA).parse(str));
        Calendar calendar2 = calendar;
        if (calendar2 == null) {
            throw (Throwable)new FormatNotMatchedException("Date Format Not Matched");
        }
        return calendar2;
    }

    @NotNull
    public final String convertCalendarToDateStr(@NotNull Calendar date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        String string = new SimpleDateFormat("yyyy-MM-dd", Locale.KOREA).format(date.getTime());
        if (string == null) {
            throw (Throwable)new FormatNotMatchedException("Date Format Not Matched");
        }
        return string;
    }

    @NotNull
    public final Calendar convertTimeStrToCalendar(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Calendar calendar = Calendar.getInstance();
        boolean bl = false;
        boolean bl2 = false;
        Calendar $this$apply = calendar;
        boolean bl3 = false;
        $this$apply.setTime(new SimpleDateFormat("HH:mm:ss", Locale.KOREA).parse(str));
        Calendar calendar2 = calendar;
        if (calendar2 == null) {
            throw (Throwable)new FormatNotMatchedException("Date Format Not Matched");
        }
        return calendar2;
    }

    @NotNull
    public final String convertCalendarToTimeStr(@NotNull Calendar date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        String string = new SimpleDateFormat("HH:mm:ss", Locale.KOREA).format(date.getTime());
        if (string == null) {
            throw (Throwable)new FormatNotMatchedException("Date Format Not Matched");
        }
        return string;
    }

    @NotNull
    public final String convertCalendarToMonthStr(@NotNull Calendar date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        String string = new SimpleDateFormat("yyyy-MM", Locale.KOREA).format(date.getTime());
        if (string == null) {
            throw (Throwable)new FormatNotMatchedException("Date Format Not Matched");
        }
        return string;
    }

    @NotNull
    public final String convertCalendarToDateTimeStr(@NotNull Calendar date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        String string = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.KOREA).format(date.getTime());
        if (string == null) {
            throw (Throwable)new FormatNotMatchedException("Date Format Not Matched");
        }
        return string;
    }

    @NotNull
    public final String convertCalendarToSyncDateStr(@NotNull Calendar date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        String string = new SimpleDateFormat("yyyyMMddHHmmss", Locale.KOREA).format(date.getTime());
        if (string == null) {
            throw (Throwable)new FormatNotMatchedException("Date Format Not Matched");
        }
        return string;
    }

    @NotNull
    public final Date convertTimeStrToDate(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Date date = new SimpleDateFormat("HH:mm:ss", Locale.KOREA).parse(str);
        if (date == null) {
            throw (Throwable)new FormatNotMatchedException("Date Format Not Matched");
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getJsonDataFromAsset(@NotNull Context context, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Object jsonString = null;
        try {
            InputStream inputStream = context.getAssets().open(fileName);
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"context.assets.open(fileName)");
            Closeable closeable = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Object object = closeable;
            int n = 0;
            object = new InputStreamReader((InputStream)object, charset);
            n = 8192;
            boolean bl2 = false;
            closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl4 = false;
                object = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            jsonString = object;
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return null;
        }
        return jsonString;
    }

    @NotNull
    public final Calendar getCurrentWeekMonday() {
        Calendar calendar = Calendar.getInstance();
        int dayOfWeek = CommonExtKt.dayOfWeek(calendar.get(7));
        calendar.add(5, -(dayOfWeek - 1));
        Calendar calendar2 = calendar;
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"calendar");
        return calendar2;
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }
}

