/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.mall;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.tenqube.visual_scraper.mall.Mall;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;

public class Hmall
extends Mall {
    public Hmall(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

    @Override
    public String getBaseUrl() {
        return "https://www.hyundaihmall.com/";
    }

    @Override
    protected String orderOptionFilter(@NonNull String orderOption) {
        try {
            if (!TextUtils.isEmpty((CharSequence)orderOption)) {
                return orderOption.split("\u3163")[0].replace("[", "").replace("]", "").trim();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orderOption;
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        try {
            String[] quantityStrArray;
            if (!TextUtils.isEmpty((CharSequence)quantity) && (quantityStrArray = quantity.split("\u3163")).length > 1) {
                return Integer.parseInt(quantityStrArray[1].replace("]", "").replace("\uac1c", "").trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    @Override
    public String getLogoutUrl() {
        return "javascript:bizSpringTag('http://www.hyundaihmall.com/front/cob/logout.do','^\ud5e4\ub354^\ub9c8\uc774\ud398\uc774\uc9c0 \ub808\uc774\uc5b4^\ub85c\uadf8\uc544\uc6c3');";
    }
}

