/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.vpc.v20170312.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeSpecificTrafficPackageUsedDetailsResponse extends AbstractModel {

    /**
    * 符合查询条件的共享流量包用量明细的总数
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * 共享流量包用量明细列表
    */
    @SerializedName("UsedDetailSet")
    @Expose
    private UsedDetail [] UsedDetailSet;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 符合查询条件的共享流量包用量明细的总数 
     * @return TotalCount 符合查询条件的共享流量包用量明细的总数
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set 符合查询条件的共享流量包用量明细的总数
     * @param TotalCount 符合查询条件的共享流量包用量明细的总数
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get 共享流量包用量明细列表 
     * @return UsedDetailSet 共享流量包用量明细列表
     */
    public UsedDetail [] getUsedDetailSet() {
        return this.UsedDetailSet;
    }

    /**
     * Set 共享流量包用量明细列表
     * @param UsedDetailSet 共享流量包用量明细列表
     */
    public void setUsedDetailSet(UsedDetail [] UsedDetailSet) {
        this.UsedDetailSet = UsedDetailSet;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeSpecificTrafficPackageUsedDetailsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeSpecificTrafficPackageUsedDetailsResponse(DescribeSpecificTrafficPackageUsedDetailsResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.UsedDetailSet != null) {
            this.UsedDetailSet = new UsedDetail[source.UsedDetailSet.length];
            for (int i = 0; i < source.UsedDetailSet.length; i++) {
                this.UsedDetailSet[i] = new UsedDetail(source.UsedDetailSet[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArrayObj(map, prefix + "UsedDetailSet.", this.UsedDetailSet);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

