/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class WebHookReceiverUsage extends AbstractModel {

    /**
    * 接收人id
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("ReceiverId")
    @Expose
    private Long ReceiverId;

    /**
    * 接收人名称
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("ReceiverName")
    @Expose
    private String ReceiverName;

    /**
    * 策略名称
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("PolicyName")
    @Expose
    private String PolicyName;

    /**
     * Get 接收人id
注意：此字段可能返回 null，表示取不到有效值。 
     * @return ReceiverId 接收人id
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getReceiverId() {
        return this.ReceiverId;
    }

    /**
     * Set 接收人id
注意：此字段可能返回 null，表示取不到有效值。
     * @param ReceiverId 接收人id
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setReceiverId(Long ReceiverId) {
        this.ReceiverId = ReceiverId;
    }

    /**
     * Get 接收人名称
注意：此字段可能返回 null，表示取不到有效值。 
     * @return ReceiverName 接收人名称
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getReceiverName() {
        return this.ReceiverName;
    }

    /**
     * Set 接收人名称
注意：此字段可能返回 null，表示取不到有效值。
     * @param ReceiverName 接收人名称
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setReceiverName(String ReceiverName) {
        this.ReceiverName = ReceiverName;
    }

    /**
     * Get 策略名称
注意：此字段可能返回 null，表示取不到有效值。 
     * @return PolicyName 策略名称
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getPolicyName() {
        return this.PolicyName;
    }

    /**
     * Set 策略名称
注意：此字段可能返回 null，表示取不到有效值。
     * @param PolicyName 策略名称
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setPolicyName(String PolicyName) {
        this.PolicyName = PolicyName;
    }

    public WebHookReceiverUsage() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public WebHookReceiverUsage(WebHookReceiverUsage source) {
        if (source.ReceiverId != null) {
            this.ReceiverId = new Long(source.ReceiverId);
        }
        if (source.ReceiverName != null) {
            this.ReceiverName = new String(source.ReceiverName);
        }
        if (source.PolicyName != null) {
            this.PolicyName = new String(source.PolicyName);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ReceiverId", this.ReceiverId);
        this.setParamSimple(map, prefix + "ReceiverName", this.ReceiverName);
        this.setParamSimple(map, prefix + "PolicyName", this.PolicyName);

    }
}

