/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.support.annotation.NonNull;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.EGLCore;
import com.tencent.xcast.EGLCoreContext;
import com.tencent.xcast.RefCountDelegate;
import java.util.Locale;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

class EGLCore10
extends RefCountDelegate
implements EGLCoreContext {
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final int EGL_OPENGL_ES2_BIT = 4;
    static final int[] CONFIG_RGB = new int[]{12324, 8, 12323, 8, 12322, 8, 12352, 4, 12344};
    static final int[] CONFIG_RGBA = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12344};
    static int[] CONTEXT_ATTR = new int[]{12440, 2, 12344};
    @NonNull
    private EGL10 mEGL10 = (EGL10)EGLContext.getEGL();
    private EGLDisplay mEGLDisplay = EGL10.EGL_NO_DISPLAY;
    private EGLSurface mEGLSurface = EGL10.EGL_NO_SURFACE;
    private EGLContext mEGLContext = EGL10.EGL_NO_CONTEXT;
    private EGLConfig mEGLConfig = null;
    private boolean mIsOffscreen = false;

    EGLCore10(int n2) {
        EGLCore10.CONTEXT_ATTR[1] = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createContext(EGLCoreContext eGLContext, boolean bl) {
        if (eGLContext != null && !(eGLContext instanceof EGLCore10)) {
            Platform.logError("create.shared.context.type.error");
            return false;
        }
        EGLCore10 eGLCore10 = this;
        eGLCore10.mEGLDisplay = eGLCore10.mEGL10.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        Object object = new int[2];
        eGLCore10.mEGL10.eglInitialize(this.mEGLDisplay, object);
        object = new EGLConfig[1];
        int[] nArray = new int[1];
        EGL10 eGL10 = eGLCore10.mEGL10;
        EGLDisplay eGLDisplay = eGLCore10.mEGLDisplay;
        int[] nArray2 = bl ? CONFIG_RGBA : CONFIG_RGB;
        if (eGL10.eglChooseConfig(eGLDisplay, nArray2, (EGLConfig[])object, ((int[])object).length, nArray) && nArray[0] != 0) {
            this.mEGLConfig = (EGLConfig)object[0];
            eGLContext = eGLContext != null ? ((EGLCore10)eGLContext).mEGLContext : EGL10.EGL_NO_CONTEXT;
            Object object2 = EGLCore.sLock;
            object = object2;
            synchronized (object) {
                block5: {
                    this.mEGLContext = this.mEGL10.eglCreateContext(this.mEGLDisplay, this.mEGLConfig, eGLContext, CONTEXT_ATTR);
                    // ** MonitorExit[v1] (shouldn't be in output)
                    if (!EGLCore.LOG_EGL) break block5;
                    EGLContext eGLContext2 = new Object[3];
                    eGLContext = eGLContext2;
                    eGLContext[0] = this;
                    eGLContext2[1] = this.mEGLContext;
                    eGLContext2[2] = Thread.currentThread().getId();
                    Platform.logInfo(String.format(Locale.CHINA, "%h.createContext.ctx.%h.tid.%d", (Object[])eGLContext));
                }
                return this.hasContext();
            }
        }
        Platform.logError("no.config.found");
        return false;
    }

    @Override
    public void destroyContext() {
        if (EGLCore.LOG_EGL) {
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this;
            objectArray[1] = this.mEGLContext;
            objectArray[2] = Thread.currentThread().getId();
            Platform.logInfo(String.format(Locale.CHINA, "%h.destroyContext.ctx.%h.tid.%d", objectArray2));
        }
        if (this.hasContext()) {
            this.mEGL10.eglDestroyContext(this.mEGLDisplay, this.mEGLContext);
            this.mEGLContext = EGL10.EGL_NO_CONTEXT;
        }
        if (!this.mEGLDisplay.equals(EGL10.EGL_NO_DISPLAY)) {
            this.mEGL10.eglTerminate(this.mEGLDisplay);
            this.mEGLDisplay = EGL10.EGL_NO_DISPLAY;
        }
        this.mEGLConfig = null;
    }

    @Override
    public boolean createSurface(Object objectArray) {
        if (!this.hasContext()) {
            Platform.logError("mEGLContext.not.initialized");
            return false;
        }
        this.destroySurface();
        if (objectArray != null) {
            Object[] objectArray2;
            try {
                int[] nArray = objectArray2 = new int[1];
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Object[] objectArray3 = new Object[2];
                objectArray2 = objectArray3;
                objectArray2[0] = (int)this;
                objectArray3[1] = illegalArgumentException.toString();
                Platform.logError(String.format(Locale.CHINA, "%h.eglCreateWindowSurface.%s", objectArray2));
                return false;
            }
            nArray[0] = 12344;
            this.mEGLSurface = this.mEGL10.eglCreateWindowSurface(this.mEGLDisplay, this.mEGLConfig, (Object)objectArray, objectArray2);
            this.mIsOffscreen = false;
        } else {
            int[] nArray = new int[7];
            objectArray = nArray;
            nArray[0] = 12375;
            nArray[1] = 1;
            nArray[2] = 12374;
            nArray[3] = 1;
            nArray[4] = 12376;
            nArray[5] = 1;
            nArray[6] = 12344;
            this.mEGLSurface = this.mEGL10.eglCreatePbufferSurface(this.mEGLDisplay, this.mEGLConfig, (int[])objectArray);
            this.mIsOffscreen = true;
        }
        if (EGLCore.LOG_EGL) {
            Object[] objectArray4 = new Object[4];
            objectArray = objectArray4;
            objectArray[0] = this;
            objectArray[1] = this.mEGLContext;
            objectArray4[2] = this.mEGLSurface;
            objectArray4[3] = Thread.currentThread().getId();
            Platform.logInfo(String.format(Locale.CHINA, "%h.createSurface.ctx.%h.sf.%h.tid.%d", objectArray));
        }
        if (this.hasSurface()) {
            this.makeCurrent();
        }
        return true;
    }

    @Override
    public void destroySurface() {
        if (EGLCore.LOG_EGL) {
            Object[] objectArray = new Object[4];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this;
            objectArray2[1] = this.mEGLContext;
            objectArray[2] = this.mEGLSurface;
            objectArray[3] = Thread.currentThread().getId();
            Platform.logInfo(String.format(Locale.CHINA, "%h.destroySurface.ctx.%h.sf.%h.tid.%d", objectArray2));
        }
        if (this.hasSurface()) {
            EGLCore10 eGLCore10 = this;
            eGLCore10.detachCurrent();
            eGLCore10.mEGL10.eglDestroySurface(this.mEGLDisplay, this.mEGLSurface);
            eGLCore10.mEGLSurface = EGL10.EGL_NO_SURFACE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int makeCurrent() {
        Object object = EGLCore.sLock;
        synchronized (object) {
            block4: {
                if (!this.mEGL10.eglMakeCurrent(this.mEGLDisplay, this.mEGLSurface, this.mEGLSurface, this.mEGLContext)) break block4;
                return 12288;
            }
            return this.mEGL10.eglGetError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachCurrent() {
        Object object = EGLCore.sLock;
        synchronized (object) {
            this.mEGL10.eglMakeCurrent(this.mEGLDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            return;
        }
    }

    @Override
    public boolean isCurrentContext() {
        return this.mEGLContext.equals(this.mEGL10.eglGetCurrentContext()) && this.mEGLSurface.equals(this.mEGL10.eglGetCurrentSurface(12377));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int swapBuffers() {
        Object object = EGLCore.sLock;
        synchronized (object) {
            int n2;
            block7: {
                block6: {
                    if (this.mIsOffscreen) break block6;
                    if (this.mEGL10.eglSwapBuffers(this.mEGLDisplay, this.mEGLSurface)) break block6;
                    n2 = this.mEGL10.eglGetError();
                    break block7;
                }
                n2 = 12288;
            }
            return n2;
        }
    }

    @Override
    public int swapBuffers(long l2) {
        return this.swapBuffers();
    }

    @Override
    public boolean hasContext() {
        return this.mEGLContext.equals(EGL10.EGL_NO_CONTEXT) ^ true;
    }

    @Override
    public boolean hasSurface() {
        return this.mEGLSurface.equals(EGL10.EGL_NO_SURFACE) ^ true;
    }

    @Override
    public String eglQueryString(int n2) {
        return this.mEGL10.eglQueryString(this.mEGLDisplay, n2);
    }

    @Override
    public int eglGetError() {
        return this.mEGL10.eglGetError();
    }

    @Override
    public int release() {
        int n2 = super.release();
        if (n2 == 0) {
            EGLCore10 eGLCore10 = this;
            eGLCore10.destroySurface();
            eGLCore10.destroyContext();
        }
        return n2;
    }
}

