/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.opengl.GLUtils;
import android.os.Build;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.EGLCore10;
import com.tencent.xcast.EGLCore14;
import com.tencent.xcast.EGLCoreContext;
import com.tencent.xcast.EGLUtil;
import java.util.Locale;

public class EGLCore
implements EGLCoreContext {
    private static final boolean EGL14_AVAILABLE = Build.VERSION.SDK_INT >= 17;
    public static boolean LOG_EGL = false;
    public static final Object sLock = new Object();
    private EGLCoreContext mEgl;

    public EGLCore() {
        this.mEgl = EGL14_AVAILABLE ? new EGLCore14(EGLUtil.getGLMajorVersion()) : new EGLCore10(EGLUtil.getGLMajorVersion());
        if (LOG_EGL) {
            Locale locale = Locale.getDefault();
            Object[] objectArray = new Object[2];
            objectArray[0] = this;
            try {
                objectArray[1] = this.mEgl;
                Platform.logInfo(String.format(locale, "%h.new.mEgl.%h", objectArray));
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
            }
        }
    }

    EGLCore(int n2) {
        this.mEgl = EGL14_AVAILABLE ? new EGLCore14(n2) : new EGLCore10(n2);
        if (LOG_EGL) {
            Locale locale = Locale.getDefault();
            Object[] objectArray = new Object[3];
            objectArray[0] = this;
            objectArray[1] = n2;
            try {
                objectArray[2] = this.mEgl;
                Platform.logInfo(String.format(locale, "%h.new.with.version.%d.mEgl.%h", objectArray));
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
            }
        }
    }

    @Override
    public boolean createContext(EGLCoreContext eGLCoreContext, boolean bl) {
        if (eGLCoreContext != null && !(eGLCoreContext instanceof EGLCore)) {
            try {
                Platform.logError("create.shared.context.type.error");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
            }
            return false;
        }
        EGLCoreContext eGLCoreContext2 = ((EGLCore)eGLCoreContext2).mEgl;
        eGLCoreContext = eGLCoreContext != null ? ((EGLCore)eGLCoreContext).mEgl : null;
        return eGLCoreContext2.createContext(eGLCoreContext, bl);
    }

    @Override
    public void destroyContext() {
        this.mEgl.destroyContext();
    }

    @Override
    public boolean createSurface(Object object) {
        return this.mEgl.createSurface(object);
    }

    @Override
    public void destroySurface() {
        this.mEgl.destroySurface();
    }

    @Override
    public int makeCurrent() {
        Object[] objectArray;
        if (this.mEgl.isCurrentContext()) {
            return 12288;
        }
        int n2 = this.mEgl.makeCurrent();
        if (n2 != 12288) {
            Object[] objectArray2 = new Object[3];
            objectArray = objectArray2;
            objectArray[0] = this;
            objectArray2[1] = GLUtils.getEGLErrorString((int)n2);
            objectArray2[2] = Thread.currentThread().getId();
            Platform.logError(String.format(Locale.getDefault(), "%h.eglMakeCurrent.fail.%s.tid.%d", objectArray));
        }
        if (LOG_EGL) {
            Object[] objectArray3 = new Object[3];
            objectArray = objectArray3;
            objectArray[0] = this;
            objectArray[1] = Thread.currentThread().getId();
            objectArray3[2] = this.mEgl;
            Platform.logInfo(String.format(Locale.getDefault(), "%h.makeCurrent.tid.%d.mEgl.%h", objectArray));
        }
        return n2;
    }

    @Override
    public void detachCurrent() {
        if (this.mEgl.isCurrentContext()) {
            this.mEgl.detachCurrent();
            if (LOG_EGL) {
                Object[] objectArray = new Object[3];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = this;
                objectArray2[1] = Thread.currentThread().getId();
                objectArray[2] = this.mEgl;
                Platform.logInfo(String.format(Locale.getDefault(), "%h.detachCurrent.tid.%d.mEgl.%h", objectArray2));
            }
        }
    }

    @Override
    public boolean isCurrentContext() {
        return this.mEgl.isCurrentContext();
    }

    @Override
    public int swapBuffers() {
        int n2 = this.mEgl.swapBuffers();
        if (n2 != 12288) {
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this;
            objectArray[1] = GLUtils.getEGLErrorString((int)n2);
            objectArray[2] = Thread.currentThread().getId();
            Platform.logError(String.format(Locale.getDefault(), "%h.eglSwapBuffers.fail.%s.tid.%d", objectArray2));
        }
        return n2;
    }

    @Override
    public int swapBuffers(long l2) {
        int n2 = this.mEgl.swapBuffers(l2);
        if (n2 != 12288) {
            Object[] objectArray = new Object[4];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this;
            objectArray2[1] = l2;
            objectArray[2] = GLUtils.getEGLErrorString((int)n2);
            objectArray[3] = Thread.currentThread().getId();
            Platform.logError(String.format(Locale.getDefault(), "%h.eglSwapBuffers.time.%d.fail.%s.tid.%d", objectArray2));
        }
        return n2;
    }

    @Override
    public boolean hasContext() {
        return this.mEgl.hasContext();
    }

    @Override
    public boolean hasSurface() {
        return this.mEgl.hasSurface();
    }

    @Override
    public String eglQueryString(int n2) {
        return this.mEgl.eglQueryString(n2);
    }

    @Override
    public int eglGetError() {
        return this.mEgl.eglGetError();
    }

    @Override
    public int retain() {
        int n2 = this.mEgl.retain();
        if (LOG_EGL) {
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this;
            objectArray2[1] = n2;
            objectArray[2] = this.mEgl;
            Platform.logInfo(String.format(Locale.getDefault(), "%h.retain.%d.mEgl.%h", objectArray2));
        }
        return n2;
    }

    @Override
    public int release() {
        int n2 = this.mEgl.release();
        if (LOG_EGL) {
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this;
            objectArray2[1] = n2;
            objectArray[2] = this.mEgl;
            Platform.logInfo(String.format(Locale.getDefault(), "%h.release.%d.mEgl.%h", objectArray2));
        }
        return n2;
    }
}

