/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.avlab.sdk;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class Platform {
    public static final boolean isDebugBuild = Platform.debug();
    private static int logLevel = -1;
    private static final int NETWORK_UNREACHABLE = 0;
    private static final int NETWORK_UNKNOWN = 1;
    private static final int NETWORK_2G = 2;
    private static final int NETWORK_3G = 3;
    private static final int NETWORK_4G = 4;
    private static final int NETWORK_5G = 5;
    private static final int NETWORK_WIFI = 6;
    private static final int NETWORK_WIRED = 7;

    private static native void callFunction(long var0);

    private static boolean runOnMainThread(long l2) {
        return Lazy.gHandler.post((Runnable)new MainThreadRunnable(l2));
    }

    private static Object getClassLoader() {
        return Platform.class.getClassLoader();
    }

    public static native boolean debug();

    public static native void log(int var0, String var1, int var2, String var3, int var4, String var5);

    public static void log(int n2, String string) {
        if (!Platform.isLogLevel(n2)) {
            return;
        }
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray.length > 3) {
            StackTraceElement stackTraceElement = stackTraceElementArray[3];
            Platform.log(n2, stackTraceElement.getFileName(), stackTraceElement.getLineNumber(), stackTraceElement.getMethodName(), 1, string);
        }
    }

    public static void logInfo(String string) {
        if (!Platform.isLogLevel(4)) {
            return;
        }
        Object object = Thread.currentThread().getStackTrace();
        if (((StackTraceElement[])object).length > 3) {
            StackTraceElement stackTraceElement = object[3];
            object = stackTraceElement.getFileName();
            int n2 = stackTraceElement.getLineNumber();
            String string2 = stackTraceElement.getMethodName();
            Platform.log(4, (String)object, n2, string2, 1, string);
        }
    }

    public static void logDebug(String string) {
        if (!Platform.isDebugLevel()) {
            return;
        }
        Object object = Thread.currentThread().getStackTrace();
        if (((StackTraceElement[])object).length > 3) {
            StackTraceElement stackTraceElement = object[3];
            object = stackTraceElement.getFileName();
            int n2 = stackTraceElement.getLineNumber();
            String string2 = stackTraceElement.getMethodName();
            Platform.log(5, (String)object, n2, string2, 1, string);
        }
    }

    public static void logError(String string) {
        if (!Platform.isLogLevel(2)) {
            return;
        }
        Object object = Thread.currentThread().getStackTrace();
        if (((StackTraceElement[])object).length > 3) {
            StackTraceElement stackTraceElement = object[3];
            object = stackTraceElement.getFileName();
            int n2 = stackTraceElement.getLineNumber();
            String string2 = stackTraceElement.getMethodName();
            Platform.log(2, (String)object, n2, string2, 1, string);
        }
    }

    protected static native int logLevel();

    public static boolean isDebugLevel() {
        return Platform.isLogLevel(5);
    }

    public static boolean isLogLevel(int n2) {
        if (logLevel == -1) {
            logLevel = Platform.logLevel();
        }
        return n2 <= logLevel;
    }

    private static String getAppVersion(Context object) {
        Object var1_1;
        block5: {
            var1_1 = null;
            PackageManager packageManager = object.getPackageManager();
            String string = object.getPackageName();
            object = packageManager.getPackageInfo(string, 0);
            if (object == null) break block5;
            if (TextUtils.isEmpty((CharSequence)object.versionName.trim())) break block5;
            try {
                object = object.versionName.trim();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                object = var1_1;
            }
        }
        object = var1_1;
        return object;
    }

    public static String getTrace(Throwable object) {
        StringWriter stringWriter;
        if (object == null) {
            return "";
        }
        Throwable throwable = object;
        object = stringWriter;
        stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)object));
        return ((StringWriter)object).toString();
    }

    public static int getNetworkState(Context object) {
        block16: {
            int n2;
            block14: {
                block15: {
                    block13: {
                        if ((object = (ConnectivityManager)object.getSystemService("connectivity")) == null) {
                            return 0;
                        }
                        try {
                            object = object.getActiveNetworkInfo();
                            if (object != null) break block13;
                            return 0;
                        }
                        catch (Exception exception) {
                            Platform.log(3, exception.toString());
                            return 1;
                        }
                    }
                    if (!object.isAvailable()) {
                        return 0;
                    }
                    NetworkInfo.State state = object.getState();
                    if (state != NetworkInfo.State.CONNECTED && state != NetworkInfo.State.CONNECTING) {
                        return 0;
                    }
                    n2 = object.getType();
                    if (1 == n2) {
                        return 6;
                    }
                    if (n2 != 0) break block14;
                    n2 = object.getSubtype();
                    if (n2 == 20) break block15;
                    switch (n2) {
                        default: {
                            object = object.getSubtypeName();
                            if ("TD-SCDMA".equalsIgnoreCase((String)object) || "WCDMA".equalsIgnoreCase((String)object) || "CDMA2000".equalsIgnoreCase((String)object)) {
                                return 3;
                            }
                            break block16;
                        }
                        case 13: {
                            return 4;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: {
                            return 3;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: {
                            return 2;
                        }
                    }
                }
                return 5;
            }
            if (9 == n2) {
                return 7;
            }
        }
        return 1;
    }

    private static class Lazy {
        static final Handler gHandler = new Handler(Looper.getMainLooper());

        private Lazy() {
        }
    }

    private static class MainThreadRunnable
    implements Runnable {
        private long ptr;

        MainThreadRunnable(long l2) {
            this.ptr = l2;
        }

        @Override
        public void run() {
            Platform.callFunction(this.ptr);
        }
    }
}

