package com.tencent.wecast.sender.cloud.widget

import android.app.Activity
import android.app.Dialog
import android.app.DownloadManager
import android.os.Bundle
import android.widget.ProgressBar
import android.widget.TextView
import com.tencent.wecast.sender.cloud.R
import com.tencent.wecast.sender.cloud.utils.DownloadApkUtils

class DownLoadDialog constructor(activity: Activity) : Dialog(activity) {
    private var mProgressBar: ProgressBar? = null
    private var mTvCanCel: TextView? = null
    private var mOnDownloadCancelListener: OnDownloadCancelListener? = null

    interface OnDownloadCancelListener {
        fun onCancel()
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.wecast_dialog_download)
        setCancelable(false)
        mProgressBar = findViewById(R.id.pb_download)
        mTvCanCel = findViewById(R.id.tv_cancel_download)
        mTvCanCel?.setOnClickListener {
            this.dismiss()
            DownloadApkUtils.cancelDownload()
            mOnDownloadCancelListener?.onCancel()
        }
    }

    fun setOnDownloadCancelListener(onDownloadCancelListener: OnDownloadCancelListener?){
        this.mOnDownloadCancelListener = onDownloadCancelListener
    }

    fun setProgress(progress: Int) {
        mProgressBar?.progress = progress
    }
}