package com.tencent.wecast.sender.cloud.utils

import android.app.Activity
import android.app.ActivityManager
import android.content.Context
import android.text.TextUtils
import com.tencent.wecast.WeCastAppContext

object ActivityTaskUtil {
    fun isTopActivity(activity: Activity): Boolean {
        val manager = WeCastAppContext.get().getSystemService(Activity.ACTIVITY_SERVICE) as ActivityManager
        val runningTaskList: List<ActivityManager.RunningTaskInfo> = manager.getRunningTasks(1)
        val name = runningTaskList[0].topActivity.className
        return name == activity::class.java.name
    }

    fun isBottomActivity(activity: Activity): Boolean {
        val manager = WeCastAppContext.get().getSystemService(Activity.ACTIVITY_SERVICE) as ActivityManager
        val runningTaskList: List<ActivityManager.RunningTaskInfo> = manager.getRunningTasks(1)
        val name = runningTaskList[0].baseActivity.className
        return name == activity::class.java.name
    }
}