package com.tencent.wecast.sender.cloud.activity

import android.Manifest
import android.app.Dialog
import android.content.Intent
import android.graphics.Color
import android.os.Bundle
import android.support.v7.app.AlertDialog
import android.text.TextUtils
import android.widget.Button
import android.widget.Toast
import com.tencent.wecast.WeCastConfigManager
import com.tencent.wecast.WeCastEnv
import com.tencent.wecast.WeCastUIConfigManager
import com.tencent.wecast.sender.cloud.bean.WeCastInfo
import com.tencent.wecast.sender.cloud.utils.CloudUtil
import com.tencent.wecast.sender.eb.SenderEvents
import com.tencent.wecast.utils.EventBusUtil
import com.tencent.wecast.utils.Logger
import com.tencent.wecast.utils.ReportUtils
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode
import java.util.*
import android.net.Uri
import com.tencent.wecast.sender.cloud.R


open class CloudSplashActivity : CloudLoginActivity() {

    companion object {
        private const val TAG = "CloudSplashActivity"
    }

    private val mPermissionMap = HashMap<String, String>()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        if (intent.getBooleanExtra("isInitialized", false)) {
            jump()
        }

        val curActivityLabel = if (!WeCastInfo.instance.usingMirror
                || WeCastConfigManager.getInstance().isLanScheme) {
            WeCastUIConfigManager.ActivityLabel.SENDER_SPLASH_1
        } else {
            WeCastUIConfigManager.ActivityLabel.SENDER_SPLASH_2
        }
        val rootView = WeCastUIConfigManager.getInstance().getLayoutRootView(curActivityLabel, applicationContext)
        if (null == rootView) {
            Logger.t(TAG).e("rootView is null.")
            finish()
            return
        }
        WeCastUIConfigManager.getInstance().applyUIConfig(curActivityLabel, rootView)
        setContentView(rootView)

        mPermissionMap[Manifest.permission.WRITE_EXTERNAL_STORAGE] = getString(R.string.wecast_rw_sdcard)
        requestPermission(mPermissionMap, object : OnRequestPermissionListener {
            override fun onRequestSuccess() {
                login()
            }
        })
        EventBusUtil.register(this)
    }

    override fun jump() {
        if (WeCastConfigManager.getInstance().isLanScheme) {
            val intent = Intent(this@CloudSplashActivity, CloudMainActivity1::class.java)
            intent.flags = Intent.FLAG_ACTIVITY_CLEAR_TOP
            startActivity(intent)
        } else {
            val intent = Intent(this@CloudSplashActivity, CloudMainActivity2::class.java)
            intent.flags = Intent.FLAG_ACTIVITY_CLEAR_TOP
            startActivity(intent)
        }
        finish()
    }

    override fun onPause() {
        super.onPause()
        WeCastInfo.instance.isRunning = false
    }

    override fun onBackPressed() {
        Logger.t(TAG).d("onBackPressed forbidden.")
    }

    override fun showFatalDialog(info: String?, message: String, retryFunc: () -> Unit) {
        if ((mFatalDialog != null && mFatalDialog!!.isShowing)
                || (mLoadingDialog != null && mLoadingDialog!!.isShowing)) {
            return
        }
        Logger.t(TAG).e("showFatalDialog info = $info")

        mFatalDialog = AlertDialog.Builder(this@CloudSplashActivity)
                .setTitle(getString(R.string.wecast_failed_text))
                .setPositiveButton(getString(R.string.wecast_retry_text)
                ) { _, _ ->
                    mFatalDialog?.dismiss()
                    retryFunc()
                }
                .setNegativeButton(getString(R.string.wecast_exit_app)
                ) { _, _ ->
                    mFatalDialog?.dismiss()
                    CloudUtil.JniMethod.unInitSender()
                    finish()
                }.setNeutralButton("       ", null)
                .setCancelable(false)
                .create()
        mFatalDialog?.setMessage(message)
        mFatalDialog?.show()
        mFatalDialog?.getButton(Dialog.BUTTON_POSITIVE)?.setTextColor(Color.BLUE)
        mFatalDialog?.getButton(Dialog.BUTTON_NEGATIVE)?.setTextColor(Color.GRAY)
        val neutralButton: Button? = mFatalDialog?.getButton(Dialog.BUTTON_NEUTRAL)
        neutralButton?.background = null
        neutralButton?.setOnClickListener {
            tryChangeEnv()
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onAppHasForceUpdateEvent(event: SenderEvents.EAppUpdate) {
        if (!WeCastInfo.instance.enableUpdate) {
            Logger.t(TAG).d("disable sdk update.")
            return
        }
        Logger.t(TAG).d("onAppHasForceUpdateEvent:" +
                "needUpdate:${event.needUpdate}," +
                "forceUpdate:${event.forceUpdate}, " +
                "url:${event.url}, " +
                "forceUrl:${event.forceUrl}, " +
                "md5:${event.md5}, " +
                "msg:${event.msg}")
        if (event.forceUpdate || event.needUpdate) {
            mNeedUpdate = true
            try {
                if (mFatalDialog != null && mFatalDialog!!.isShowing) {
                    return
                }
                if (TextUtils.isEmpty(event.forceUrl) && TextUtils.isEmpty(event.url)) {
                    mFatalDialog = AlertDialog.Builder(this@CloudSplashActivity)
                            .setPositiveButton(R.string.wecast_confirm_text
                            ) { _, _ ->
                                ReportUtils.AddEventReport(ReportUtils.EVENT_BTN_FORBIDDEN_VER_CONFIRM, 0, "")
                                mFatalDialog?.dismiss()
                                finish()
                            }
                            .setCancelable(false)
                            .create()
                } else {
                    val alertBuilder = AlertDialog.Builder(this@CloudSplashActivity)
                    alertBuilder
                            .setPositiveButton(R.string.wecast_update_now_text
                            ,null).setCancelable(false)
                    if (!event.forceUpdate) {
                        alertBuilder.setNegativeButton(R.string.wecast_cancel_text
                        ) { _, _ ->
                            mNeedUpdate = false
                            tryJump()
                        }
                    }
                    mFatalDialog = alertBuilder.create()
                }
                mFatalDialog?.setMessage(event.msg)
                mFatalDialog?.show()
                mFatalDialog?.getButton(Dialog.BUTTON_POSITIVE)?.setTextColor(Color.BLUE)
                mFatalDialog?.getButton(Dialog.BUTTON_POSITIVE)?.setOnClickListener {
                    ReportUtils.AddEventReport(ReportUtils.EVENT_BTN_FORBIDDEN_VER_UPDATE_NOW, 0, "")
                    val url = if (event.forceUrl != "" && event.forceUpdate) {
                        event.forceUrl
                    } else {
                        event.url
                    }
                    openDownloadUrlByWeb(url)
                }
                mFatalDialog?.getButton(Dialog.BUTTON_NEGATIVE)?.setTextColor(Color.GRAY)
            } catch (e: Exception) {
                Logger.t(TAG).e("onAppHasForceUpdateEvent e = $e")
            }
        }
        return
    }

    private fun openDownloadUrlByWeb(url:String){
        try{
            val uri = Uri.parse(url)
            val intent = Intent(Intent.ACTION_VIEW, uri)
            startActivity(intent)
        }catch (e:java.lang.Exception){
            Logger.t(TAG).e("download url error")
        }
    }
}
