package com.tencent.wecast.c2c;

public enum C2CMsgType {
    C2C_UNKNOWN(0),     // sender <-> receiver 未知
    C2C_S2R_GUIDE(1),       // sender -> receiver 指引
    C2C_R2S_PAUSE_XCAST(2),  // receiver -> sender 暂停XCast
    C2C_R2S_PUSH_UPDATE(3),  // receiver -> sender push update
    C2C_S2R_QUERY(4),  // sender -> receiver 查询
    C2C_S2R_IOS_REPLY_KIT_READY(5),  // sender -> receiver iOS replay kit 已经ok，等待数据传输
    C2C_R2S_SSDP_SOURCE_QUERY(6),    // receiver -> sender 查询ssdp发送端的ip
    C2C_S2R_SSDP_SOURCE_IP_NOTIFY(7), // sender -> receiver 通知ssdp不被隔离的ip
    C2C_S2R_SSDP_DISCOVERY(8); // sender -> receiver 发送端通知接收端响应发现服务

    private int cmd;

    C2CMsgType(int cmd) {
        this.cmd = cmd;
    }

    public int getCmd() {
        return cmd;
    }

    public static C2CMsgType valueOf(int cmd) {
        for (C2CMsgType c2CMsgType : values()) {
            if (c2CMsgType.getCmd() == cmd) {
                return c2CMsgType;
            }
        }
        return null;
    }
}
