package com.tencent.wecast;

import android.content.Context;

import com.tencent.wecast.utils.DeviceInfoUtil;
import com.tencent.wecast.utils.NetworkUtil;

/**
 * 设备信息管理
 */
public class WeCastDeviceManager {
    private static final WeCastDeviceManager ourInstance = new WeCastDeviceManager();

    public static WeCastDeviceManager getInstance() {
        return ourInstance;
    }

    private WeCastDeviceManager() {
    }

    public String model;       // 机型
    public String osVersion;   // 系统版本
    public String netType;     // 网络类型2G/3G/4G/wifi/wired
    public String mac;         // 无线mac
    public String wiredMac;     // 有线mac
    public String rom;         // 如1G
    public String ram;         // 如2.5G
    public String cpu;
    public String gpu = "";
    public String res;         // 如760*860
    public String wfSSID;      // 接入wifi的ssid
    public String wfMac;       // 接入wifi的mac地址

    public void init(Context context) {
        model = DeviceInfoUtil.getModel();
        osVersion = DeviceInfoUtil.getOsVer();
        netType = NetworkUtil.getNetType(context);
        mac = DeviceInfoUtil.getWlanMacAddress();
        wiredMac = DeviceInfoUtil.getWiredMacAddress();
        rom = DeviceInfoUtil.getRomSize();
        ram = DeviceInfoUtil.getRamSize();
        cpu = DeviceInfoUtil.getCpuName();
        DeviceInfoUtil.getGpuName(new DeviceInfoUtil.GetGpuNameCallback() {
            @Override
            public void onResult(String name) {
                gpu = name;
            }
        });
        res = DeviceInfoUtil.getResolution(context);
        boolean isWifiEnv = "wifi".equals(netType);
        wfSSID = isWifiEnv ? NetworkUtil.getWifiSSID(context) : "-";
        wfMac = isWifiEnv ? NetworkUtil.getWifiMacAddress(context) : "-";
    }
}
