/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sharp.jni;

public class RingBuffer {
    private final int DEFAULT_SIZE;
    public int c_totalSize;
    public byte[] m_pBuf;
    public int m_read;
    public int m_write;
    public boolean m_isEmpty;

    public RingBuffer() {
        RingBuffer ringBuffer = this;
        ringBuffer.DEFAULT_SIZE = 1000;
        ringBuffer.c_totalSize = 1000;
        ringBuffer.m_read = 0;
        ringBuffer.m_write = 0;
        ringBuffer.m_isEmpty = true;
        ringBuffer.m_pBuf = null;
        ringBuffer.c_totalSize = 1000;
        ringBuffer.m_isEmpty = true;
        ringBuffer.m_read = 0;
        ringBuffer.m_write = 0;
        ringBuffer.m_pBuf = new byte[ringBuffer.c_totalSize];
    }

    public RingBuffer(int n2) {
        this.DEFAULT_SIZE = 1000;
        this.c_totalSize = 1000;
        this.m_read = 0;
        this.m_write = 0;
        this.m_isEmpty = true;
        this.c_totalSize = n2;
        this.m_isEmpty = true;
        this.m_read = 0;
        this.m_write = 0;
        this.m_pBuf = new byte[this.c_totalSize];
    }

    public void Push(byte[] byArray, int n2) {
        if (this.m_pBuf == null) {
            return;
        }
        if (this.RemainWrite() < n2) {
            return;
        }
        int n3 = this.c_totalSize;
        int n4 = this.m_write;
        if (n3 - n4 >= n2) {
            System.arraycopy(byArray, 0, this.m_pBuf, n4, n2);
        } else {
            byte[] byArray2 = byArray;
            byte[] byArray3 = byArray;
            byArray = this.m_pBuf;
            System.arraycopy(byArray3, 0, byArray, n4, n3 -= n4);
            int n5 = this.c_totalSize;
            n3 = this.m_write;
            System.arraycopy(byArray2, n5 - n3, this.m_pBuf, 0, n2 - (n5 - n3));
        }
        this.m_write = (this.m_write + n2) % this.c_totalSize;
        this.m_isEmpty = false;
    }

    public int RemainRead() {
        int n2 = this.m_write;
        int n3 = this.m_read;
        if (n2 < n3) {
            return this.c_totalSize - n3 + n2;
        }
        if (n2 > n3) {
            return n2 - n3;
        }
        return this.m_isEmpty ? 0 : this.c_totalSize;
    }

    public int RemainWrite() {
        return this.c_totalSize - this.RemainRead();
    }

    public void Clear() {
        this.m_read = this.m_write = 0;
        this.m_isEmpty = true;
    }

    public boolean Pop(byte[] byArray, int n2) {
        if (this.m_pBuf == null) {
            return false;
        }
        if (this.RemainRead() >= n2 && n2 > 0) {
            int n3 = this.c_totalSize;
            int n4 = this.m_read;
            if (n3 - n4 >= n2) {
                System.arraycopy(this.m_pBuf, n4, byArray, 0, n2);
            } else {
                RingBuffer ringBuffer = this;
                System.arraycopy(ringBuffer.m_pBuf, n4, byArray, 0, n3 - n4);
                int n5 = this.c_totalSize;
                n3 = n5;
                int n6 = this.m_read;
                n4 = n2 - (n5 - n6);
                System.arraycopy(ringBuffer.m_pBuf, 0, byArray, n3 -= n6, n4);
            }
            RingBuffer ringBuffer = this;
            ringBuffer.m_read = (ringBuffer.m_read + n2) % this.c_totalSize;
            boolean bl = ringBuffer.m_read == this.m_write;
            this.m_isEmpty = bl;
            return true;
        }
        return false;
    }
}

