/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.avlab.sdk;

import android.util.Log;
import com.tencent.avlab.sdk.Xcast;
import java.nio.ByteBuffer;

public class XcastVariant {
    protected long native_ref_ = 0L;

    private static XcastVariant create() {
        return new XcastVariant();
    }

    public XcastVariant() {
    }

    public XcastVariant(XcastVariant xcastVariant) {
        long l2 = xcastVariant.native_ref_;
        if (l2 != 0L) {
            this.native_ref_ = l2;
            this.ref();
        }
    }

    public XcastVariant(boolean bl) {
        this.native_ref_ = this.newBoolean(bl);
    }

    public XcastVariant(byte by) {
        this.native_ref_ = this.newByte(by);
    }

    public XcastVariant(short s2) {
        this.native_ref_ = this.newShort(s2);
    }

    public XcastVariant(int n2) {
        this.native_ref_ = this.newInt(n2);
    }

    public XcastVariant(long l2) {
        this.native_ref_ = this.newLong(l2);
    }

    public XcastVariant(float f2) {
        this.native_ref_ = this.newFloat(f2);
    }

    public XcastVariant(double d2) {
        this.native_ref_ = this.newDouble(d2);
    }

    public XcastVariant(String string) {
        this.native_ref_ = this.newStr(string);
    }

    public XcastVariant(ByteBuffer byteBuffer) {
        this.native_ref_ = this.newBuf(byteBuffer);
    }

    public XcastVariant(Object object) {
        this.native_ref_ = this.newObject(object);
    }

    public static XcastVariant format(String string, Object ... objectArray) {
        string = String.format(string, objectArray);
        return new XcastVariant(string);
    }

    static {
        Xcast.loadLibraries();
    }

    protected native void ref();

    protected native void unref();

    protected native long newBoolean(boolean var1);

    protected native long newByte(byte var1);

    protected native long newShort(short var1);

    protected native long newInt(int var1);

    protected native long newLong(long var1);

    protected native long newFloat(float var1);

    protected native long newDouble(double var1);

    protected native long newStr(String var1);

    protected native long newBuf(ByteBuffer var1);

    protected native long newObject(Object var1);

    protected void finalize() {
        this.release();
    }

    public void release() {
        if (this.native_ref_ != 0L) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.native_ref_;
            Log.d((String)XcastVariant.class.getName(), (String)("release " + String.format("0x%x", objectArray2)));
            this.unref();
            this.native_ref_ = 0L;
        }
    }

    public native boolean empty();

    public native int size();

    public native char type();

    public native boolean booleanVal();

    public native byte byteVal();

    public native short shortVal();

    public native int intVal();

    public native long longVal();

    public native float floatVal();

    public native double doubleVal();

    public native String strVal();

    public native ByteBuffer bufVal();

    public native Object objectVal();

    public native void set(String var1, XcastVariant var2);

    public native boolean contains(String var1);

    public native void setBoolean(String var1, boolean var2);

    public native void setByte(String var1, byte var2);

    public native void setShort(String var1, short var2);

    public native void setInt(String var1, int var2);

    public native void setLong(String var1, long var2);

    public native void setStr(String var1, String var2);

    public native void setBuf(String var1, ByteBuffer var2);

    public native void setObject(String var1, Object var2);

    public void set(String string, boolean bl) {
        this.setBoolean(string, bl);
    }

    public void set(String string, byte by) {
        this.setByte(string, by);
    }

    public void set(String string, short s2) {
        this.setShort(string, s2);
    }

    public void set(String string, int n2) {
        this.setInt(string, n2);
    }

    public void set(String string, long l2) {
        this.setLong(string, l2);
    }

    public void set(String string, String string2) {
        this.setStr(string, string2);
    }

    public void set(String string, ByteBuffer byteBuffer) {
        this.setBuf(string, byteBuffer);
    }

    public void set(String string, Object object) {
        this.setObject(string, object);
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public byte getByte(String string) {
        return this.getByte(string, (byte)0);
    }

    public short getShort(String string) {
        return this.getShort(string, (short)0);
    }

    public int getInt(String string) {
        return this.getInt(string, 0);
    }

    public long getLong(String string) {
        return this.getLong(string, 0L);
    }

    public float getFloat(String string) {
        return this.getFloat(string, 0.0f);
    }

    public double getDouble(String string) {
        return this.getDouble(string, 0.0);
    }

    public String getStr(String string) {
        return this.getStr(string, null);
    }

    public ByteBuffer getBuf(String string) {
        return this.getBuf(string, null);
    }

    public Object getObject(String string) {
        return this.getObject(string, null);
    }

    public native XcastVariant get(String var1);

    public native boolean getBoolean(String var1, boolean var2);

    public native byte getByte(String var1, byte var2);

    public native short getShort(String var1, short var2);

    public native int getInt(String var1, int var2);

    public native long getLong(String var1, long var2);

    public native float getFloat(String var1, float var2);

    public native double getDouble(String var1, double var2);

    public native String getStr(String var1, String var2);

    public native int strCmp(XcastVariant var1, String var2);

    public native ByteBuffer getBuf(String var1, ByteBuffer var2);

    public native Object getObject(String var1, Object var2);

    public native void add(XcastVariant var1);

    public native void addBoolean(boolean var1);

    public native void addByte(byte var1);

    public native void addShort(short var1);

    public native void addInt(int var1);

    public native void addLong(long var1);

    public native void addFloat(float var1);

    public native void addDouble(double var1);

    public native void addStr(String var1);

    public native void addBuf(ByteBuffer var1);

    public void add(boolean bl) {
        this.addBoolean(bl);
    }

    public void add(byte by) {
        this.addByte(by);
    }

    public void add(short s2) {
        this.addShort(s2);
    }

    public void add(int n2) {
        this.addInt(n2);
    }

    public void add(long l2) {
        this.addLong(l2);
    }

    public void add(float f2) {
        this.addFloat(f2);
    }

    public void add(double d2) {
        this.addDouble(d2);
    }

    public void add(String string) {
        this.addStr(string);
    }

    public void add(ByteBuffer byteBuffer) {
        this.addBuf(byteBuffer);
    }

    public native XcastVariant getAt(int var1);

    public native boolean booleanAt(int var1);

    public native byte byteAt(int var1);

    public native short shortAt(int var1);

    public native int intAt(int var1);

    public native long longAt(int var1);

    public native float floatAt(int var1);

    public native double doubleAt(int var1);

    public native String strAt(int var1);

    public native ByteBuffer bufAt(int var1);

    public native String dump();

    public String toString() {
        if ((object = ((XcastVariant)object).dump()) == null) {
            Object object = "";
        }
        return object;
    }

    public static interface XcastVariantType {
        public static final int v_null = 0;
        public static final int v_bool = 98;
        public static final int v_int16 = 110;
        public static final int v_int32 = 105;
        public static final int v_int64 = 120;
        public static final int v_float = 102;
        public static final int v_double = 100;
        public static final int v_string = 99;
        public static final int v_array = 91;
        public static final int v_dict = 123;
    }
}

