/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.av.mediacodec;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.LongSparseArray;
import com.tencent.av.mediacodec.AndroidCodec;
import com.tencent.av.mediacodec.DeviceCheck;
import com.tencent.av.mediacodec.HWColorFormat;
import com.tencent.av.mediacodec.IMediaCodecCallback;
import com.tencent.avlab.utils.ArrayUtils;
import com.tencent.avlab.utils.QLog;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=16)
public class NativeCodec
implements IMediaCodecCallback {
    private static final String TAG = "NativeCodec";
    public static int TIMEOUTDECFIST_3US = 3000;
    public static int TIMEOUTDECFIST_8US = 8000;
    public static int TIMEOUTDECFIST_20US = 20000;
    public static boolean mUseAsyncAPI = false;
    public static String LEFT = "crop-left";
    public static String TOP = "crop-top";
    public static String RIGHT = "crop-right";
    public static String BOTTOM = "crop-bottom";
    public static String STRIDE = "stride";
    public static String AVCSPS = "csd-0";
    public static String AVCPPS = "csd-1";
    public static String HEVCVPSSPSPPS = "csd-0";
    public static String SLICEHEIGHT = "slice-height";
    static AVCCaps gAVCDecoderCaps;
    static AVCCaps gHEVCDecoderCaps;
    static AVCCaps gHEVCEncoderCaps;
    static AVCCaps gAVCEncoderCaps;
    private int mNativeContext = 0;
    AndroidCodec mCodec;
    long mTimeStamp = 0L;
    long mLastEncFrameTime = 0L;
    long mLastDecFrameTime = 0L;
    int mTryAgainLaterCount = 0;
    int mTryDecLaterCount = 0;
    int mTotalDecOutFrameNum = 0;
    int mTotalDecInFrameNum = 0;
    int mFirstFrameNum = 0;
    int mTryAgainLaterCount2 = 0;
    MediaFormat mFormat = null;
    String mMime;
    int mWidth = 320;
    int mHeight = 240;
    boolean misdecoder;
    int mColorFormat;
    int mFrameRate = 20;
    int mFrameInverval = 30000;
    int mBitRate;
    List<AndroidCodec.InputBufferData> mPendingInputBuffers = new ArrayList<AndroidCodec.InputBufferData>();
    AtomicBoolean mCodersExit = new AtomicBoolean(false);
    boolean mDebugDelay = false;
    LongSparseArray<Long> mDebugDelayMap = null;
    LongSparseArray<Long> mDebugDelayMap2 = null;
    LongSparseArray<Long> mDebugIndexMap = null;
    String mDebugTag = null;
    int setBitRatePending = 0;
    boolean setIFramePending = false;

    public NativeCodec() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=16)
    @SuppressLint(value={"NewApi"})
    public NativeCodec(String object, Map<String, Object> object2, boolean bl) {
        this.mMime = object;
        this.misdecoder = bl;
        this.mWidth = (Integer)object2.get("width");
        this.mHeight = (Integer)object2.get("height");
        if (this.misdecoder) {
            try {
                int n2 = this.mWidth;
                int n3 = this.mHeight;
                this.mFormat = MediaFormat.createVideoFormat((String)object, (int)n2, (int)n3);
                if (((String)object).contains(AndroidCodec.AVC_CODEC_MIME)) {
                    NativeCodec nativeCodec = this;
                    Object object3 = object2;
                    NativeCodec nativeCodec2 = this;
                    nativeCodec2.mFormat.setInteger("max-input-size", n2 * n3);
                    nativeCodec2.mFormat.setInteger("color-format", 21);
                    nativeCodec2.mFormat.setInteger("frame-rate", 60);
                    nativeCodec2.mFormat.setInteger("low-latency", 1);
                    ByteBuffer byteBuffer = (ByteBuffer)object3.get(AVCSPS);
                    ByteBuffer byteBuffer2 = (ByteBuffer)object3.get(AVCPPS);
                    nativeCodec.mFormat.setByteBuffer(AVCSPS, byteBuffer);
                    nativeCodec.mFormat.setByteBuffer(AVCPPS, byteBuffer2);
                }
                if (((String)object).contains(AndroidCodec.HEVC_CODEC_MIME)) {
                    NativeCodec nativeCodec = this;
                    nativeCodec.mFormat.setInteger("max-input-size", n2 * n3);
                    nativeCodec.mFormat.setInteger("color-format", 21);
                    nativeCodec.mFormat.setInteger("frame-rate", 60);
                    nativeCodec.mFormat.setInteger("low-latency", 1);
                    object = (ByteBuffer)object2.get(HEVCVPSSPSPPS);
                    this.mFormat.setByteBuffer(HEVCVPSSPSPPS, (ByteBuffer)object);
                }
                if (QLog.isColorLevel()) {
                    QLog.d(TAG, 0, "width =" + n2 + ", height =" + n3);
                }
                this.createDecCodec();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, TAG, exception);
                }
                this.mCodec = null;
            }
        } else {
            try {
                this.mBitRate = (Integer)object2.get("bitrate");
                this.mFrameRate = (Integer)object2.get("frame-rate");
                this.createEncCodec();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, TAG, exception);
                }
                this.mCodec = null;
            }
        }
        this.mDebugIndexMap = new LongSparseArray();
        if (this.mDebugDelay) {
            NativeCodec nativeCodec = this;
            nativeCodec.mDebugDelayMap = new LongSparseArray();
            nativeCodec.mDebugDelayMap2 = new LongSparseArray();
            object = mUseAsyncAPI ? "Async" : " Sync";
            this.mDebugTag = object;
            object = new StringBuilder().append(this.mDebugTag);
            object2 = this.misdecoder ? "DEC" : "ENC";
            this.mDebugTag = ((StringBuilder)object).append((String)object2).toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void resetCodec() {
        if (this.mCodec != null) {
            NativeCodec nativeCodec = this;
            NativeCodec nativeCodec2 = nativeCodec;
            NativeCodec nativeCodec3 = nativeCodec;
            NativeCodec nativeCodec4 = nativeCodec;
            NativeCodec nativeCodec5 = nativeCodec;
            List<AndroidCodec.InputBufferData> list = nativeCodec.mPendingInputBuffers;
            // MONITORENTER : list
            try {
                nativeCodec3.mCodersExit.set(true);
                nativeCodec4.mPendingInputBuffers.clear();
                nativeCodec5.mDebugIndexMap.clear();
                if (nativeCodec2.mDebugDelay) {
                    NativeCodec nativeCodec6 = this;
                    nativeCodec6.mDebugDelayMap.clear();
                    nativeCodec6.mDebugDelayMap2.clear();
                }
                NativeCodec nativeCodec7 = this;
                nativeCodec7.mCodec.stop();
                nativeCodec7.mCodec.release();
                nativeCodec7.mCodec = null;
                // MONITOREXIT : list
            }
            catch (Throwable throwable) {
                // MONITOREXIT : list
                try {
                    throw throwable;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 0, "resetCodec", exception);
                    }
                    this.mCodec = null;
                }
            }
        }
        try {
            if (this.misdecoder) {
                this.createDecCodec();
            } else {
                this.createEncCodec();
            }
            this.mTimeStamp = 0L;
            this.mLastEncFrameTime = 0L;
            this.mLastDecFrameTime = 0L;
            if (this.mCodec != null) {
                this.mCodec.start();
            }
            this.mCodersExit.set(false);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (!QLog.isColorLevel()) return;
            QLog.e(TAG, 0, "resetCodec", exception);
        }
    }

    private void createDecCodec() {
        this.mCodec = new AndroidCodec();
        if (this.misdecoder) {
            MediaCodecInfo.CodecCapabilities codecCapabilities;
            List<MediaCodecInfo> list = AndroidCodec.getDecoderInfos(this.mMime);
            MediaCodecInfo mediaCodecInfo = list.get(0);
            for (int i2 = 0; i2 < list.size() && (codecCapabilities = AndroidCodec.getCodecCapabilities(list.get(i2), this.mMime)) != null; ++i2) {
                if (ArrayUtils.contains(codecCapabilities.colorFormats, 19)) {
                    mediaCodecInfo = list.get(i2);
                    this.mFormat.setInteger("color-format", 19);
                    break;
                }
                if (!ArrayUtils.contains(codecCapabilities.colorFormats, 21)) continue;
                mediaCodecInfo = list.get(i2);
                this.mFormat.setInteger("color-format", 21);
                break;
            }
            if (!this.mCodec.init(this.mFormat, mediaCodecInfo.getName(), (IMediaCodecCallback)this)) {
                this.mCodec = null;
            }
        }
    }

    private static void initAVCEncoderCaps() {
        MediaCodecInfo.CodecCapabilities codecCapabilities = AndroidCodec.getDecoderInfos(AndroidCodec.AVC_CODEC_MIME);
        gAVCEncoderCaps = new AVCCaps();
        if (codecCapabilities.isEmpty()) {
            return;
        }
        if ((codecCapabilities = AndroidCodec.getCodecCapabilities(codecCapabilities.get(0), AndroidCodec.AVC_CODEC_MIME)) == null) {
            return;
        }
        int n2 = 0;
        while (true) {
            Object object = codecCapabilities.profileLevels;
            if (n2 >= codecCapabilities.profileLevels.length) break;
            if (object[n2].profile == 1) {
                MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray = object;
                object = gAVCEncoderCaps;
                gAVCEncoderCaps.profile = 3;
                NativeCodec.setLevel(codecProfileLevelArray[n2], (AVCCaps)object);
            }
            ++n2;
        }
    }

    private static void initHevcEncoderCaps() {
        MediaCodecInfo.CodecCapabilities codecCapabilities = AndroidCodec.getDecoderInfos(AndroidCodec.HEVC_CODEC_MIME);
        gHEVCEncoderCaps = new AVCCaps();
        if (codecCapabilities.isEmpty()) {
            return;
        }
        if ((codecCapabilities = AndroidCodec.getCodecCapabilities(codecCapabilities.get(0), AndroidCodec.HEVC_CODEC_MIME)) == null) {
            return;
        }
        int n2 = 0;
        while (true) {
            Object object = codecCapabilities.profileLevels;
            if (n2 >= codecCapabilities.profileLevels.length) break;
            if (object[n2].profile == 1) {
                MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray = object;
                object = gHEVCEncoderCaps;
                gHEVCEncoderCaps.profile = 1;
                NativeCodec.setHevcLevel(codecProfileLevelArray[n2], (AVCCaps)object);
            }
            ++n2;
        }
    }

    private static void setLevel(MediaCodecInfo.CodecProfileLevel codecProfileLevel, AVCCaps aVCCaps) {
        switch (codecProfileLevel.level) {
            default: {
                break;
            }
            case 32768: {
                if (aVCCaps.width >= 4096 && aVCCaps.height >= 2304) break;
                AVCCaps aVCCaps2 = aVCCaps;
                aVCCaps2.width = 4096;
                aVCCaps2.height = 2304;
                break;
            }
            case 16384: {
                if (aVCCaps.width >= 3680 && aVCCaps.height >= 1536) break;
                AVCCaps aVCCaps3 = aVCCaps;
                aVCCaps3.width = 3680;
                aVCCaps3.height = 1536;
                break;
            }
            case 8192: {
                if (aVCCaps.width >= 2048 && aVCCaps.height >= 1088) break;
                AVCCaps aVCCaps4 = aVCCaps;
                aVCCaps4.width = 2048;
                aVCCaps4.height = 1088;
                break;
            }
            case 4096: {
                if (aVCCaps.width >= 2048 && aVCCaps.height >= 1024) break;
                AVCCaps aVCCaps5 = aVCCaps;
                aVCCaps5.width = 2048;
                aVCCaps5.height = 1024;
                break;
            }
            case 2048: {
                if (aVCCaps.width >= 2048 && aVCCaps.height >= 1024) break;
                AVCCaps aVCCaps6 = aVCCaps;
                aVCCaps6.width = 2048;
                aVCCaps6.height = 1024;
                break;
            }
            case 1024: {
                if (aVCCaps.width >= 1280 && aVCCaps.height >= 1024) break;
                AVCCaps aVCCaps7 = aVCCaps;
                aVCCaps7.width = 1280;
                aVCCaps7.height = 1024;
                break;
            }
            case 512: {
                if (aVCCaps.width >= 1280 && aVCCaps.height >= 720) break;
                AVCCaps aVCCaps8 = aVCCaps;
                aVCCaps8.width = 1280;
                aVCCaps8.height = 720;
                break;
            }
            case 256: {
                if (aVCCaps.width >= 720 && aVCCaps.height >= 576) break;
                AVCCaps aVCCaps9 = aVCCaps;
                aVCCaps9.width = 720;
                aVCCaps9.height = 576;
                break;
            }
            case 128: {
                if (aVCCaps.width >= 720 && aVCCaps.height >= 576) break;
                AVCCaps aVCCaps10 = aVCCaps;
                aVCCaps10.width = 720;
                aVCCaps10.height = 576;
                break;
            }
            case 64: {
                if (aVCCaps.width >= 352 && aVCCaps.height >= 576) break;
                AVCCaps aVCCaps11 = aVCCaps;
                aVCCaps11.width = 352;
                aVCCaps11.height = 576;
                break;
            }
            case 32: {
                if (aVCCaps.width >= 352 && aVCCaps.height >= 288) break;
                AVCCaps aVCCaps12 = aVCCaps;
                aVCCaps12.width = 352;
                aVCCaps12.height = 288;
                break;
            }
            case 16: {
                if (aVCCaps.width >= 352 && aVCCaps.height >= 288) break;
                AVCCaps aVCCaps13 = aVCCaps;
                aVCCaps13.width = 352;
                aVCCaps13.height = 288;
                break;
            }
            case 8: {
                if (aVCCaps.width >= 352 && aVCCaps.height >= 288) break;
                AVCCaps aVCCaps14 = aVCCaps;
                aVCCaps14.width = 352;
                aVCCaps14.height = 288;
                break;
            }
            case 4: {
                if (aVCCaps.width >= 352 && aVCCaps.height >= 288) break;
                AVCCaps aVCCaps15 = aVCCaps;
                aVCCaps15.width = 352;
                aVCCaps15.height = 288;
                break;
            }
            case 2: {
                if (aVCCaps.width >= 352 && aVCCaps.height >= 288) break;
                AVCCaps aVCCaps16 = aVCCaps;
                aVCCaps16.width = 352;
                aVCCaps16.height = 288;
                break;
            }
            case 1: {
                if (aVCCaps.width >= 176 && aVCCaps.height >= 144) break;
                AVCCaps aVCCaps17 = aVCCaps;
                aVCCaps17.width = 176;
                aVCCaps17.height = 144;
            }
        }
    }

    private static void setHevcLevel(MediaCodecInfo.CodecProfileLevel object, AVCCaps aVCCaps) {
        int n2 = object.level;
        if (n2 == 1) {
            if (aVCCaps.width < 192 || aVCCaps.height < 144) {
                AVCCaps aVCCaps2 = aVCCaps;
                aVCCaps2.width = 192;
                aVCCaps2.height = 144;
            }
        } else if (n2 == 4) {
            if (aVCCaps.width < 352 || aVCCaps.height < 288) {
                AVCCaps aVCCaps3 = aVCCaps;
                aVCCaps3.width = 352;
                aVCCaps3.height = 288;
            }
        } else if (n2 == 16) {
            if (aVCCaps.width < 352 || aVCCaps.height < 576) {
                AVCCaps aVCCaps4 = aVCCaps;
                aVCCaps4.width = 352;
                aVCCaps4.height = 576;
            }
        } else if (n2 == 64) {
            if (aVCCaps.width < 720 || aVCCaps.height < 576) {
                AVCCaps aVCCaps5 = aVCCaps;
                aVCCaps5.width = 720;
                aVCCaps5.height = 576;
            }
        } else if (n2 == 256) {
            if (aVCCaps.width < 1280 || aVCCaps.height < 720) {
                AVCCaps aVCCaps6 = aVCCaps;
                aVCCaps6.width = 1280;
                aVCCaps6.height = 720;
            }
        } else if (n2 == 1024) {
            if (aVCCaps.width < 1920 || aVCCaps.height < 1080) {
                AVCCaps aVCCaps7 = aVCCaps;
                aVCCaps7.width = 1920;
                aVCCaps7.height = 1080;
            }
        } else if (n2 == 4096) {
            if (aVCCaps.width < 1920 || aVCCaps.height < 1080) {
                AVCCaps aVCCaps8 = aVCCaps;
                aVCCaps8.width = 1920;
                aVCCaps8.height = 1080;
            }
        } else if (n2 == 16384) {
            if (aVCCaps.width < 4096 || aVCCaps.height < 2048) {
                AVCCaps aVCCaps9 = aVCCaps;
                aVCCaps9.width = 4096;
                aVCCaps9.height = 2048;
            }
        } else if (n2 == 65536) {
            if (aVCCaps.width < 4096 || aVCCaps.height < 2048) {
                AVCCaps aVCCaps10 = aVCCaps;
                aVCCaps10.width = 4096;
                aVCCaps10.height = 2048;
            }
        } else if (n2 == 262144) {
            if (aVCCaps.width < 4096 || aVCCaps.height < 2048) {
                AVCCaps aVCCaps11 = aVCCaps;
                aVCCaps11.width = 4096;
                aVCCaps11.height = 2048;
            }
        } else if (n2 == 0x100000) {
            if (aVCCaps.width < 4096 || aVCCaps.height < 4096) {
                AVCCaps aVCCaps12 = aVCCaps;
                aVCCaps12.width = 4096;
                aVCCaps12.height = 4096;
            }
        } else if (n2 == 0x400000) {
            if (aVCCaps.width < 4096 || aVCCaps.height < 4096) {
                AVCCaps aVCCaps13 = aVCCaps;
                aVCCaps13.width = 4096;
                aVCCaps13.height = 4096;
            }
        } else if (n2 == 0x1000000) {
            if (aVCCaps.width < 4096 || aVCCaps.height < 4096) {
                AVCCaps aVCCaps14 = aVCCaps;
                aVCCaps14.width = 4096;
                aVCCaps14.height = 4096;
            }
        } else {
            object = "setHevcLevel level.level = " + object.level;
            QLog.e(TAG, 0, (String)object);
        }
    }

    private static void initAVCDecoderCaps() {
        MediaCodecInfo.CodecCapabilities codecCapabilities = AndroidCodec.getCodecCapabilities(AndroidCodec.getDecoderInfos(AndroidCodec.AVC_CODEC_MIME).get(0), AndroidCodec.AVC_CODEC_MIME);
        gAVCDecoderCaps = new AVCCaps();
        if (codecCapabilities == null) {
            return;
        }
        int n2 = 0;
        while (true) {
            Object object = codecCapabilities.profileLevels;
            if (n2 >= codecCapabilities.profileLevels.length) break;
            if (object[n2].profile <= 1) {
                object = gAVCDecoderCaps;
                if (object.profile <= 3) {
                    object.profile = 3;
                }
            } else if (object[n2].profile == 4) {
                object = gAVCDecoderCaps;
                if (object.profile <= 5) {
                    object.profile = 5;
                }
            } else if (object[n2].profile == 8) {
                object = gAVCDecoderCaps;
                if (object.profile <= 5) {
                    object.profile = 5;
                }
            } else if (object[n2].profile == 16) {
                object = gAVCDecoderCaps;
                if (object.profile <= 5) {
                    object.profile = 5;
                }
            } else if (object[n2].profile == 32) {
                object = gAVCDecoderCaps;
                if (object.profile <= 5) {
                    object.profile = 5;
                }
            } else if (object[n2].profile == 2) {
                object = gAVCDecoderCaps;
                if (object.profile <= 4) {
                    object.profile = 4;
                }
            } else if (object[n2].profile >= 64) {
                object = gAVCDecoderCaps;
                if (object.profile <= 5) {
                    object.profile = 5;
                }
            }
            object = codecCapabilities.profileLevels;
            if (codecCapabilities.profileLevels[n2].level <= 1) {
                object = gAVCDecoderCaps;
                if (object.width < 176 || object.height < 144) {
                    AVCCaps aVCCaps = gAVCDecoderCaps;
                    aVCCaps.width = 176;
                    aVCCaps.height = 144;
                }
            } else if (object[n2].level == 2) {
                object = gAVCDecoderCaps;
                if (object.width < 352 || object.height < 288) {
                    AVCCaps aVCCaps = gAVCDecoderCaps;
                    aVCCaps.width = 352;
                    aVCCaps.height = 288;
                }
            } else if (object[n2].level == 4) {
                object = gAVCDecoderCaps;
                if (object.width < 352 || object.height < 288) {
                    AVCCaps aVCCaps = gAVCDecoderCaps;
                    aVCCaps.width = 352;
                    aVCCaps.height = 288;
                }
            } else if (object[n2].level == 8) {
                object = gAVCDecoderCaps;
                if (object.width < 352 || object.height < 288) {
                    AVCCaps aVCCaps = gAVCDecoderCaps;
                    aVCCaps.width = 352;
                    aVCCaps.height = 288;
                }
            } else if (object[n2].level == 16) {
                object = gAVCDecoderCaps;
                if (object.width < 352 || object.height < 288) {
                    AVCCaps aVCCaps = gAVCDecoderCaps;
                    aVCCaps.width = 352;
                    aVCCaps.height = 288;
                }
            } else if (object[n2].level == 32) {
                object = gAVCDecoderCaps;
                if (object.width < 352 || object.height < 288) {
                    AVCCaps aVCCaps = gAVCDecoderCaps;
                    aVCCaps.width = 352;
                    aVCCaps.height = 288;
                }
            } else if (object[n2].level == 64) {
                object = gAVCDecoderCaps;
                if (object.width < 352 || object.height < 576) {
                    AVCCaps aVCCaps = gAVCDecoderCaps;
                    aVCCaps.width = 352;
                    aVCCaps.height = 576;
                }
            } else if (object[n2].level == 128) {
                object = gAVCDecoderCaps;
                if (object.width < 720 || object.height < 576) {
                    AVCCaps aVCCaps = gAVCDecoderCaps;
                    aVCCaps.width = 720;
                    aVCCaps.height = 576;
                }
            } else if (object[n2].level == 256) {
                object = gAVCDecoderCaps;
                if (object.width < 720 || object.height < 576) {
                    AVCCaps aVCCaps = gAVCDecoderCaps;
                    aVCCaps.width = 720;
                    aVCCaps.height = 576;
                }
            } else if (object[n2].level == 512) {
                object = gAVCDecoderCaps;
                if (object.width < 1280 || object.height < 720) {
                    AVCCaps aVCCaps = gAVCDecoderCaps;
                    aVCCaps.width = 1280;
                    aVCCaps.height = 720;
                }
            } else if (object[n2].level == 1024) {
                object = gAVCDecoderCaps;
                if (object.width < 1280 || object.height < 1024) {
                    AVCCaps aVCCaps = gAVCDecoderCaps;
                    aVCCaps.width = 1280;
                    aVCCaps.height = 1024;
                }
            } else if (object[n2].level == 2048) {
                object = gAVCDecoderCaps;
                if (object.width < 2048 || object.height < 1024) {
                    AVCCaps aVCCaps = gAVCDecoderCaps;
                    aVCCaps.width = 2048;
                    aVCCaps.height = 1200;
                }
            } else if (object[n2].level == 4096) {
                object = gAVCDecoderCaps;
                if (object.width < 2048 || object.height < 1024) {
                    AVCCaps aVCCaps = gAVCDecoderCaps;
                    aVCCaps.width = 2048;
                    aVCCaps.height = 1024;
                }
            } else if (object[n2].level == 8192) {
                object = gAVCDecoderCaps;
                if (object.width < 2048 || object.height < 1088) {
                    AVCCaps aVCCaps = gAVCDecoderCaps;
                    aVCCaps.width = 2048;
                    aVCCaps.height = 1088;
                }
            } else if (object[n2].level == 16384) {
                object = gAVCDecoderCaps;
                if (object.width < 3680 || object.height < 1536) {
                    AVCCaps aVCCaps = gAVCDecoderCaps;
                    aVCCaps.width = 3680;
                    aVCCaps.height = 1536;
                }
            } else if (object[n2].level == 32768) {
                object = gAVCDecoderCaps;
                if (object.width < 4096 || object.height < 2304) {
                    AVCCaps aVCCaps = gAVCDecoderCaps;
                    aVCCaps.width = 4096;
                    aVCCaps.height = 2304;
                }
            } else if (object[n2].level > 32768) {
                object = gAVCDecoderCaps;
                if (object.width < 4096 || object.height < 4096) {
                    AVCCaps aVCCaps = gAVCDecoderCaps;
                    aVCCaps.width = 4096;
                    aVCCaps.height = 4096;
                }
            } else {
                object = "initAVCDecoderCaps caps.profileLevels[" + n2 + "].level = " + codecCapabilities.profileLevels[n2].level;
                QLog.e(TAG, 0, (String)object);
            }
            ++n2;
        }
    }

    private static void initHevcDecoderCaps() {
        MediaCodecInfo.CodecCapabilities codecCapabilities = AndroidCodec.getCodecCapabilities(AndroidCodec.getDecoderInfos(AndroidCodec.HEVC_CODEC_MIME).get(0), AndroidCodec.HEVC_CODEC_MIME);
        gHEVCDecoderCaps = new AVCCaps();
        if (codecCapabilities == null) {
            return;
        }
        int n2 = 0;
        while (true) {
            Object object = codecCapabilities.profileLevels;
            if (n2 >= codecCapabilities.profileLevels.length) break;
            if (object[n2].profile <= 1) {
                object = gHEVCDecoderCaps;
                if (object.profile <= 1) {
                    object.profile = 1;
                }
            } else if (object[n2].profile == 2) {
                object = gHEVCDecoderCaps;
                if (object.profile <= 2) {
                    object.profile = 2;
                }
            } else if (object[n2].profile >= 2) {
                object = gHEVCDecoderCaps;
                if (object.profile <= 2) {
                    object.profile = 2;
                }
            }
            object = codecCapabilities.profileLevels;
            if (codecCapabilities.profileLevels[n2].level <= 1) {
                object = gHEVCDecoderCaps;
                if (object.width < 352 || object.height < 288) {
                    AVCCaps aVCCaps = gHEVCDecoderCaps;
                    aVCCaps.width = 352;
                    aVCCaps.height = 288;
                }
            } else if (object[n2].level == 4) {
                object = gHEVCDecoderCaps;
                if (object.width < 352 || object.height < 288) {
                    AVCCaps aVCCaps = gHEVCDecoderCaps;
                    aVCCaps.width = 352;
                    aVCCaps.height = 288;
                }
            } else if (object[n2].level == 16) {
                object = gHEVCDecoderCaps;
                if (object.width < 352 || object.height < 576) {
                    AVCCaps aVCCaps = gHEVCDecoderCaps;
                    aVCCaps.width = 352;
                    aVCCaps.height = 576;
                }
            } else if (object[n2].level == 64) {
                object = gHEVCDecoderCaps;
                if (object.width < 720 || object.height < 576) {
                    AVCCaps aVCCaps = gHEVCDecoderCaps;
                    aVCCaps.width = 720;
                    aVCCaps.height = 576;
                }
            } else if (object[n2].level == 256) {
                object = gHEVCDecoderCaps;
                if (object.width < 1280 || object.height < 720) {
                    AVCCaps aVCCaps = gHEVCDecoderCaps;
                    aVCCaps.width = 1280;
                    aVCCaps.height = 720;
                }
            } else if (object[n2].level == 1024) {
                object = gHEVCDecoderCaps;
                if (object.width < 2048 || object.height < 1024) {
                    AVCCaps aVCCaps = gHEVCDecoderCaps;
                    aVCCaps.width = 2048;
                    aVCCaps.height = 1024;
                }
            } else if (object[n2].level == 4096) {
                object = gHEVCDecoderCaps;
                if (object.width < 2048 || object.height < 1024) {
                    AVCCaps aVCCaps = gHEVCDecoderCaps;
                    aVCCaps.width = 2048;
                    aVCCaps.height = 1024;
                }
            } else if (object[n2].level == 16384) {
                object = gHEVCDecoderCaps;
                if (object.width < 4096 || object.height < 2304) {
                    AVCCaps aVCCaps = gHEVCDecoderCaps;
                    aVCCaps.width = 4096;
                    aVCCaps.height = 2304;
                }
            } else if (object[n2].level == 65536) {
                object = gHEVCDecoderCaps;
                if (object.width < 4096 || object.height < 2304) {
                    AVCCaps aVCCaps = gHEVCDecoderCaps;
                    aVCCaps.width = 4096;
                    aVCCaps.height = 2304;
                }
            } else if (object[n2].level == 262144) {
                object = gHEVCDecoderCaps;
                if (object.width < 4096 || object.height < 2304) {
                    AVCCaps aVCCaps = gHEVCDecoderCaps;
                    aVCCaps.width = 4096;
                    aVCCaps.height = 2304;
                }
            } else if (object[n2].level == 0x100000) {
                object = gHEVCDecoderCaps;
                if (object.width < 8192 || object.height < 4320) {
                    AVCCaps aVCCaps = gHEVCDecoderCaps;
                    aVCCaps.width = 8192;
                    aVCCaps.height = 4320;
                }
            } else if (object[n2].level == 0x400000) {
                object = gHEVCDecoderCaps;
                if (object.width < 8192 || object.height < 4320) {
                    AVCCaps aVCCaps = gHEVCDecoderCaps;
                    aVCCaps.width = 8192;
                    aVCCaps.height = 4320;
                }
            } else if (object[n2].level > 0x1000000) {
                object = gHEVCDecoderCaps;
                if (object.width < 8192 || object.height < 4320) {
                    AVCCaps aVCCaps = gHEVCDecoderCaps;
                    aVCCaps.width = 8192;
                    aVCCaps.height = 4320;
                }
            } else {
                object = "initHevcDecoderCaps caps.profileLevels[" + n2 + "].level = " + codecCapabilities.profileLevels[n2].level;
                QLog.e(TAG, 0, (String)object);
            }
            ++n2;
        }
    }

    private static int getIntValues(String string, String string2, boolean bl) {
        if (QLog.isColorLevel()) {
            String string3 = "getIntValues mime: " + string + ", key: " + string2;
            QLog.d(TAG, 0, string3);
        }
        if (Build.VERSION.SDK_INT < 16) {
            return 0;
        }
        if ("supportAsync".equalsIgnoreCase(string2)) {
            mUseAsyncAPI = DeviceCheck.isSupportAsyncAPI();
            return mUseAsyncAPI ? 1 : 0;
        }
        if (string.equalsIgnoreCase(AndroidCodec.AVC_CODEC_MIME)) {
            if (bl) {
                if (gAVCDecoderCaps == null) {
                    NativeCodec.initAVCDecoderCaps();
                }
                if (string2.equalsIgnoreCase("width")) {
                    return NativeCodec.gAVCDecoderCaps.width;
                }
                if (string2.equalsIgnoreCase("height")) {
                    return NativeCodec.gAVCDecoderCaps.height;
                }
                if (string2.equalsIgnoreCase("profile")) {
                    return NativeCodec.gAVCDecoderCaps.profile;
                }
            } else {
                if (gAVCEncoderCaps == null) {
                    NativeCodec.initAVCEncoderCaps();
                }
                if (string2.equalsIgnoreCase("width")) {
                    return NativeCodec.gAVCEncoderCaps.width;
                }
                if (string2.equalsIgnoreCase("height")) {
                    return NativeCodec.gAVCEncoderCaps.height;
                }
                if (string2.equalsIgnoreCase("profile")) {
                    return NativeCodec.gAVCEncoderCaps.profile;
                }
            }
        } else if (string.equalsIgnoreCase(AndroidCodec.HEVC_CODEC_MIME)) {
            if (bl) {
                if (gHEVCDecoderCaps == null) {
                    NativeCodec.initHevcDecoderCaps();
                }
                if (string2.equalsIgnoreCase("width")) {
                    return NativeCodec.gHEVCDecoderCaps.width;
                }
                if (string2.equalsIgnoreCase("height")) {
                    return NativeCodec.gHEVCDecoderCaps.height;
                }
                if (string2.equalsIgnoreCase("profile")) {
                    return NativeCodec.gHEVCDecoderCaps.profile;
                }
            } else {
                if (gHEVCEncoderCaps == null) {
                    NativeCodec.initHevcEncoderCaps();
                }
                if (string2.equalsIgnoreCase("width")) {
                    return NativeCodec.gHEVCEncoderCaps.width;
                }
                if (string2.equalsIgnoreCase("height")) {
                    return NativeCodec.gHEVCEncoderCaps.height;
                }
                if (string2.equalsIgnoreCase("profile")) {
                    return NativeCodec.gHEVCEncoderCaps.profile;
                }
            }
        }
        return 0;
    }

    private static boolean onAttach(String string, int n2, boolean bl, Map<String, Object> map) {
        NativeCodec nativeCodec;
        if (QLog.isColorLevel()) {
            QLog.d(TAG, 0, "onAttach");
        }
        if (Build.VERSION.SDK_INT < 16) {
            return false;
        }
        NativeCodec nativeCodec2 = nativeCodec;
        if (new NativeCodec((String)string, map, (boolean)bl).mCodec == null) {
            return false;
        }
        NativeCodec nativeCodec3 = nativeCodec2;
        nativeCodec3.mNativeContext = n2;
        nativeCodec3.attachCodec(nativeCodec3);
        nativeCodec3.mTimeStamp = 0L;
        nativeCodec3.mTryAgainLaterCount = 0;
        nativeCodec3.mLastEncFrameTime = 0L;
        nativeCodec3.mLastDecFrameTime = 0L;
        nativeCodec3.mTotalDecInFrameNum = 0;
        nativeCodec3.mTotalDecOutFrameNum = 0;
        return nativeCodec3.mCodec.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void onDetach(Object object) {
        if (QLog.isColorLevel()) {
            QLog.d(TAG, 0, "onDetach");
        }
        if (Build.VERSION.SDK_INT < 16) {
            return;
        }
        if ((object = (NativeCodec)object) == null) return;
        Object object2 = object;
        ((NativeCodec)object2).detachCodec();
        ((NativeCodec)object2).mTryAgainLaterCount = 0;
        ((NativeCodec)object2).mTimeStamp = 0L;
        ((NativeCodec)object2).mFormat = null;
        ((NativeCodec)object2).mLastEncFrameTime = 0L;
        ((NativeCodec)object2).mLastDecFrameTime = 0L;
        ((NativeCodec)object2).mTotalDecInFrameNum = 0;
        ((NativeCodec)object2).mTotalDecOutFrameNum = 0;
        List<AndroidCodec.InputBufferData> list = ((NativeCodec)object2).mPendingInputBuffers;
        synchronized (list) {
            ((NativeCodec)object2).mCodersExit.set(true);
            ((NativeCodec)object2).mPendingInputBuffers.clear();
            ((NativeCodec)object2).mDebugIndexMap.clear();
            if (((NativeCodec)object2).mDebugDelay) {
                Object object3 = object;
                ((NativeCodec)object3).mDebugDelayMap.clear();
                ((NativeCodec)object3).mDebugDelayMap2.clear();
            }
            if (((NativeCodec)object).mCodec == null) return;
            try {
                Object object4 = object;
                ((NativeCodec)object4).mCodec.stop();
                ((NativeCodec)object4).mCodec.release();
            }
            catch (Exception exception) {}
            {
                ((NativeCodec)object).mCodec = null;
                return;
            }
        }
    }

    private boolean setFrame(ByteBuffer byteBuffer, int n2, MediaFormat mediaFormat) {
        MediaFormat mediaFormat2 = mediaFormat;
        int n3 = mediaFormat2.getInteger("width");
        int n4 = mediaFormat2.getInteger("height");
        int n5 = mediaFormat2.getInteger(LEFT);
        int n6 = mediaFormat2.getInteger(RIGHT);
        int n7 = mediaFormat2.getInteger(TOP);
        int n8 = mediaFormat2.getInteger(BOTTOM);
        int n9 = mediaFormat2.getInteger(STRIDE);
        int n10 = mediaFormat2.getInteger(SLICEHEIGHT);
        int n11 = mediaFormat.getInteger("color-format");
        String string = "setFrame, width: " + n3;
        QLog.d(TAG, 0, string);
        string = "setFrame, height: " + n4;
        QLog.d(TAG, 0, string);
        string = "setFrame, crop_left: " + n5;
        QLog.d(TAG, 0, string);
        string = "setFrame, crop_right: " + n6;
        QLog.d(TAG, 0, string);
        string = "setFrame, crop_top: " + n7;
        QLog.d(TAG, 0, string);
        string = "setFrame, crop_bottom: " + n8;
        QLog.d(TAG, 0, string);
        string = "setFrame, stride: " + n9;
        QLog.d(TAG, 0, string);
        string = "setFrame, slice_height: " + n10;
        QLog.d(TAG, 0, string);
        string = "setFrame, colorFormat: " + n11;
        QLog.d(TAG, 0, string);
        if (n10 < n4) {
            n10 = n4;
        }
        if (n9 < n3) {
            n9 = n3;
        }
        if (n11 == 2130706688) {
            n10 -= n7 / 2;
            n7 = 0;
            n5 = 0;
        }
        if (n9 < n3) {
            n9 = n3;
        }
        if (2141391876 != n11 && 2130706433 != n11 && 2130706944 != n11 || n4 >= n10) {
            n10 = n4;
        }
        if (n5 + n6 + n7 + n8 == 0) {
            n7 = 0;
            n6 = n3 - 1;
            n8 = n4 - 1;
            n5 = n7;
            n4 = n10;
            n3 = n9;
        } else {
            n3 = n6 - n5 + 1;
            n4 = n8 - n7 + 1;
            if (n9 >= n3) {
                n3 = n9;
            }
            if (n10 >= n4) {
                n4 = n10;
            }
            int n12 = n5;
            n5 = n7;
            n7 = n12;
        }
        if (n3 > 0 && n4 > 0 && n6 > 0 && n8 > 0) {
            NativeCodec nativeCodec = object;
            Object object = "setFrame, picWidth: " + n3;
            QLog.d(TAG, 0, (String)object);
            object = "setFrame, picHeight: " + n4;
            QLog.d(TAG, 0, (String)object);
            SystemClock.elapsedRealtime();
            int n13 = nativeCodec.readOutputDataEx(byteBuffer, n2, n3, n4, n7, n5, n6 - n7 + 1, n8 - n5 + 1, n11);
            SystemClock.elapsedRealtime();
            return n13 > 0;
        }
        if (QLog.isColorLevel()) {
            QLog.e(TAG, 0, "error decoderInfomations.");
        }
        return false;
    }

    private void setParameters(String string, int n2) {
        Bundle bundle;
        if (nativeCodec2.mCodec == null) {
            return;
        }
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("frame-rate")) {
            if (n2 > 0) {
                nativeCodec2.mFrameRate = n2;
                nativeCodec2.mFrameInverval = 1000000 / nativeCodec2.mFrameRate;
                if (QLog.isColorLevel()) {
                    String string2 = "HWENC setParameters mFrameRate = " + nativeCodec2.mFrameRate;
                    QLog.d(TAG, 0, string2);
                }
            } else {
                return;
            }
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        NativeCodec nativeCodec = nativeCodec2;
        NativeCodec nativeCodec2 = bundle;
        nativeCodec2();
        bundle.putInt(string, n2);
        nativeCodec.mCodec.setParameters((Bundle)nativeCodec2);
    }

    private boolean onCalcDelay(int n2) {
        if (this.mDebugDelay) {
            if (QLog.isColorLevel()) {
                String string = this.mDebugTag + " frameIndex:" + n2;
                QLog.d(TAG, 0, string);
            }
            this.mDebugDelayMap2.put((long)n2, (Object)System.currentTimeMillis());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int onDoCodecAsync(int n2, int n3) {
        QLog.e(TAG, 0, "Enter onDoCodecAsync.");
        if (!mUseAsyncAPI) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "NOT in async mode.");
            }
            return -1;
        }
        NativeCodec nativeCodec = this;
        List<AndroidCodec.InputBufferData> list = nativeCodec.mPendingInputBuffers;
        synchronized (list) {
            int n4;
            AndroidCodec.InputBufferData inputBufferData;
            if (nativeCodec.mCodersExit.get()) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "hardware coders exit, return.");
                }
                return 2;
            }
            if (this.mPendingInputBuffers.size() <= 0) {
                return 2;
            }
            if (QLog.isColorLevel()) {
                QLog.d(TAG, 0, "InputData pendingInputBuffers exist, size: " + this.mPendingInputBuffers.size());
            }
            if ((inputBufferData = this.mPendingInputBuffers.get(0)) == null) {
                return 2;
            }
            if (inputBufferData.buffer == null) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "inputbuffer null, return");
                }
                return -1;
            }
            if (inputBufferData.processing) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "curr buffer is being processed by other thread, return");
                }
                return 2;
            }
            if (this.misdecoder) {
                n4 = this.writeInputData(inputBufferData.buffer, false);
            } else {
                if (QLog.isColorLevel()) {
                    QLog.d(TAG, 0, "call writeInputData2 in onDoCodec");
                }
                n4 = this.writeInputData2(inputBufferData.buffer, this.mColorFormat, false);
            }
            if (n4 > 0) {
                NativeCodec nativeCodec2 = this;
                nativeCodec2.mLastEncFrameTime += (long)this.mFrameInverval;
                nativeCodec2.mPendingInputBuffers.remove(0);
                if (nativeCodec2.mDebugDelay) {
                    this.mDebugDelayMap.put(this.mLastEncFrameTime, (Object)System.currentTimeMillis());
                }
                NativeCodec nativeCodec3 = this;
                nativeCodec3.mDebugIndexMap.put(this.mLastEncFrameTime, (Object)n3);
                nativeCodec3.mCodec.queueInputBuffer(inputBufferData.index, n4, this.mLastEncFrameTime, 0);
                return 1;
            }
            if (n4 != 0 && n4 != -1) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean onDoCodec(int var1_2, int var2_7) {
        block145: {
            block146: {
                block149: {
                    block148: {
                        block147: {
                            block144: {
                                block143: {
                                    block131: {
                                        block141: {
                                            block142: {
                                                block140: {
                                                    block138: {
                                                        block139: {
                                                            block132: {
                                                                block133: {
                                                                    block130: {
                                                                        block127: {
                                                                            QLog.e("NativeCodec", 0, "Enter onDoCodec.");
                                                                            var1_3 = this.mCodec;
                                                                            if (var1_3 == null) {
                                                                                return false;
                                                                            }
                                                                            if (this.mTryAgainLaterCount >= 16) {
                                                                                if (!QLog.isColorLevel()) return false;
                                                                                QLog.e("NativeCodec", 0, "try too many times!");
                                                                                return false;
                                                                            }
                                                                            var1_3 = var1_3.getInputBuffer();
                                                                            var3_11 = 0;
                                                                            while (var1_3 == null) {
                                                                                block129: {
                                                                                    block128: {
                                                                                        block126: {
                                                                                            if (!QLog.isColorLevel()) break block126;
                                                                                            QLog.e("NativeCodec", 0, "inputbuffer not available");
                                                                                        }
                                                                                        ++var3_11;
                                                                                        if (this.mCodec.getInputBuffer() != null) break block127;
                                                                                        try {
                                                                                            if (!QLog.isColorLevel()) break block128;
                                                                                        }
                                                                                        catch (Exception var1_4) {
                                                                                            var1_3 = var4_12;
                                                                                            var4_12 = var1_4;
                                                                                            break block129;
                                                                                        }
                                                                                        v0 = new StringBuilder();
                                                                                        QLog.e("NativeCodec", 0, v0.append("inputbuffer not available, try count = ").append(var3_11).toString());
                                                                                    }
                                                                                    if (var3_11 > 60) {
                                                                                        if (!QLog.isColorLevel()) return false;
                                                                                        v1 = new StringBuilder();
                                                                                        QLog.e("NativeCodec", 0, v1.append("inputbuffer not available, return try count = ").append(var3_11).toString());
                                                                                        return false;
                                                                                    }
                                                                                    var1_3 = var4_12;
                                                                                    continue;
                                                                                    catch (Exception var4_13) {
                                                                                        // empty catch block
                                                                                    }
                                                                                }
                                                                                var4_12.printStackTrace();
                                                                                if (!QLog.isColorLevel()) continue;
                                                                                QLog.e("NativeCodec", 0, "onDoCodec Exception", (Exception)var4_12);
                                                                            }
                                                                            var4_12 = var1_3;
                                                                        }
                                                                        if (!this.misdecoder) ** GOTO lbl61
                                                                        v2 = this;
                                                                        v3 = var4_12.buffer;
                                                                        var1_5 = v2.writeInputData(v3, false);
                                                                        break block130;
lbl61:
                                                                        // 1 sources

                                                                        v4 = this;
                                                                        v5 = var4_12.buffer;
                                                                        v6 = this.mColorFormat;
                                                                        var1_5 = v4.writeInputData2(v5, v6, false);
                                                                    }
                                                                    if (var1_5 < 0) {
                                                                        if (!QLog.isColorLevel()) return false;
                                                                        QLog.e("NativeCodec", 0, "writeInputData, sampleSize < 0");
                                                                        return false;
                                                                    }
                                                                    v7 = this;
                                                                    v8 = v7;
                                                                    v9 = v7;
                                                                    v10 = v7.mLastEncFrameTime + (long)this.mFrameInverval;
                                                                    v9.mLastEncFrameTime = v10;
                                                                    if (!v8.mDebugDelay) ** GOTO lbl83
                                                                    this.mDebugDelayMap.put(this.mLastEncFrameTime, (Object)System.currentTimeMillis());
lbl83:
                                                                    // 2 sources

                                                                    v11 = this;
                                                                    v12 = v11;
                                                                    v13 = v11.mDebugIndexMap;
                                                                    v14 = this.mLastEncFrameTime;
                                                                    v13.put(v14, (Object)((long)var2_7));
                                                                    if (!v12.misdecoder) ** GOTO lbl109
                                                                    v15 = this;
                                                                    v16 = v15;
                                                                    v17 = v15;
                                                                    v18 = v15;
                                                                    v19 = v15;
                                                                    v20 = v15.mTotalDecInFrameNum;
                                                                    v17.mTotalDecInFrameNum = v20 + 1;
                                                                    v21 = v18.mLastDecFrameTime;
                                                                    v19.mLastDecFrameTime = v21 + 15000L;
                                                                    v22 = v16.mCodec;
                                                                    v23 = var4_12.index;
                                                                    v24 = var1_5;
                                                                    v25 = this.mLastDecFrameTime;
                                                                    v22.queueInputBuffer(v23, v24, v25, 0);
                                                                    ** GOTO lbl115
lbl109:
                                                                    // 1 sources

                                                                    v26 = this.mCodec;
                                                                    v27 = var4_12.index;
                                                                    v28 = var1_5;
                                                                    v29 = this.mLastEncFrameTime;
                                                                    v26.queueInputBuffer(v27, v28, v29, 0);
lbl115:
                                                                    // 2 sources

                                                                    if (!this.misdecoder) break block131;
                                                                    if (this.mTotalDecInFrameNum != 1) ** GOTO lbl132
                                                                    var2_8 = this.mCodec.dequeueOutputBuffer_First(NativeCodec.TIMEOUTDECFIST_8US);
                                                                    if (!QLog.isColorLevel()) break block132;
                                                                    v30 = new StringBuilder();
                                                                    v31 = v30.append("dequeueOutputBuffer1 begin sampleSize = ").append(var1_5);
                                                                    v32 = v31.append(" buff.index = ").append(var4_12.index);
                                                                    v33 = v32.append(" mTotalDecInFrameNum = ").append(this.mTotalDecInFrameNum);
                                                                    QLog.e("NativeCodec", 0, v33.append(" mTotalDecOutFrameNum = ").append(this.mTotalDecOutFrameNum).toString());
                                                                    break block132;
lbl132:
                                                                    // 1 sources

                                                                    if (this.mTotalDecInFrameNum - this.mTotalDecOutFrameNum <= 1) break block133;
                                                                    var1_5 = 0;
                                                                    while (true) {
                                                                        block137: {
                                                                            block136: {
                                                                                block135: {
                                                                                    block134: {
                                                                                        if (this.mTotalDecInFrameNum - this.mTotalDecOutFrameNum <= 1) return true;
                                                                                        var2_9 = this.mCodec.dequeueOutputBuffer_First(NativeCodec.TIMEOUTDECFIST_3US);
                                                                                        if (var2_9 != null) break block134;
                                                                                        QLog.e("NativeCodec", 0, "onDoCodec output err!");
                                                                                        return true;
                                                                                    }
                                                                                    var3_11 = var1_5 == 0 ? 20 : 10;
                                                                                    if (var2_9.index >= 0) break block135;
                                                                                    v34 = this;
                                                                                    v35 = v34;
                                                                                    v36 = v34.mTryDecLaterCount;
                                                                                    v35.mTryDecLaterCount = v36 + 1;
                                                                                    if (!QLog.isColorLevel()) ** GOTO lbl162
                                                                                    v37 = new StringBuilder();
                                                                                    v38 = v37.append("dequeueOutputBuffer2, try again later, count = ").append(this.mTryDecLaterCount);
                                                                                    v39 = v38.append("mTotalDecInFrameNum = ").append(this.mTotalDecInFrameNum);
                                                                                    QLog.e("NativeCodec", 0, v39.append(" mTotalDecOutFrameNum = ").append(this.mTotalDecOutFrameNum).toString());
lbl162:
                                                                                    // 2 sources

                                                                                    if (this.mTryDecLaterCount < var3_11) continue;
                                                                                    v40 = new StringBuilder();
                                                                                    v41 = v40.append("dequeueOutputBuffer2, error count = ").append(this.mTryDecLaterCount);
                                                                                    QLog.e("NativeCodec", 0, v41.append("ulDecDelayNumThred = ").append(var3_11).toString());
                                                                                    this.mTryDecLaterCount = 0;
                                                                                    return true;
                                                                                }
                                                                                this.mTryDecLaterCount = 0;
                                                                                if (var2_9.success) break block136;
                                                                                if (!QLog.isColorLevel()) return false;
                                                                                QLog.e("NativeCodec", 0, "onDoCodec err!");
                                                                                return false;
                                                                            }
                                                                            if (var2_9.format == null) break;
                                                                            if (var2_9.buffer == null) break;
                                                                            v42 = var2_9.format;
                                                                            if (HWColorFormat.isSupportedDecodeFormats(v42.getInteger("color-format"))) break block137;
                                                                            if (!QLog.isColorLevel()) return false;
                                                                            QLog.e("NativeCodec", 0, "onDoCodec don't support format!");
                                                                            return false;
                                                                        }
                                                                        ++var1_5;
                                                                        v43 = var2_9;
                                                                        v44 = v43;
                                                                        v45 = v43;
                                                                        v46 = this;
                                                                        v47 = v46;
                                                                        v48 = v46;
                                                                        v46.setFrame(var2_9.buffer, var2_9.info.size, var2_9.format);
                                                                        v49 = v46.mTotalDecOutFrameNum;
                                                                        v47.mTotalDecOutFrameNum = v49 + 1;
                                                                        v48.mCodec.releaseOutputBuffer(var2_9.index);
                                                                        v44.index = -1;
                                                                        v45.success = true;
                                                                        if (var1_5 == 2) return true;
                                                                        continue;
                                                                        break;
                                                                    }
                                                                    try {
                                                                        this.mCodec.releaseOutputBuffer(var2_9.index);
                                                                        return false;
                                                                    }
                                                                    catch (Exception var0_1) {
                                                                        var0_1.printStackTrace();
                                                                        if (!QLog.isColorLevel()) return false;
                                                                        QLog.e("NativeCodec", 0, "onDoCodec Exception!", var0_1);
                                                                        return false;
                                                                    }
                                                                }
                                                                var2_8 = this.mCodec.dequeueOutputBuffer_First(NativeCodec.TIMEOUTDECFIST_20US);
                                                            }
                                                            if (var2_8 == null) {
                                                                QLog.e("NativeCodec", 0, "onDoCodec output err!");
                                                                return true;
                                                            }
                                                            if (var2_8.index >= 0) break block138;
                                                            v50 = this;
                                                            v51 = v50;
                                                            v52 = v50.mTryDecLaterCount;
                                                            v51.mTryDecLaterCount = v52 + 1;
                                                            if (!QLog.isColorLevel()) break block139;
                                                            v53 = new StringBuilder();
                                                            QLog.e("NativeCodec", 0, v53.append("dequeueOutputBuffer1, try again later, count = ").append(this.mTryDecLaterCount).toString());
                                                        }
                                                        this.mTryDecLaterCount = 0;
                                                        return true;
                                                    }
                                                    if (var2_8.success) break block140;
                                                    if (!QLog.isColorLevel()) return false;
                                                    QLog.e("NativeCodec", 0, "onDoCodec err!");
                                                    return false;
                                                }
                                                if (var2_8.format == null) break block141;
                                                if (var2_8.buffer == null) break block141;
                                                v54 = var2_8.format;
                                                if (HWColorFormat.isSupportedDecodeFormats(v54.getInteger("color-format"))) break block142;
                                                if (!QLog.isColorLevel()) return false;
                                                QLog.e("NativeCodec", 0, "onDoCodec don't support format!");
                                                return false;
                                            }
                                            v55 = this;
                                            v56 = v55;
                                            v57 = v55;
                                            v55.setFrame(var2_8.buffer, var2_8.info.size, var2_8.format);
                                            v58 = v55.mTotalDecOutFrameNum;
                                            v56.mTotalDecOutFrameNum = v58 + 1;
                                            v57.mCodec.releaseOutputBuffer(var2_8.index);
                                            return true;
                                        }
                                        this.mCodec.releaseOutputBuffer(var2_8.index);
                                        return false;
                                    }
                                    v59 = var2_10 = this.mCodec.dequeueOutputBuffer();
                                    v60 = new StringBuilder();
                                    v61 = v60.append("dequeueOutputBuffer() begin sampleSize = ").append(var1_5);
                                    v62 = v61.append(" buff.index = ").append(var4_12.index);
                                    QLog.e("NativeCodec", 0, v62.append(" mLastEncFrameTime = ").append(this.mLastEncFrameTime).toString());
                                    if (v59 == null) return true;
                                    if (var2_10.index >= 0) break block143;
                                    v63 = this;
                                    v64 = v63;
                                    v65 = v63.mTryAgainLaterCount;
                                    v64.mTryAgainLaterCount = v65 + 1;
                                    if (!QLog.isColorLevel()) ** GOTO lbl312
                                    v66 = new StringBuilder();
                                    QLog.e("NativeCodec", 0, v66.append("dequeueOutputBuffer, try again later, count = ").append(this.mTryAgainLaterCount).toString());
lbl312:
                                    // 2 sources

                                    if (this.mTryAgainLaterCount < 16) return true;
                                    v67 = new StringBuilder();
                                    QLog.e("NativeCodec", 0, v67.append("dequeueOutputBuffer, error count = ").append(this.mTryAgainLaterCount).toString());
                                    return false;
                                }
                                this.mTryAgainLaterCount = 0;
                                if (var2_10.success) break block144;
                                if (!QLog.isColorLevel()) return false;
                                QLog.e("NativeCodec", 0, "onDoCodec err!");
                                return false;
                            }
                            if (var2_10.format == null) ** GOTO lbl389
                            if (var2_10.buffer == null) ** GOTO lbl389
                            if (var2_10.info.flags != 1) ** GOTO lbl336
                            QLog.e("NativeCodec", 0, "onDoCodec err flags!");
lbl336:
                            // 2 sources

                            if (var2_10.info.flags != 2) break block145;
                            v68 = this;
                            this.mCodec.releaseOutputBuffer(var2_10.index);
                            v68.readOutputStream(var2_10.buffer, var2_10.info.presentationTimeUs, var2_10.info.offset, var2_10.info.size, var2_10.info.flags);
                            var2_10 = v68.mCodec.dequeueOutputBuffer();
                            if (var2_10 == null) break block146;
                            if (var2_10.index >= 0) break block147;
                            v69 = this;
                            v70 = v69;
                            v71 = v69.mTryAgainLaterCount2;
                            v70.mTryAgainLaterCount2 = v71 + 1;
                            if (!QLog.isColorLevel()) return this.mTryAgainLaterCount2 < 10;
                            v72 = new StringBuilder();
                            QLog.e("NativeCodec", 0, v72.append("re-dequeue dequeueOutputBuffer, try again later, count = ").append(this.mTryAgainLaterCount2).toString());
                            return this.mTryAgainLaterCount2 < 10;
                        }
                        this.mTryAgainLaterCount2 = 0;
                        if (var2_10.success) break block148;
                        if (!QLog.isColorLevel()) return false;
                        QLog.e("NativeCodec", 0, "re-dequeue onDoCodec err!");
                        return false;
                    }
                    if (var2_10.format == null) break block149;
                    if (var2_10.buffer != null) break block146;
                }
                this.mCodec.releaseOutputBuffer(var2_10.index);
                return false;
            }
            if (!QLog.isColorLevel()) break block145;
            QLog.d("NativeCodec", 0, "re-dequeue success");
        }
        if (var2_10 == null) ** GOTO lbl387
        var1_6 = this.calcDelay(true, var2_10.info);
        this.readOutputStream(var2_10.buffer, var1_6, var2_10.info.offset, var2_10.info.size, var2_10.info.flags);
lbl387:
        // 2 sources

        this.mCodec.releaseOutputBuffer(var2_10.index);
        return true;
lbl389:
        // 2 sources

        this.mCodec.releaseOutputBuffer(var2_10.index);
        return false;
    }

    public static native void set_device_infos(String var0);

    public static native int getVersion();

    public static native boolean putByteArray2ByteBuffer(ByteBuffer var0, int var1, byte[] var2, int var3, int var4, int var5, int var6);

    /*
     * Unable to fully structure code
     */
    void createEncCodec() {
        block49: {
            block48: {
                block45: {
                    block42: {
                        block41: {
                            block39: {
                                if (this.mCodec != null) break block49;
                                v0 = this;
                                v1 = v0;
                                var1_1 = AndroidCodec.getEndoderInfos(v0.mMime);
                                v1.mColorFormat = 21;
                                var2_3 = 0;
                                var3_5 = 0;
                                while (true) {
                                    block40: {
                                        if (var3_5 >= var1_1.size()) break;
                                        var4_6 = AndroidCodec.getCodecCapabilities(var1_1.get(var3_5), this.mMime);
                                        if (var4_6 == null) break;
                                        v2 = var4_6.colorFormats;
                                        if (!ArrayUtils.contains(v2, 21)) ** GOTO lbl23
                                        this.mColorFormat = 21;
                                        break block39;
lbl23:
                                        // 1 sources

                                        v3 = var4_6.colorFormats;
                                        if (!ArrayUtils.contains(v3, 19)) break block40;
                                        this.mColorFormat = 19;
                                        break block39;
                                    }
                                    ++var3_5;
                                }
                                var3_5 = var2_3;
                            }
                            this.mCodec = new AndroidCodec();
                            v4 = MediaFormat.createVideoFormat((String)this.mMime, (int)this.mWidth, (int)this.mHeight);
                            v5 = v4;
                            v6 = v4;
                            v7 = var2_4 = v4;
                            v5.setInteger("color-format", this.mColorFormat);
                            v6.setInteger("frame-rate", this.mFrameRate);
                            v7.setInteger("bitrate", this.mBitRate);
                            var4_7 = 864000;
                            if (!QLog.isColorLevel()) ** GOTO lbl55
                            v8 = new StringBuilder();
                            v9 = v8.append("KEY_I_FRAME_INTERVAL = ").append(var4_7);
                            QLog.d("NativeCodec", 0, v9.append(", mFrameRate = ").append(this.mFrameRate).toString());
lbl55:
                            // 2 sources

                            if (Build.VERSION.SDK_INT >= 19) break block41;
                            var2_4.setInteger("i-frame-interval", var4_7);
                            ** GOTO lbl62
                        }
                        var2_4.setInteger("i-frame-interval", var4_7);
lbl62:
                        // 2 sources

                        var4_8 = AndroidCodec.getCodecCapabilities(var1_1.get(var3_5), this.mMime);
                        if (var4_8 != null) ** GOTO lbl67
                        this.mCodec = null;
                        return;
lbl67:
                        // 1 sources

                        if (!this.mMime.contains(AndroidCodec.AVC_CODEC_MIME)) break block42;
                        var5_9 = 0;
                        while (true) {
                            block43: {
                                block44: {
                                    if (var5_9 >= var4_8.profileLevels.length) break;
                                    if (var4_8.profileLevels[var5_9].profile != 1) break block43;
                                    var6_10 = 16;
                                    var2_4.setInteger("profile", 1);
                                    if (16 >= var4_8.profileLevels[var5_9].level) break block44;
                                    var6_10 = var4_8.profileLevels[var5_9].level;
                                }
                                var2_4.setInteger("level", var6_10);
                            }
                            ++var5_9;
                        }
                    }
                    if (!this.mMime.contains(AndroidCodec.HEVC_CODEC_MIME)) break block45;
                    var5_9 = 0;
                    while (true) {
                        block46: {
                            block47: {
                                if (var5_9 >= var4_8.profileLevels.length) break;
                                if (var4_8.profileLevels[var5_9].profile != 1) break block46;
                                var6_10 = 16384;
                                var2_4.setInteger("profile", 1);
                                if (16384 >= var4_8.profileLevels[var5_9].level) break block47;
                                var6_10 = var4_8.profileLevels[var5_9].level;
                            }
                            var2_4.setInteger("level", var6_10);
                        }
                        ++var5_9;
                    }
                }
                this.mFormat = var2_4;
                if (this.mFrameRate <= 0) break block48;
                this.mFrameInverval = 1000000 / this.mFrameRate;
                ** GOTO lbl117
            }
            try {
                this.mFrameInverval = 40000;
lbl117:
                // 2 sources

                this.mCodec.init(this.mFormat, var1_1.get(var3_5).getName(), (IMediaCodecCallback)this);
            }
            catch (Exception var1_2) {
                var1_2.printStackTrace();
                if (QLog.isColorLevel()) {
                    QLog.e("NativeCodec", 0, "createEncCodec", var1_2);
                }
                this.mCodec = null;
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void onInputBufferAvailable(MediaCodec var1_4, int var2_9) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [10 : 117->124)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void onOutputBufferAvailable(MediaCodec object, int n2, MediaCodec.BufferInfo bufferInfo) {
        if (this.mCodersExit.get()) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "codec exit, return onOutputBufferAvailable");
            }
            return;
        }
        object = this.mCodec.getOutputBuffer(n2);
        if (object != null && bufferInfo != null) {
            if (this.misdecoder) {
                MediaFormat mediaFormat = this.mCodec.getOutputFormat(n2);
                if (mediaFormat != null) {
                    this.calcDelay(false, bufferInfo);
                    this.setFrame((ByteBuffer)object, bufferInfo.size, mediaFormat);
                } else if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "getOutputFormat null");
                }
            } else {
                int cfr_ignored_0 = bufferInfo.flags;
                this.calcDelay(false, bufferInfo);
                this.readOutputStream((ByteBuffer)object, bufferInfo.presentationTimeUs, bufferInfo.offset, bufferInfo.size, bufferInfo.flags);
            }
            this.mCodec.releaseOutputBuffer(n2);
        }
    }

    Long calcDelay(boolean bl, MediaCodec.BufferInfo bufferInfo) {
        NativeCodec nativeCodec = this;
        Long l2 = (Long)nativeCodec.mDebugIndexMap.get(bufferInfo.presentationTimeUs);
        if (nativeCodec.mDebugDelay) {
            Object object = (Long)this.mDebugDelayMap.get(bufferInfo.presentationTimeUs);
            if (object != null) {
                if (QLog.isColorLevel()) {
                    object = this.mDebugTag + "small, " + bufferInfo.presentationTimeUs + ", takes:" + (System.currentTimeMillis() - (Long)object);
                    QLog.d(TAG, 0, (String)object);
                }
                this.mDebugDelayMap.remove(bufferInfo.presentationTimeUs);
            }
            if (l2 != null && (object = (Long)this.mDebugDelayMap2.get(l2.longValue())) != null) {
                if (QLog.isColorLevel()) {
                    object = this.mDebugTag + "big, " + bufferInfo.presentationTimeUs + ", takes:" + (System.currentTimeMillis() - (Long)object);
                    QLog.d(TAG, 0, (String)object);
                }
                this.mDebugDelayMap2.remove(l2.longValue());
            }
        }
        this.mDebugIndexMap.remove(bufferInfo.presentationTimeUs);
        return l2;
    }

    @Override
    public void onError(MediaCodec mediaCodec, Exception exception) {
        if (QLog.isColorLevel()) {
            QLog.d(TAG, 0, "onError", exception);
        }
        if (this.mCodersExit.get()) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "codec exit, return onError");
            }
            return;
        }
    }

    @Override
    public void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
        if (QLog.isColorLevel()) {
            QLog.d(TAG, 0, "onOutputFormatChanged");
        }
        if (this.mCodersExit.get()) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "codec exit, return onOutputFormatChanged");
            }
            return;
        }
    }

    void setParams_impl() {
        Bundle bundle;
        if (QLog.isColorLevel()) {
            QLog.d(TAG, 0, "setParams_impl");
        }
        if (this.setIFramePending) {
            Bundle bundle2;
            bundle = bundle2;
            new Bundle().putInt(AndroidCodec.ForceIFrame, 1);
            this.setIFramePending = false;
            int n2 = this.setBitRatePending;
            if (n2 > 0) {
                bundle.putInt("bitrate", n2);
            }
            this.mCodec.setParameters(bundle);
            this.setBitRatePending = 0;
        }
        if (this.setBitRatePending > 0) {
            Bundle bundle3;
            bundle = bundle3;
            bundle();
            bundle3.putInt("bitrate", this.setBitRatePending);
            if (this.setIFramePending) {
                bundle.putInt(AndroidCodec.ForceIFrame, 1);
            }
            this.mCodec.setParameters(bundle);
            this.setBitRatePending = 0;
            this.setIFramePending = false;
        }
    }

    public native int writeInputData(ByteBuffer var1, boolean var2);

    public native int writeInputData2(ByteBuffer var1, int var2, boolean var3);

    public native int readOutputData(ByteBuffer var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    public native int readOutputStream(ByteBuffer var1, long var2, int var4, int var5, int var6);

    public native int setAVCParams(ByteBuffer var1, ByteBuffer var2);

    public native int readOutputDataEx(ByteBuffer var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public native boolean attachCodec(Object var1);

    public native void detachCodec();

    static class AVCCaps {
        public int width = 0;
        public int height = 0;
        public int profile = 3;

        AVCCaps() {
        }
    }
}

