/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.av.mediacodec;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.view.Surface;
import com.tencent.av.mediacodec.DeviceCheck;
import com.tencent.av.mediacodec.IMediaCodecCallback;
import com.tencent.av.mediacodec.NativeCodec;
import com.tencent.avlab.utils.QLog;
import com.tencent.avlab.utils.SoUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=16)
public class AndroidCodec {
    public static int ENC_CODEC = 1;
    public static int DEC_CODEC = 0;
    public static String AVC_CODEC_MIME = "video/avc";
    public static String HEVC_CODEC_MIME = "video/hevc";
    public static String ForceIFrame = "request-sync";
    protected static boolean gfLoaded = false;
    public static String TAG = "AndroidCodec";
    public static int TIMEOUT_US = 33000;
    public static final int SUPPORT_NONE = 0;
    public static final int SUPPORT_AVC_DEC = 1;
    public static final int SUPPORT_AVC_ENC = 2;
    public static final int SUPPORT_HEVC_DEC = 4;
    public static final int SUPPORT_HEVC_ENC = 8;
    protected MediaFormat mFormat;
    protected MediaFormat mOutputFormat;
    protected MediaCodec mMediaCodec;
    protected ByteBuffer[] inputBuffers;
    protected ByteBuffer[] outputBuffers;
    protected int mCodecType;

    private Context reflectApplicationContext() {
        Object object;
        block8: {
            block7: {
                AndroidCodec androidCodec = null;
                object = Class.forName("android.app.ActivityThread");
                if (object == null) break block7;
                Method method = ((Class)object).getDeclaredMethod("currentApplication", new Class[0]);
                try {
                    object = (Application)method.invoke(null, new Object[0]);
                    break block8;
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
            object = androidCodec;
        }
        return object;
    }

    public AndroidCodec() {
        AndroidCodec androidCodec = this;
        androidCodec.mCodecType = DEC_CODEC;
        AndroidCodec.setDeviceInfos(androidCodec.reflectApplicationContext());
    }

    public static void loadCodecLibrarys() {
        if (!gfLoaded) {
            gfLoaded = SoUtil.loadSo("stlport_shared") && SoUtil.loadSo("hwcodec");
        }
    }

    private static void setDeviceInfos(Context object) {
        String string;
        boolean bl = false;
        if (SoUtil.customLibPath != null && new File(string = SoUtil.customLibPath + "/libhwcodec.so").exists()) {
            bl = true;
        }
        if (!bl && new File(string = object.getApplicationInfo().nativeLibraryDir + "/libhwcodec.so").exists()) {
            bl = true;
        }
        if (!bl && new File(string = object.getFilesDir().getParent() + "/txav/libhwcodec.so").exists()) {
            bl = true;
        }
        if (!bl && new File("/system/lib/libhwcodec.so").exists()) {
            bl = true;
        }
        if (!bl) {
            QLog.d(TAG, 0, "setDeviceInfos  ! soExist");
            return;
        }
        if (!gfLoaded) {
            AndroidCodec.loadCodecLibrarys();
            if (gfLoaded) {
                Context context = object;
                object = "PRODUCT=" + Build.PRODUCT.toLowerCase() + ";";
                object = (String)object + "MODEL=" + Build.MODEL.toLowerCase() + ";";
                object = (String)object + "SDK=" + Build.VERSION.SDK_INT + ";";
                object = (String)object + "FINGERPRINT=" + Build.FINGERPRINT.toLowerCase() + ";";
                object = (String)object + "MANUFACTURER=" + Build.MANUFACTURER.toLowerCase() + ";";
                ApplicationInfo applicationInfo = context.getApplicationInfo();
                object = (String)object + "DATADIR=" + applicationInfo.dataDir + ";";
                NativeCodec.set_device_infos(Build.VERSION.SDK_INT >= 9 ? (String)object + "LIBDIR=" + applicationInfo.nativeLibraryDir + ";" : (String)object + "LIBDIR=" + applicationInfo.dataDir + "/lib;");
            }
        }
    }

    public static List<MediaCodecInfo> getDecoderInfos(String string) {
        ArrayList<MediaCodecInfo> arrayList;
        ArrayList<MediaCodecInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<MediaCodecInfo>();
        int n2 = MediaCodecList.getCodecCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (mediaCodecInfo.isEncoder() || mediaCodecInfo.getName().contains(".sw.") || mediaCodecInfo.getName().contains(".SW.") || mediaCodecInfo.getName().contains("google") || mediaCodecInfo.getName().contains("Google") || mediaCodecInfo.getName().contains("GOOGLE")) continue;
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (!stringArray[i3].equalsIgnoreCase(string)) continue;
                arrayList2.add(mediaCodecInfo);
            }
        }
        return arrayList2;
    }

    public static MediaCodecInfo getCodecInfo(String string) {
        int n2 = MediaCodecList.getCodecCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (!mediaCodecInfo.getName().equalsIgnoreCase(string)) continue;
            return mediaCodecInfo;
        }
        return null;
    }

    public static List<MediaCodecInfo> getEndoderInfos(String string) {
        ArrayList<MediaCodecInfo> arrayList;
        ArrayList<MediaCodecInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<MediaCodecInfo>();
        int n2 = MediaCodecList.getCodecCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (mediaCodecInfo == null || !mediaCodecInfo.isEncoder() || mediaCodecInfo.getName().contains(".sw.") || mediaCodecInfo.getName().contains(".SW.") || mediaCodecInfo.getName().contains("google") || mediaCodecInfo.getName().contains("Google") || mediaCodecInfo.getName().contains("GOOGLE")) continue;
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (!stringArray[i3].equalsIgnoreCase(string)) continue;
                arrayList2.add(mediaCodecInfo);
            }
        }
        return arrayList2;
    }

    public static MediaCodecInfo.CodecCapabilities getCodecCapabilities(MediaCodecInfo mediaCodecInfo, String string) {
        try {
            mediaCodecInfo = mediaCodecInfo.getCapabilitiesForType(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            mediaCodecInfo = null;
        }
        return mediaCodecInfo;
    }

    private void setCallback(final IMediaCodecCallback iMediaCodecCallback) {
        if (QLog.isColorLevel()) {
            QLog.d(TAG, 0, "setCallback");
        }
        if (Build.VERSION.SDK_INT < 21) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "setCallback api level lower 21.");
            }
        } else {
            this.mMediaCodec.setCallback(new MediaCodec.Callback(){

                public void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
                    IMediaCodecCallback iMediaCodecCallback2 = iMediaCodecCallback2.iMediaCodecCallback;
                    if (iMediaCodecCallback2 != null) {
                        iMediaCodecCallback2.onOutputFormatChanged(mediaCodec, mediaFormat);
                    }
                }

                public void onOutputBufferAvailable(MediaCodec mediaCodec, int n2, MediaCodec.BufferInfo bufferInfo) {
                    IMediaCodecCallback iMediaCodecCallback2 = iMediaCodecCallback2.iMediaCodecCallback;
                    if (iMediaCodecCallback2 != null) {
                        iMediaCodecCallback2.onOutputBufferAvailable(mediaCodec, n2, bufferInfo);
                    }
                }

                public void onInputBufferAvailable(MediaCodec mediaCodec, int n2) {
                    IMediaCodecCallback iMediaCodecCallback2 = iMediaCodecCallback2.iMediaCodecCallback;
                    if (iMediaCodecCallback2 != null) {
                        iMediaCodecCallback2.onInputBufferAvailable(mediaCodec, n2);
                    }
                }

                @TargetApi(value=21)
                public void onError(MediaCodec mediaCodec, MediaCodec.CodecException codecException) {
                    IMediaCodecCallback iMediaCodecCallback2 = iMediaCodecCallback2.iMediaCodecCallback;
                    if (iMediaCodecCallback2 != null) {
                        iMediaCodecCallback2.onError(mediaCodec, (Exception)codecException);
                    }
                }
            });
        }
    }

    public void setSurface(Surface surface) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean start() {
        if (this.mMediaCodec == null) return false;
        this.mMediaCodec.start();
        if (Build.VERSION.SDK_INT > 20) return true;
        AndroidCodec androidCodec = this;
        AndroidCodec androidCodec2 = androidCodec;
        AndroidCodec androidCodec3 = androidCodec;
        AndroidCodec androidCodec4 = androidCodec;
        AndroidCodec androidCodec5 = androidCodec;
        AndroidCodec androidCodec6 = androidCodec;
        // MONITORENTER : androidCodec
        try {
            androidCodec5.inputBuffers = androidCodec4.mMediaCodec.getInputBuffers();
            androidCodec2.outputBuffers = androidCodec6.mMediaCodec.getOutputBuffers();
            // MONITOREXIT : androidCodec3
            return true;
        }
        catch (Throwable throwable) {
            // MONITOREXIT : this
            try {
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    public void flush() {
        AndroidCodec androidCodec = androidCodec.mMediaCodec;
        if (androidCodec != null) {
            androidCodec.flush();
        }
    }

    public void stop() {
        AndroidCodec androidCodec = androidCodec.mMediaCodec;
        if (androidCodec != null) {
            androidCodec.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferData getInputBuffer() {
        BufferData bufferData;
        if (this.mMediaCodec == null) {
            return null;
        }
        BufferData bufferData2 = bufferData;
        bufferData = new BufferData();
        int n2 = this.mMediaCodec.dequeueInputBuffer((long)TIMEOUT_US);
        if (n2 < 0) {
            return null;
        }
        if (Build.VERSION.SDK_INT <= 20) {
            synchronized (this) {
                bufferData2.index = n2;
                bufferData2.buffer = this.inputBuffers[n2];
                return bufferData2;
            }
        }
        synchronized (this) {
            bufferData2.index = n2;
            try {
                bufferData2.buffer = this.mMediaCodec.getInputBuffer(n2);
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
                bufferData2.success = false;
            }
            return bufferData2;
        }
    }

    public synchronized void queueInputBuffer(int n2, int n3, long l2, int n4) {
        block3: {
            AndroidCodec androidCodec = androidCodec.mMediaCodec;
            if (androidCodec == null) {
                return;
            }
            try {
                androidCodec.queueInputBuffer(n2, 0, n3, l2, n4);
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block3;
                QLog.e(TAG, 0, "queueInputBuffer exception", exception);
            }
        }
    }

    public synchronized BufferData dequeueOutputBuffer() {
        BufferData bufferData;
        block17: {
            int n2;
            block16: {
                BufferData bufferData2;
                if (this.mMediaCodec == null) {
                    return null;
                }
                bufferData = bufferData2;
                bufferData2 = new BufferData();
                n2 = this.mMediaCodec.dequeueOutputBuffer(bufferData.info, (long)TIMEOUT_US);
                switch (n2) {
                    default: {
                        if (n2 < 0) break block16;
                        if (Build.VERSION.SDK_INT > 20) break;
                        bufferData.buffer = this.outputBuffers[n2];
                        bufferData.index = n2;
                        bufferData.format = this.mOutputFormat;
                        break block17;
                    }
                    case -1: {
                        if (QLog.isColorLevel()) {
                            QLog.e(TAG, 0, "dequeueOutputBuffer timed out!");
                        }
                        bufferData.index = -1;
                        break block17;
                    }
                    case -2: {
                        if (QLog.isColorLevel()) {
                            QLog.e(TAG, 0, "INFO_OUTPUT_FORMAT_CHANGED");
                        }
                        bufferData.index = -2;
                        this.mOutputFormat = this.mMediaCodec.getOutputFormat();
                        MediaFormat mediaFormat = this.mOutputFormat;
                        if (mediaFormat != null) {
                            if (this.mCodecType == DEC_CODEC) {
                                int n3 = mediaFormat.getInteger("color-format");
                                if (QLog.isColorLevel()) {
                                    QLog.e(TAG, 0, "New color format: " + n3 + "[0x" + Integer.toHexString(n3) + "]");
                                }
                            } else if (QLog.isColorLevel()) {
                                QLog.e(TAG, 0, "EncCodec, INFO_OUTPUT_FORMAT_CHANGED");
                            }
                        }
                        break block17;
                    }
                    case -3: {
                        if (QLog.isColorLevel()) {
                            QLog.e(TAG, 0, "INFO_OUTPUT_BUFFERS_CHANGED");
                        }
                        this.outputBuffers = this.mMediaCodec.getOutputBuffers();
                        bufferData.index = -3;
                        break block17;
                    }
                }
                bufferData.index = n2;
                try {
                    bufferData.format = this.mMediaCodec.getOutputFormat(n2);
                    bufferData.buffer = this.mMediaCodec.getOutputBuffer(n2);
                }
                catch (IllegalStateException illegalStateException) {
                    illegalStateException.printStackTrace();
                    bufferData.success = false;
                }
                break block17;
            }
            BufferData bufferData3 = bufferData;
            bufferData3.index = n2;
            bufferData3.success = false;
        }
        return bufferData;
    }

    public synchronized BufferData dequeueOutputBuffer_First(int n2) {
        if (this.mMediaCodec == null) {
            return null;
        }
        while (this.mMediaCodec != null) {
            BufferData bufferData;
            BufferData bufferData2 = bufferData;
            bufferData = new BufferData();
            int n3 = this.mMediaCodec.dequeueOutputBuffer(bufferData2.info, (long)n2);
            if (n3 == -3) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, " dequeueOutputBuffer_First INFO_OUTPUT_BUFFERS_CHANGED");
                }
                this.outputBuffers = this.mMediaCodec.getOutputBuffers();
                bufferData2.index = -3;
                continue;
            }
            if (n3 == -2) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "dequeueOutputBuffer_First INFO_OUTPUT_FORMAT_CHANGED");
                }
                AndroidCodec androidCodec = this;
                bufferData2.index = -2;
                androidCodec.mOutputFormat = androidCodec.mMediaCodec.getOutputFormat();
                bufferData2 = androidCodec.mOutputFormat;
                if (bufferData2 == null) continue;
                if (this.mCodecType == DEC_CODEC) {
                    int n4 = bufferData2.getInteger("color-format");
                    if (!QLog.isColorLevel()) continue;
                    QLog.e(TAG, 0, "dequeueOutputBuffer_First New color format: " + n4 + "[0x" + Integer.toHexString(n4) + "]");
                    continue;
                }
                if (!QLog.isColorLevel()) continue;
                QLog.e(TAG, 0, "EncCodec, dequeueOutputBuffer_First INFO_OUTPUT_FORMAT_CHANGED");
                continue;
            }
            if (n3 == -1) {
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "dequeueOutputBuffer_First dequeueOutputBuffer timed out!");
                }
                bufferData2.index = -1;
                return bufferData2;
            }
            if (n3 >= 0) {
                if (Build.VERSION.SDK_INT <= 20) {
                    bufferData2.buffer = this.outputBuffers[n3];
                    bufferData2.index = n3;
                    bufferData2.format = this.mOutputFormat;
                } else {
                    bufferData2.index = n3;
                    try {
                        bufferData2.format = this.mMediaCodec.getOutputFormat(n3);
                        bufferData2.buffer = this.mMediaCodec.getOutputBuffer(n3);
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                        bufferData2.success = false;
                    }
                }
            } else {
                BufferData bufferData3 = bufferData2;
                bufferData3.index = n3;
                bufferData3.success = false;
            }
            return bufferData2;
        }
        return null;
    }

    @TargetApi(value=21)
    public ByteBuffer getInputBuffer(int n2) {
        Object object;
        try {
            object = ((AndroidCodec)object).mMediaCodec.getInputBuffer(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "invoke getInputBuffer exception", exception);
            }
            object = null;
        }
        return object;
    }

    @TargetApi(value=21)
    public ByteBuffer getOutputBuffer(int n2) {
        Object object;
        try {
            object = ((AndroidCodec)object).mMediaCodec.getOutputBuffer(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "invoke getOutputBuffer exception", exception);
            }
            object = null;
        }
        return object;
    }

    @TargetApi(value=21)
    public MediaFormat getOutputFormat(int n2) {
        AndroidCodec androidCodec;
        try {
            androidCodec = androidCodec.mMediaCodec.getOutputFormat(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "invoke getOutputFormat exception", exception);
            }
            androidCodec = null;
        }
        return androidCodec;
    }

    public synchronized void releaseOutputBuffer(int n2) {
        AndroidCodec androidCodec = androidCodec.mMediaCodec;
        if (androidCodec == null) {
            return;
        }
        androidCodec.releaseOutputBuffer(n2, false);
    }

    public synchronized void release() {
        this.inputBuffers = null;
        this.outputBuffers = null;
        MediaCodec mediaCodec = this.mMediaCodec;
        if (mediaCodec != null) {
            mediaCodec.release();
            this.mMediaCodec = null;
        }
    }

    public synchronized void reset() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean init(MediaFormat mediaFormat, String string, IMediaCodecCallback iMediaCodecCallback) {
        AndroidCodec androidCodec;
        if (QLog.isColorLevel()) {
            QLog.e(TAG, 0, "init name: " + string);
        }
        this.mFormat = mediaFormat;
        int n2 = 2;
        MediaCodecInfo mediaCodecInfo = AndroidCodec.getCodecInfo(string);
        if (mediaCodecInfo != null && mediaCodecInfo.isEncoder()) {
            n2 = 1;
            this.mCodecType = ENC_CODEC;
        }
        try {
            androidCodec = this;
            this.mMediaCodec = MediaCodec.createByCodecName((String)string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "init exception", exception);
            }
            return false;
        }
        try {
            if (androidCodec.mMediaCodec != null) {
                if (iMediaCodecCallback != null && DeviceCheck.isSupportAsyncAPI()) {
                    this.setCallback(iMediaCodecCallback);
                }
                this.mMediaCodec.configure(this.mFormat, null, null, n2);
            }
            return this.mMediaCodec != null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "init exception", exception);
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean init(MediaFormat mediaFormat, String string, Surface surface, IMediaCodecCallback iMediaCodecCallback) {
        int n2;
        if (QLog.isColorLevel()) {
            QLog.e(TAG, 0, "init name: " + string);
        }
        this.mFormat = mediaFormat;
        try {
            this.mMediaCodec = MediaCodec.createByCodecName((String)string);
            n2 = 2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "init exception", exception);
            }
            return false;
        }
        string = AndroidCodec.getCodecInfo(string);
        if (string != null && string.isEncoder()) {
            n2 = 1;
            this.mCodecType = ENC_CODEC;
        }
        try {
            if (this.mMediaCodec != null) {
                if (iMediaCodecCallback != null && DeviceCheck.isSupportAsyncAPI()) {
                    this.setCallback(iMediaCodecCallback);
                }
                this.mMediaCodec.configure(this.mFormat, surface, null, n2);
            }
            return this.mMediaCodec != null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "init exception", exception);
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean init(MediaFormat mediaFormat, int n2, IMediaCodecCallback iMediaCodecCallback) {
        if (QLog.isColorLevel()) {
            QLog.e(TAG, 0, "init codecType: " + n2);
        }
        this.mFormat = mediaFormat;
        if (n2 == DEC_CODEC) {
            try {
                this.mMediaCodec = MediaCodec.createDecoderByType((String)this.mFormat.getString("mime"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (QLog.isColorLevel()) {
                    QLog.e(TAG, 0, "init exception", exception);
                }
                return false;
            }
        }
        try {
            this.mMediaCodec = MediaCodec.createEncoderByType((String)this.mFormat.getString("mime"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "init exception", exception);
            }
            return false;
        }
        this.mCodecType = n2;
        try {
            if (this.mMediaCodec != null) {
                int n3 = 2;
                if (n2 == ENC_CODEC) {
                    n3 = 1;
                }
                if (iMediaCodecCallback != null && DeviceCheck.isSupportAsyncAPI()) {
                    this.setCallback(iMediaCodecCallback);
                }
                this.mMediaCodec.configure(this.mFormat, null, null, n3);
            }
            return this.mMediaCodec != null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 0, "init exception", exception);
            }
            return false;
        }
    }

    public void setParameters(Bundle bundle) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        AndroidCodec androidCodec = androidCodec.mMediaCodec;
        if (androidCodec == null) {
            return;
        }
        try {
            androidCodec.setParameters(bundle);
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
    }

    public static class InputBufferData {
        public ByteBuffer buffer;
        public int index;
        public boolean processing = false;

        public InputBufferData(ByteBuffer byteBuffer, int n2) {
            this.buffer = byteBuffer;
            this.index = n2;
        }
    }

    public class BufferData {
        public ByteBuffer buffer;
        public MediaFormat format;
        public int index;
        public MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        public boolean success = true;
    }
}

