package com.tencent.wecast.utils;

import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;

public class ImageUtil {
    private ImageUtil() {

    }

    /**
     * 网络图片加载返回结果监听
     */
    public interface OnNetWorkImageLoadedListener {
        boolean onSucceed(Drawable resource);//返回值表示是否拦截图片加载到ImageView

        void onFailed(String errorMsg);
    }

    /**
     * 加载网络图片到ImageView
     *
     * @param view           ImageView
     * @param srcValue       图片url
     * @param isGif          是否是Gif
     * @param loadedListener 网络图片加载返回结果监听
     */
    public static void loadNetWorkImage2view(final ImageView view, String srcValue, boolean isGif
            , @Nullable final OnNetWorkImageLoadedListener loadedListener) {
        RequestManager loadImageManager = Glide.with(view);
        if (isGif) {
            loadImageManager
                    .asGif()
                    .load(srcValue)
                    .diskCacheStrategy(DiskCacheStrategy.RESOURCE)
                    .skipMemoryCache(false)
                    .listener(new RequestListener<GifDrawable>() {
                        @Override
                        public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<GifDrawable> target, boolean isFirstResource) {
                            if (loadedListener != null) {
                                loadedListener.onFailed(e != null ? e.getMessage() : "null");
                            }
                            return false;
                        }

                        @Override
                        public boolean onResourceReady(GifDrawable resource, Object model, Target<GifDrawable> target, DataSource dataSource, boolean isFirstResource) {
                            if (loadedListener != null) {
                                return loadedListener.onSucceed(resource);
                            }
                            return false;
                        }
                    }).into(view);
        } else {
            loadImageManager
                    .load(srcValue)
                    .dontAnimate()
                    .skipMemoryCache(false)
                    .listener(new RequestListener<Drawable>() {
                        @Override
                        public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                            if (loadedListener != null) {
                                loadedListener.onFailed(e != null ? e.getMessage() : "null");
                            }
                            return false;
                        }

                        @Override
                        public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                            if (loadedListener != null) {
                                return loadedListener.onSucceed(resource);
                            }
                            return false;
                        }
                    }).into(view);
        }
    }
}
