package com.tencent.wecast.jni;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;

import com.tencent.wecast.jni.JniHelper.OnCppCall;

import java.util.HashMap;

class CCallJavaMgr {
    private final static String TAG = "CCallJavaMgr";

    private static final Handler mainHandler = new Handler(Looper.getMainLooper());

    private static class CppCallMgr {
        // 提供给c++调用的java通用接口
        private HashMap<String, OnCppCall> cppCallMap = new HashMap<>();

        static CppCallMgr create() {
            return new CppCallMgr();
        }

        void add(String jFuncName, OnCppCall caller) {
            if (cppCallMap.containsKey(jFuncName)) return;
            cppCallMap.put(jFuncName, caller);
        }

        void remove(String jFuncName) {
            cppCallMap.remove(jFuncName);
        }
    }

    private static CppCallMgr cppCallMgr = CppCallMgr.create();

    static void add(String jFuncName, OnCppCall caller) {
        cppCallMgr.add(jFuncName, caller);
    }

    static void remove(String jFuncName) {
        cppCallMgr.remove(jFuncName);
    }

    // 提供给native层调用的统一入口
    private static byte[] call(String jFuncName, byte[] params) {
        try {
            if (cppCallMgr.cppCallMap.containsKey(jFuncName)) {
                final OnCppCall onCppCall = cppCallMgr.cppCallMap.get(jFuncName);
                final ParamsPackage.ParamsFromCpp paramsFromCpp = ParamsPackage.fromBytes(params);
                if (onCppCall.isOnUIThread()) {
                    mainHandler.post(new Runnable() {
                        @Override
                        public void run() {
                            onCppCall.handle(paramsFromCpp);
                        }
                    });
                } else {
                    ParamsPackage.ParamsToCpp ret = onCppCall.handle(paramsFromCpp);
                    return ret != null ? ret.build() : ParamsPackage.voidPkg();
                }
            } else {
                Log.w(TAG, "need add [" + jFuncName + "] cppCall function.");
            }
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return ParamsPackage.voidPkg();
    }
}
