/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.content.Context;
import android.opengl.GLES10;
import android.opengl.GLES20;
import android.opengl.GLU;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.tencent.xcast.EGLCore;
import com.tencent.xcast.EGLCoreContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EGLUtil {
    private static final String TAG = "EGLUtil";
    private static final Pattern VERSION_PATTERN = Pattern.compile("([0-9]+)(\\.([0-9]+))?(\\.([0-9]+))?");
    private static EGLCoreContext sOffscreenContext = null;
    private static int sGLVersion = -1;
    private static String sEGLExtensions = null;
    private static String sGLESVendor = null;
    private static String sGLESRender = null;
    private static String sGLESExtensions = null;
    static final List<DeviceMatcher> sMatchers = new ArrayList<DeviceMatcher>(){
        {
            this.add(new DeviceMatcher(){

                @Override
                public boolean isMismatch(JSONObject jSONObject) {
                    return EGLUtil.isPropertyMismatch(jSONObject, "gl_vendor", sGLESVendor);
                }
            });
            this.add(new DeviceMatcher(){

                @Override
                public boolean isMismatch(JSONObject jSONObject) {
                    return EGLUtil.isPropertyMismatch(jSONObject, "gl_renderer", sGLESRender);
                }
            });
            this.add(new DeviceMatcher(){

                @Override
                public boolean isMismatch(JSONObject jSONObject) {
                    if (jSONObject.has("os")) {
                        JSONObject jSONObject2 = jSONObject.getJSONObject("os");
                        if (jSONObject2.has("type") && !"android".equals(jSONObject2.getString("type"))) {
                            return true;
                        }
                        if (jSONObject2.has("version")) {
                            return (jSONObject2 = jSONObject2.getJSONObject("version")).has("op") && jSONObject2.has("value") && EGLUtil.isVersionMismatch(jSONObject2.getString("op"), jSONObject2.getString("value"));
                        }
                    }
                    return false;
                }
            });
            this.add(new DeviceMatcher(){

                @Override
                public boolean isMismatch(JSONObject jSONObject) {
                    if (jSONObject.has("codec_name")) {
                        String string = jSONObject.getString("codec_name");
                        Pattern pattern = Pattern.compile(string);
                        sCodecPatterns.add(pattern);
                        sCodecFeatures.add(new FeatureHolder().fromJSONObject(jSONObject));
                        return true;
                    }
                    return false;
                }
            });
            this.add(new DeviceMatcher(){

                @Override
                public boolean isMismatch(JSONObject jSONObject) {
                    return EGLUtil.isPropertyMismatch(jSONObject, "vendor_name", Build.MANUFACTURER);
                }
            });
            this.add(new DeviceMatcher(){

                @Override
                public boolean isMismatch(JSONObject jSONObject) {
                    return EGLUtil.isPropertyMismatch(jSONObject, "device_name", Build.MODEL);
                }
            });
        }
    };
    static final Map<String, FeatureSetter> sHolderSetters = new HashMap<String, FeatureSetter>(){
        {
            this.put("use_android_hardware_buffer", new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mUseHardwareBuffer = true;
                }
            });
            this.put("disable_android_pbo", new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mUsePBO = false;
                }
            });
            this.put("enable_android_system_decoder", new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mUseSystemDecoder = true;
                }
            });
            this.put("enable_android_system_encoder", new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mUseSystemEncoder = true;
                }
            });
            this.put("disable_android_system_decoder", new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mUseSystemDecoder = false;
                }
            });
            this.put("disable_android_system_encoder", new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mUseSystemEncoder = false;
                }
            });
            this.put("enable_android_decoder_surfacetexture", new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mDecoderOutputSurfaceTexture = true;
                }
            });
            this.put("disable_android_decoder_surfacetexture", new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mDecoderOutputSurfaceTexture = false;
                }
            });
            this.put("enable_android_encoder_surfacetexture", new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mEncoderIntputSurfaceTexture = true;
                }
            });
            this.put("disable_android_encoder_surfacetexture", new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mEncoderIntputSurfaceTexture = false;
                }
            });
            this.put("min_format_size", new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mMinFormatSize = jSONObject.getInt("min_format_size");
                }
            });
            this.put("max_pending_frames", new FeatureSetter(){

                @Override
                public void set(FeatureHolder featureHolder, JSONObject jSONObject) {
                    featureHolder.mMaxPendingFrames = jSONObject.getInt("max_pending_frames");
                }
            });
        }
    };
    static final FeatureHolder sFeatures = new FeatureHolder();
    static final List<Pattern> sCodecPatterns = new ArrayList<Pattern>();
    static final List<FeatureHolder> sCodecFeatures = new ArrayList<FeatureHolder>();

    public static synchronized EGLCoreContext getOffscreenContext() {
        if (sOffscreenContext == null) {
            EGLCore eGLCore = new EGLCore();
            if (!eGLCore.createContext(null, true)) {
                return null;
            }
            if (!eGLCore.createSurface(null)) {
                eGLCore.release();
                return null;
            }
            sOffscreenContext = eGLCore;
            sEGLExtensions = eGLCore.eglQueryString(12373);
            sGLESVendor = GLES20.glGetString((int)7936);
            sGLESRender = GLES20.glGetString((int)7937);
            String string = GLES20.glGetString((int)7938);
            sGLESExtensions = GLES20.glGetString((int)7939);
            Log.d((String)TAG, (String)String.format("EGL_EXTENSIONS.%s", sEGLExtensions));
            Log.d((String)TAG, (String)String.format("GL_VENDOR.%s.\nGL_RENDERER.%s.\nGL_VERSION.%s.\nGL_EXTENSIONS.%s", sGLESVendor, sGLESRender, string, sGLESExtensions));
        }
        return sOffscreenContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadGPUFeatureListFromAsset(Context context) {
        InputStream inputStream = null;
        try {
            inputStream = context.getAssets().open("hardware_bug_workaround.json");
            int n2 = inputStream.available();
            byte[] byArray = new byte[n2];
            if (inputStream.read(byArray) != n2) {
                return;
            }
            String string = new String(byArray);
            try {
                JSONObject jSONObject = new JSONObject(string);
                EGLUtil.loadGPUFeatureListImpl(jSONObject);
            }
            catch (JSONException jSONException) {
                Log.e((String)TAG, (String)("parse.json.failed." + jSONException.toString()));
            }
        }
        catch (IOException iOException) {
            Log.i((String)TAG, (String)("load.json.failed." + iOException.toString()));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Log.i((String)TAG, (String)iOException.toString());
                }
            }
        }
    }

    private static boolean isPropertyMismatch(JSONObject jSONObject, String string, String string2) {
        if (string2 == null) {
            return true;
        }
        if (!jSONObject.has(string)) {
            return false;
        }
        Pattern pattern = Pattern.compile(jSONObject.getString(string));
        Matcher matcher = pattern.matcher(string2);
        return !matcher.find();
    }

    private static int androidVersionToApiLevel(String string) {
        if (string == null || string.length() == 0) {
            return 15;
        }
        Matcher matcher = VERSION_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return 15;
        }
        int n2 = Integer.parseInt(matcher.group(1));
        int n3 = 0;
        String string2 = matcher.group(3);
        if (string2 != null) {
            n3 = Integer.parseInt(string2);
        }
        switch (n2) {
            case 9: {
                return 28;
            }
            case 8: {
                return n3 >= 1 ? 27 : 26;
            }
            case 7: {
                return n3 >= 1 ? 25 : 24;
            }
            case 6: {
                return 23;
            }
            case 5: {
                return n3 >= 1 ? 22 : 21;
            }
            case 4: {
                switch (n3) {
                    case 4: {
                        return 19;
                    }
                    case 3: {
                        return 18;
                    }
                    case 2: {
                        return 17;
                    }
                    case 1: {
                        return 16;
                    }
                    case 0: {
                        return 15;
                    }
                }
            }
        }
        return 15;
    }

    private static boolean isVersionMismatch(String string, String string2) {
        int n2 = EGLUtil.androidVersionToApiLevel(string2);
        if (string == null || string2 == null) {
            return false;
        }
        switch (string) {
            case ">": {
                return Build.VERSION.SDK_INT <= n2;
            }
            case ">=": {
                return Build.VERSION.SDK_INT < n2;
            }
            case "<": {
                return Build.VERSION.SDK_INT >= n2;
            }
            case "<=": {
                return Build.VERSION.SDK_INT > n2;
            }
            case "==": {
                return Build.VERSION.SDK_INT != n2;
            }
            case "!=": {
                return Build.VERSION.SDK_INT == n2;
            }
        }
        return false;
    }

    private static void loadGPUFeatureListImpl(JSONObject jSONObject) {
        EGLUtil.getOffscreenContext();
        long l2 = System.currentTimeMillis();
        try {
            JSONArray jSONArray = jSONObject.getJSONArray("entries");
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                boolean bl = false;
                for (DeviceMatcher deviceMatcher : sMatchers) {
                    if (!deviceMatcher.isMismatch(jSONObject2)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                sFeatures.fromJSONObject(jSONObject2);
            }
        }
        catch (PatternSyntaxException | JSONException throwable) {
            Log.e((String)TAG, (String)throwable.toString());
        }
        Log.i((String)TAG, (String)String.format(Locale.CHINA, "loadGPUFeatureListImpl.json.parser.%dms", System.currentTimeMillis() - l2));
    }

    @Nullable
    private static FeatureHolder getCodecFeatures(@Nullable String string) {
        if (sCodecPatterns.size() != sCodecFeatures.size()) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        for (int i2 = sCodecPatterns.size() - 1; i2 >= 0; --i2) {
            Matcher matcher = sCodecPatterns.get(i2).matcher(string);
            if (!matcher.find()) continue;
            return sCodecFeatures.get(i2);
        }
        return null;
    }

    public static boolean isSystemDecoderAvailable(@Nullable String string) {
        if (EGLUtil.sFeatures.mUseSystemDecoder) {
            return true;
        }
        FeatureHolder featureHolder = EGLUtil.getCodecFeatures(string);
        return featureHolder != null && featureHolder.mUseSystemDecoder;
    }

    public static boolean isSystemEncoderAvailable(@Nullable String string) {
        if (EGLUtil.sFeatures.mUseSystemEncoder) {
            return true;
        }
        FeatureHolder featureHolder = EGLUtil.getCodecFeatures(string);
        return featureHolder != null && featureHolder.mUseSystemEncoder;
    }

    public static boolean isDecoderSurfaceTextureAvailable(@Nullable String string) {
        if (EGLUtil.sFeatures.mDecoderOutputSurfaceTexture) {
            return true;
        }
        FeatureHolder featureHolder = EGLUtil.getCodecFeatures(string);
        return featureHolder != null && featureHolder.mDecoderOutputSurfaceTexture;
    }

    public static boolean isEncoderSurfaceTextureAvailable(@Nullable String string) {
        if (EGLUtil.sFeatures.mEncoderIntputSurfaceTexture) {
            return true;
        }
        FeatureHolder featureHolder = EGLUtil.getCodecFeatures(string);
        return featureHolder != null && featureHolder.mEncoderIntputSurfaceTexture;
    }

    public static int getCodecMinFormatSize(@Nullable String string) {
        FeatureHolder featureHolder = EGLUtil.getCodecFeatures(string);
        featureHolder = featureHolder != null ? featureHolder : sFeatures;
        return featureHolder.mMinFormatSize;
    }

    public static int getCodecMaxPendingFrames(@Nullable String string) {
        FeatureHolder featureHolder = EGLUtil.getCodecFeatures(string);
        featureHolder = featureHolder != null ? featureHolder : sFeatures;
        return featureHolder.mMaxPendingFrames;
    }

    public static boolean isVAOAvailable() {
        return EGLUtil.getGLMajorVersion() >= 3 || EGLUtil.hasGLESExtension("GL_OES_vertex_array_object");
    }

    public static boolean isPBOAvailable() {
        return EGLUtil.sFeatures.mUsePBO && EGLUtil.getGLMajorVersion() >= 3;
    }

    public static boolean isHardwareBufferExtensionAvailable() {
        return EGLUtil.sFeatures.mUseHardwareBuffer && EGLUtil.hasEGLExtension("EGL_KHR_image_base") && (Build.VERSION.SDK_INT < 26 || EGLUtil.hasEGLExtension("EGL_ANDROID_get_native_client_buffer"));
    }

    public static boolean hasEGLExtension(String string) {
        if (sEGLExtensions == null) {
            EGLUtil.getOffscreenContext();
        }
        return sEGLExtensions != null && sEGLExtensions.contains(string);
    }

    public static boolean hasGLESExtension(String string) {
        if (sGLESExtensions == null) {
            EGLUtil.getOffscreenContext();
        }
        return sGLESExtensions != null && sGLESExtensions.contains(string);
    }

    public static int getGLMajorVersion() {
        return EGLUtil.getGLVersion() >> 16 & 0xFFFF;
    }

    public static int getGLMinorVersion() {
        return EGLUtil.getGLVersion() & 0xFFFF;
    }

    public static synchronized int getGLVersion() {
        if (sGLVersion <= 0) {
            sGLVersion = 131072;
            long l2 = System.currentTimeMillis();
            EGLCore eGLCore = new EGLCore(2);
            if (eGLCore.createContext(null, false) && eGLCore.createSurface(null)) {
                String string = GLES10.glGetString((int)7938);
                Log.i((String)TAG, (String)String.format("glVersion.versionString.%s", string));
                Pattern pattern = Pattern.compile("OpenGL\\s?(ES)?\\s?([0-9]+)(\\.([0-9]+))?.*");
                Matcher matcher = pattern.matcher(string);
                if (matcher.matches()) {
                    sGLVersion = Integer.parseInt(matcher.group(2)) << 16;
                    String string2 = matcher.group(4);
                    if (string2 != null) {
                        sGLVersion |= Integer.parseInt(string2);
                    }
                }
            }
            eGLCore.release();
            Log.i((String)TAG, (String)String.format(Locale.CHINA, "glVersion.version.%d.time.%dms", sGLVersion, System.currentTimeMillis() - l2));
        }
        return sGLVersion;
    }

    @NonNull
    public static String checkGlError(String string) {
        int n2 = GLES20.glGetError();
        if (n2 != 0) {
            return String.format(Locale.CHINA, "%s: glError %s(0x%X)", string, GLU.gluErrorString((int)n2), n2);
        }
        return "";
    }

    @NonNull
    public static String checkEglError(EGLCoreContext eGLCoreContext) {
        int n2 = eGLCoreContext.eglGetError();
        if (n2 != 12288) {
            return EGLUtil.getEglErrorString(n2);
        }
        return "";
    }

    @NonNull
    public static String getEglErrorString(int n2) {
        String string;
        switch (n2) {
            case 12288: {
                string = "EGL_SUCCESS";
                break;
            }
            case 12289: {
                string = "EGL_NOT_INITIALIZED";
                break;
            }
            case 12290: {
                string = "EGL_BAD_ACCESS";
                break;
            }
            case 12291: {
                string = "EGL_BAD_ALLOC";
                break;
            }
            case 12292: {
                string = "EGL_BAD_ATTRIBUTE";
                break;
            }
            case 12294: {
                string = "EGL_BAD_CONTEXT";
                break;
            }
            case 12293: {
                string = "EGL_BAD_CONFIG";
                break;
            }
            case 12295: {
                string = "EGL_BAD_CURRENT_SURFACE";
                break;
            }
            case 12296: {
                string = "EGL_BAD_DISPLAY";
                break;
            }
            case 12301: {
                string = "EGL_BAD_SURFACE";
                break;
            }
            case 12297: {
                string = "EGL_BAD_MATCH";
                break;
            }
            case 12300: {
                string = "EGL_BAD_PARAMETER";
                break;
            }
            case 12298: {
                string = "EGL_BAD_NATIVE_PIXMAP";
                break;
            }
            case 12299: {
                string = "EGL_BAD_NATIVE_WINDOW";
                break;
            }
            case 12302: {
                string = "EGL_CONTEXT_LOST";
                break;
            }
            default: {
                string = String.format(Locale.CHINA, "%d", n2);
            }
        }
        return string;
    }

    private static final class FeatureHolder {
        boolean mUseHardwareBuffer = false;
        boolean mUsePBO = true;
        boolean mUseSystemDecoder = false;
        boolean mUseSystemEncoder = false;
        boolean mDecoderOutputSurfaceTexture = false;
        boolean mEncoderIntputSurfaceTexture = false;
        int mMaxPendingFrames = 4;
        int mMinFormatSize = 16;

        private FeatureHolder() {
        }

        FeatureHolder fromJSONObject(JSONObject jSONObject) {
            FeatureSetter featureSetter;
            String string;
            JSONArray jSONArray;
            if (jSONObject.has("features")) {
                jSONArray = jSONObject.getJSONArray("features");
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    string = jSONArray.getString(i2);
                    if (!sHolderSetters.containsKey(string)) continue;
                    featureSetter = sHolderSetters.get(string);
                    featureSetter.set(this, jSONObject);
                }
            }
            if (jSONObject.has("default_parameters")) {
                jSONArray = jSONObject.getJSONObject("default_parameters");
                Iterator iterator = jSONArray.keys();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (!sHolderSetters.containsKey(string)) continue;
                    featureSetter = sHolderSetters.get(string);
                    featureSetter.set(this, (JSONObject)jSONArray);
                }
            }
            return this;
        }
    }

    private static interface FeatureSetter {
        public void set(FeatureHolder var1, JSONObject var2);
    }

    private static interface DeviceMatcher {
        public boolean isMismatch(JSONObject var1);
    }
}

