/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xcast;

import android.annotation.TargetApi;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.os.Build;
import android.support.annotation.RequiresApi;
import com.tencent.avlab.sdk.Platform;
import com.tencent.xcast.EGLCore;
import com.tencent.xcast.EGLCore10;
import com.tencent.xcast.EGLCoreContext;
import com.tencent.xcast.RefCountDelegate;
import java.util.Locale;

@RequiresApi(value=17)
class EGLCore14
extends RefCountDelegate
implements EGLCoreContext {
    private static final boolean isAndroidPresentationTimeAvailable = Build.VERSION.SDK_INT >= 18;
    private EGLDisplay mEGLDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLSurface mEGLSurface = EGL14.EGL_NO_SURFACE;
    private EGLContext mEGLContext = EGL14.EGL_NO_CONTEXT;
    private EGLConfig mEGLConfig = null;
    private boolean mIsOffscreen = false;

    EGLCore14(int n2) {
        EGLCore10.CONTEXT_ATTR[1] = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createContext(EGLCoreContext eGLCoreContext, boolean bl) {
        if (eGLCoreContext != null && !(eGLCoreContext instanceof EGLCore14)) {
            Platform.logError("create.shared.context.type.error");
            return false;
        }
        this.mEGLDisplay = EGL14.eglGetDisplay((int)0);
        int[] nArray = new int[2];
        EGL14.eglInitialize((EGLDisplay)this.mEGLDisplay, (int[])nArray, (int)0, (int[])nArray, (int)1);
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray2 = new int[1];
        if (!EGL14.eglChooseConfig((EGLDisplay)this.mEGLDisplay, (int[])(bl ? EGLCore10.CONFIG_RGBA : EGLCore10.CONFIG_RGB), (int)0, (EGLConfig[])eGLConfigArray, (int)0, (int)eGLConfigArray.length, (int[])nArray2, (int)0) || nArray2[0] == 0) {
            Platform.logError("no.config.found");
            return false;
        }
        this.mEGLConfig = eGLConfigArray[0];
        EGLContext eGLContext = eGLCoreContext != null ? ((EGLCore14)eGLCoreContext).mEGLContext : EGL14.EGL_NO_CONTEXT;
        Object object = EGLCore.sLock;
        synchronized (object) {
            this.mEGLContext = EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (EGLContext)eGLContext, (int[])EGLCore10.CONTEXT_ATTR, (int)0);
        }
        if (EGLCore.LOG_EGL) {
            Platform.logInfo(String.format(Locale.CHINA, "%h.createContext.ctx.%h.tid.%d", this, this.mEGLContext, Thread.currentThread().getId()));
        }
        return this.hasContext();
    }

    @Override
    public void destroyContext() {
        if (EGLCore.LOG_EGL) {
            Platform.logInfo(String.format(Locale.CHINA, "%h.destroyContext.ctx.%h.tid.%d", this, this.mEGLContext, Thread.currentThread().getId()));
        }
        if (this.hasContext()) {
            EGL14.eglDestroyContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext);
            EGL14.eglReleaseThread();
            this.mEGLContext = EGL14.EGL_NO_CONTEXT;
        }
        if (!this.mEGLDisplay.equals((Object)EGL14.EGL_NO_DISPLAY)) {
            EGL14.eglTerminate((EGLDisplay)this.mEGLDisplay);
            this.mEGLDisplay = EGL14.EGL_NO_DISPLAY;
        }
        this.mEGLConfig = null;
    }

    @Override
    public boolean createSurface(Object object) {
        if (!this.hasContext()) {
            Platform.logError("mEGLContext.not.initialized");
            return false;
        }
        this.destroySurface();
        if (object != null) {
            try {
                int[] nArray = new int[]{12344};
                this.mEGLSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (Object)object, (int[])nArray, (int)0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Platform.logError(String.format(Locale.CHINA, "%h.eglCreateWindowSurface.%s", this, illegalArgumentException.toString()));
                return false;
            }
            this.mIsOffscreen = false;
        } else {
            int[] nArray = new int[]{12375, 1, 12374, 1, 12376, 1, 12344};
            this.mEGLSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (int[])nArray, (int)0);
            this.mIsOffscreen = true;
        }
        if (EGLCore.LOG_EGL) {
            Platform.logInfo(String.format(Locale.CHINA, "%h.createSurface.ctx.%h.sf.%h.tid.%d", this, this.mEGLContext, this.mEGLSurface, Thread.currentThread().getId()));
        }
        if (this.hasSurface() && this.makeCurrent() == 12288) {
            EGL14.eglSwapInterval((EGLDisplay)this.mEGLDisplay, (int)1);
        }
        return true;
    }

    @Override
    public void destroySurface() {
        if (EGLCore.LOG_EGL) {
            Platform.logInfo(String.format(Locale.CHINA, "%h.destroySurface.ctx.%h.sf.%h.tid.%d", this, this.mEGLContext, this.mEGLSurface, Thread.currentThread().getId()));
        }
        if (this.hasSurface()) {
            this.detachCurrent();
            EGL14.eglDestroySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface);
            this.mEGLSurface = EGL14.EGL_NO_SURFACE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int makeCurrent() {
        Object object = EGLCore.sLock;
        synchronized (object) {
            return EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface, (EGLSurface)this.mEGLSurface, (EGLContext)this.mEGLContext) ? 12288 : EGL14.eglGetError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachCurrent() {
        Object object = EGLCore.sLock;
        synchronized (object) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
        }
    }

    @Override
    public boolean isCurrentContext() {
        return this.mEGLContext.equals((Object)EGL14.eglGetCurrentContext()) && this.mEGLSurface.equals((Object)EGL14.eglGetCurrentSurface((int)12377));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int swapBuffers() {
        Object object = EGLCore.sLock;
        synchronized (object) {
            return this.mIsOffscreen || EGL14.eglSwapBuffers((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface) ? 12288 : EGL14.eglGetError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetApi(value=18)
    public int swapBuffers(long l2) {
        if (isAndroidPresentationTimeAvailable) {
            Object object = EGLCore.sLock;
            synchronized (object) {
                EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface, (long)l2);
            }
        }
        return this.swapBuffers();
    }

    @Override
    public boolean hasContext() {
        return !this.mEGLContext.equals((Object)EGL14.EGL_NO_CONTEXT);
    }

    @Override
    public boolean hasSurface() {
        return !this.mEGLSurface.equals((Object)EGL14.EGL_NO_SURFACE);
    }

    @Override
    public String eglQueryString(int n2) {
        return EGL14.eglQueryString((EGLDisplay)this.mEGLDisplay, (int)n2);
    }

    @Override
    public int eglGetError() {
        return EGL14.eglGetError();
    }

    @Override
    public int release() {
        int n2 = super.release();
        if (n2 == 0) {
            this.destroySurface();
            this.destroyContext();
        }
        return n2;
    }
}

