/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sharp.jni;

public class RingBuffer {
    private final int DEFAULT_SIZE = 1000;
    public int c_totalSize = 1000;
    public byte[] m_pBuf;
    public int m_read = 0;
    public int m_write = 0;
    public boolean m_isEmpty = true;

    public RingBuffer() {
        this.m_pBuf = null;
        this.c_totalSize = 1000;
        this.m_isEmpty = true;
        this.m_read = 0;
        this.m_write = 0;
        this.m_pBuf = new byte[this.c_totalSize];
    }

    public RingBuffer(int n2) {
        this.c_totalSize = n2;
        this.m_isEmpty = true;
        this.m_read = 0;
        this.m_write = 0;
        this.m_pBuf = new byte[this.c_totalSize];
    }

    public void Push(byte[] byArray, int n2) {
        if (this.m_pBuf == null) {
            return;
        }
        if (this.RemainWrite() < n2) {
            return;
        }
        if (this.c_totalSize - this.m_write >= n2) {
            System.arraycopy(byArray, 0, this.m_pBuf, this.m_write, n2);
        } else {
            System.arraycopy(byArray, 0, this.m_pBuf, this.m_write, this.c_totalSize - this.m_write);
            System.arraycopy(byArray, this.c_totalSize - this.m_write, this.m_pBuf, 0, n2 - (this.c_totalSize - this.m_write));
        }
        this.m_write = (this.m_write + n2) % this.c_totalSize;
        this.m_isEmpty = false;
    }

    public int RemainRead() {
        if (this.m_write < this.m_read) {
            return this.c_totalSize - this.m_read + this.m_write;
        }
        if (this.m_write > this.m_read) {
            return this.m_write - this.m_read;
        }
        return this.m_isEmpty ? 0 : this.c_totalSize;
    }

    public int RemainWrite() {
        return this.c_totalSize - this.RemainRead();
    }

    public void Clear() {
        this.m_read = this.m_write = 0;
        this.m_isEmpty = true;
    }

    public boolean Pop(byte[] byArray, int n2) {
        if (this.m_pBuf == null) {
            return false;
        }
        if (this.RemainRead() < n2 || n2 <= 0) {
            return false;
        }
        if (this.c_totalSize - this.m_read >= n2) {
            System.arraycopy(this.m_pBuf, this.m_read, byArray, 0, n2);
        } else {
            System.arraycopy(this.m_pBuf, this.m_read, byArray, 0, this.c_totalSize - this.m_read);
            System.arraycopy(this.m_pBuf, 0, byArray, this.c_totalSize - this.m_read, n2 - (this.c_totalSize - this.m_read));
        }
        this.m_read = (this.m_read + n2) % this.c_totalSize;
        this.m_isEmpty = this.m_read == this.m_write;
        return true;
    }
}

