package com.tencent.wecast.sender.cloud.widget

import android.content.Context
import android.graphics.Color
import android.util.AttributeSet
import android.view.View
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import com.tencent.wecast.WeCastConfigManager
import com.tencent.wecast.sender.cloud.R
import com.tencent.wecast.sender.cloud.config.SenderCompileConfig
import com.tencent.wecast.utils.Logger


class WeCastAlert @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null) : LinearLayout(context, attrs) {

    class WeCastAlertInfo {

        constructor()

        constructor(type: Int, text: String) {
            this.type = type
            this.text = text
        }

        var type: Int = 0
        var text: String = ""
    }

    companion object {

        private val TAG = "WeCastAlert"

    }

    private val mAlertInfoMap: MutableMap<Int, WeCastAlertInfo> = mutableMapOf<Int, WeCastAlertInfo>()

    private var mIvIcon: ImageView? = null
    private var mTvText: TextView? = null

    private var mAutoShowHideFlag = true

    init {
        if (WeCastConfigManager.getInstance().isLanScheme) {
            View.inflate(context, R.layout.wecast_alert_1, this)
        } else {
            View.inflate(context, R.layout.wecast_alert_2, this)
        }
        mIvIcon = findViewById(R.id.iv_alert_icon)
        mTvText = findViewById(R.id.tv_alert_text)

        updateAlert()
    }

    fun addAlert(alertInfo: WeCastAlertInfo) {
        mAlertInfoMap.put(alertInfo.type, alertInfo)
        updateAlert()
    }

    fun removeAlert(alertType: Int) {
        mAlertInfoMap.remove(alertType)
        updateAlert()
    }

    fun hasAlert(): Boolean {
        return mAlertInfoMap.isNotEmpty()
    }


    private fun updateAlert() {
        /**
         * 无有显示内容，自动隐藏
         */
        if (mAutoShowHideFlag) {
            visibility = if (hasAlert()) View.VISIBLE else View.GONE
        }


        /**
         * 根据id的优先级显示 alert
         */
        val maxAlert = mAlertInfoMap.maxBy { it -> it.key }
        if (maxAlert == null) {
            mIvIcon?.visibility = View.GONE
            mTvText?.visibility = View.GONE
            mTvText?.text = ""
        } else {
            val alertInfo = maxAlert.value
            mIvIcon?.visibility = View.VISIBLE
            mTvText?.visibility = View.VISIBLE
            mTvText?.text = alertInfo.text
        }
    }
}