package com.tencent.wecast.sender.cloud.utils

import android.content.Context
import android.content.Intent
import android.provider.Settings
import com.tencent.wecast.sender.cloud.R
import com.tencent.wecast.utils.Logger


object SettingUtils {

    val TAG = "SettingUtils"


    class ScreenOutSettingInfo {
        companion object {
            const val INTENT_TYPE_NONE = 0
            const val INTENT_TYPE_SETTING = 1
            const val INTENT_TYPE_EXPLICIT = 2
        }

        var intentType: Int = INTENT_TYPE_NONE
        var intent: Intent? = null
        var message: String = ""
    }

    fun getScreenOutSettingInfo(context: Context): ScreenOutSettingInfo {
        val info = ScreenOutSettingInfo()

        when {
            RomUtils.isEmui -> {
                /** 华为 **/
                info.intentType = ScreenOutSettingInfo.INTENT_TYPE_EXPLICIT
                info.intent = Intent(Settings.ACTION_DISPLAY_SETTINGS)
                info.message = context.getString(R.string.wecast_base_screen_out_huawei)
            }
            RomUtils.isVivo -> {
                /** VIVO **/
                info.intentType = ScreenOutSettingInfo.INTENT_TYPE_SETTING
                info.intent = Intent(Settings.ACTION_SETTINGS)
                info.message = context.getString(R.string.wecast_base_screen_out_vivo)
            }
            RomUtils.isOppo -> {
                /** OPPO **/
                info.intentType = ScreenOutSettingInfo.INTENT_TYPE_EXPLICIT
                info.intent = Intent(Settings.ACTION_DISPLAY_SETTINGS)
                info.message = context.getString(R.string.wecast_base_screen_out_oppo)
            }
            RomUtils.isMiui -> {
                /** 小米 **/
                info.intentType = ScreenOutSettingInfo.INTENT_TYPE_SETTING
                info.intent = Intent(Settings.ACTION_SETTINGS)
                info.message = context.getString(R.string.wecast_base_screen_out_xiaomi)
            }
            RomUtils.isSamsung -> {
                /** 三星 **/
                info.intentType = ScreenOutSettingInfo.INTENT_TYPE_EXPLICIT
                info.intent = Intent(Settings.ACTION_DISPLAY_SETTINGS)
                info.message = context.getString(R.string.wecast_base_screen_out_samsung)
            }
            RomUtils.isFlyme -> {
                /** 魅族 **/
                info.intentType = ScreenOutSettingInfo.INTENT_TYPE_EXPLICIT
                info.intent = Intent(Settings.ACTION_DISPLAY_SETTINGS)
                info.message = context.getString(R.string.wecast_base_screen_out_meizu)
            }
            RomUtils.isGionee -> {
                /** 金立 **/
                info.intentType = ScreenOutSettingInfo.INTENT_TYPE_EXPLICIT
                info.intent = Intent(Settings.ACTION_DISPLAY_SETTINGS)
                info.message = context.getString(R.string.wecast_base_screen_out_jinli)
            }
            else -> {
                /** 默认 **/
                info.intentType = ScreenOutSettingInfo.INTENT_TYPE_SETTING
                info.intent = Intent(Settings.ACTION_SETTINGS)
                info.message = context.getString(R.string.wecast_base_screen_out_default)
            }
        }

        try {
            if (info.intent == null) {
                info.intentType = ScreenOutSettingInfo.INTENT_TYPE_NONE
            } else {
                if (info.intentType == ScreenOutSettingInfo.INTENT_TYPE_EXPLICIT) {
                    /** 如果找不到具体的设置页面，降级为主设置页面  **/
                    if (info.intent!!.resolveActivity(context.packageManager) == null) {
                        info.intentType = ScreenOutSettingInfo.INTENT_TYPE_SETTING
                        info.intent = Intent(Settings.ACTION_SETTINGS)
                    }
                }

                if (info.intentType == ScreenOutSettingInfo.INTENT_TYPE_SETTING) {
                    /** 如果找不到主设置页面，降级为不跳转  **/
                    if (info.intent!!.resolveActivity(context.packageManager) == null) {
                        info.intentType = ScreenOutSettingInfo.INTENT_TYPE_NONE
                        info.intent = null
                    }
                }
            }
        } catch (e: Exception) {
            Logger.t(TAG).e("getScreenOutSettingInfo e = " + e)
        }

        Logger.t(TAG).d("getScreenOutSettingInfo intentType = %d | intent = %s | message = %s", info.intentType, info.intent, info.message)

        return info
    }
}
