package com.tencent.wecast.sender.cloud.activity

import android.app.Dialog
import android.os.Bundle
import android.os.Handler
import android.os.Looper
import android.os.Message
import android.support.v7.app.AppCompatActivity
import android.text.TextUtils
import android.view.MenuItem
import android.widget.TextView
import com.tencent.wecast.sender.cloud.utils.CommonUtils
import com.tencent.wecast.sender.cloud.R
import com.tencent.wecast.utils.Logger


open class BaseActivity : AppCompatActivity() {

    companion object {
        private val TAG = "BaseActivity"
    }

    /**
     * 构造一个主线程的Handler，用于投递消息
     */
    protected var mBaseHandler: Handler? = null

    protected var mLoadingDialog: Dialog? = null


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        supportActionBar?.setHomeButtonEnabled(true)
        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        mBaseHandler = object : Handler(Looper.getMainLooper()) {
            override fun handleMessage(msg: Message) {
                baseHandleMessage(msg)
            }
        }
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
            android.R.id.home -> {
                this.finish()
                return true
            }
        }
        return super.onOptionsItemSelected(item)
    }

    override fun onDestroy() {
        super.onDestroy()
        mLoadingDialog?.dismiss()
        mLoadingDialog = null

        mBaseHandler?.removeCallbacksAndMessages(null)
        mBaseHandler = null
    }


    /**
     * 界面公共部分
     */
    fun showLoading(text: String) {
        mLoadingDialog = CommonUtils.createLoadingDialog(this)

        val textView = mLoadingDialog?.findViewById(R.id.loading_dialog_text) as TextView?
        textView?.text = if (TextUtils.isEmpty(text)) "" else text
        mLoadingDialog?.show()
    }

    fun hideLoading() {
        mLoadingDialog?.dismiss()
        mLoadingDialog = null
    }

    /**
     * 子类重写此方法，进行MSG处理
     *
     * @param msg
     */
    fun baseHandleMessage(msg: Message) {

    }

    fun getConfValue(id: Int, defaultValue: Boolean): Boolean {
        return try {
            resources.getBoolean(id)
        } catch (e: Exception) {
            Logger.t(TAG).e("getConfValue e =" + e)
            defaultValue
        }
    }
}