package com.tencent.wecast.sender.cloud

import android.app.Activity
import com.tencent.wecast.WeCastConstant
import com.tencent.wecast.sender.cloud.bean.WeCastInfo
import com.tencent.wecast.sender.cloud.utils.CloudUtil
import com.tencent.wecast.sender.eb.SenderEvents
import com.tencent.wecast.utils.EventBusUtil
import com.tencent.wecast.utils.Logger
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode

object WeCast {

    private const val TAG = "WeCast"

    private var mOnWeCastRunListener: OnWeCastRunListener? = null

    public interface OnWeCastRunListener {
        fun onAuthCodeError()
    }

    fun run(activity: Activity, corpId: String, authCode: String, userName: String) {
        run(activity, corpId, authCode, userName, null)
    }

    fun run(activity: Activity, corpId: String, authCode: String, userName: String, onWeCastRunListener: OnWeCastRunListener?) {
        EventBusUtil.register(this)
        if (onWeCastRunListener != null) {
            this.mOnWeCastRunListener = onWeCastRunListener
        }
        WeCastInfo.instance.corpId = corpId
        if (!isRunning()) {
            WeCastInfo.instance.authCode = authCode
            CloudUtil.jump2WeCastPinPage(activity, WeCastInfo.instance.corpId,
                    WeCastInfo.instance.authCode, userName)
        } else {
            CloudUtil.jump2WeCastPage(activity)
        }
        WeCastInfo.instance.isRunning = true
    }

    fun stop() {
        EventBus.getDefault().post(SenderEvents.EStopCast())
        EventBusUtil.unregister(this)
    }

    fun isRunning(): Boolean {
        return WeCastInfo.instance.isRunning
    }

    fun isCasting(): Boolean {
        return WeCastInfo.instance.isCasting
    }

    fun version(): String {
        return WeCastConstant.WECAST_VERSION
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onAuthCodeError(event: SenderEvents.EAuthCodeError) {
        Logger.t(TAG).d("onAuthCodeError")
        mOnWeCastRunListener?.onAuthCodeError()
    }
}