package com.tencent.wecast.jni;

import android.content.Context;

import java.io.IOException;

public class JniHelper {
    private static Context appContext = null;

    static {
        System.loadLibrary("wecast");       // libwecast.so -> wecast跨平台
        if (isUsingXCast()) {
            System.loadLibrary("xcast");    // libxcast.so -> xcast跨平台
        }
    }

    // 初始化Java-c++互调用模块
    public static void init(Context context) {
        appContext = context;
        JCallCppMgr.init(appContext);
    }

    // 获取Application Context
    public static Context getAppContext() {
        return appContext;
    }

    // java调用c++函数
    public static ParamsPackage.ParamsFromCpp
    callJniFunc(String funcName, ParamsPackage.ParamsToCpp paramsPkg) {
        return JCallCppMgr.callJniFunc(funcName, paramsPkg);
    }

    /**
     * java调用c++函数
     *
     * @param funcName 调用注册的c++函数名
     * @param args     支持类型boolean/byte/short/int/long/float/double/string
     */
    public static ParamsPackage.ParamsFromCpp callJniFunc(String funcName, Object... args) {
        try {
            ParamsPackage.ParamsToCpp params = null;
            params = new ParamsPackage.ParamsToCpp();
            for (Object arg : args) {
                if (arg instanceof Boolean) {
                    params.addBool((boolean) arg);
                } else if (arg instanceof Byte) {
                    params.addByte((byte) arg);
                } else if (arg instanceof Short) {
                    params.addShort((short) arg);
                } else if (arg instanceof Integer) {
                    params.addInt((int) arg);
                } else if (arg instanceof Long) {
                    params.addLong((long) arg);
                } else if (arg instanceof Float) {
                    params.addFloat((float) arg);
                } else if (arg instanceof Double) {
                    params.addDouble((double) arg);
                } else if (arg instanceof String) {
                    params.addString((String) arg);
                }
            }
            return callJniFunc(funcName, params);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    // 注册java函数给c++使用
    public static void registerFunc4Cpp(String jFuncName, OnCppCall caller) {
        CCallJavaMgr.add(jFuncName, caller);
    }

    // 反注册java函数（停止提供给c++使用）
    public static void unregister(String jFuncName) {
        CCallJavaMgr.remove(jFuncName);
    }

    // C++调用Java，非UI线程是同步的
    public static abstract class OnCppCall {
        public boolean isOnUIThread() {
            return false;
        }

        public abstract ParamsPackage.ParamsToCpp handle(ParamsPackage.ParamsFromCpp params);
    }

    // C++调用Java，UI线程是运行在主线程的
    public static abstract class OnCppCallOnUI extends OnCppCall {
        @Override
        public boolean isOnUIThread() {
            return true;
        }
    }

    public static boolean isUsingXCast() {
        ParamsPackage.ParamsFromCpp ret = JniHelper.callJniFunc("isUsingXCast");
        if (ret != null && !ret.isEmptyPkg()) {
            try {
                return (boolean) ret.getNext();
            } catch (IOException ignore) {
            }
        }
        return true;
    }
}
