/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.aapt;

import com.tencent.tinker.build.aapt.AaptResourceCollector;
import com.tencent.tinker.build.aapt.FakeRDotTxtEntry;
import com.tencent.tinker.build.aapt.FileUtil;
import com.tencent.tinker.build.aapt.JavaXmlUtil;
import com.tencent.tinker.build.aapt.RDotTxtEntry;
import com.tencent.tinker.build.aapt.ResourceDirectory;
import com.tencent.tinker.build.aapt.StringUtil;
import com.tencent.tinker.commons.util.IOHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class AaptUtil {
    private static final String ID_DEFINITION_PREFIX = "@+id/";
    private static final String ITEM_TAG = "item";
    private static final XPathExpression ANDROID_ID_USAGE = AaptUtil.createExpression("//@*[starts-with(., '@') and not(starts-with(., '@+')) and not(starts-with(., '@android:')) and not(starts-with(., '@null'))]");
    private static final XPathExpression ANDROID_ID_DEFINITION = AaptUtil.createExpression("//@*[starts-with(., '@+') and not(starts-with(., '@+android:id')) and not(starts-with(., '@+id/android:'))]");
    private static final Map<String, RDotTxtEntry.RType> RESOURCE_TYPES = AaptUtil.getResourceTypes();
    private static final List<String> IGNORED_TAGS = Arrays.asList("eat-comment", "skip");

    private static XPathExpression createExpression(String expressionStr) {
        try {
            return XPathFactory.newInstance().newXPath().compile(expressionStr);
        }
        catch (XPathExpressionException e) {
            throw new AaptUtilException(e);
        }
    }

    private static Map<String, RDotTxtEntry.RType> getResourceTypes() {
        HashMap<String, RDotTxtEntry.RType> types = new HashMap<String, RDotTxtEntry.RType>();
        for (RDotTxtEntry.RType rType : RDotTxtEntry.RType.values()) {
            types.put(rType.toString(), rType);
        }
        types.put("string-array", RDotTxtEntry.RType.ARRAY);
        types.put("integer-array", RDotTxtEntry.RType.ARRAY);
        types.put("declare-styleable", RDotTxtEntry.RType.STYLEABLE);
        return types;
    }

    public static AaptResourceCollector collectResource(List<String> resourceDirectoryList) {
        return AaptUtil.collectResource(resourceDirectoryList, null);
    }

    public static AaptResourceCollector collectResource(List<String> resourceDirectoryList, Map<RDotTxtEntry.RType, Set<RDotTxtEntry>> rTypeResourceMap) {
        AaptResourceCollector resourceCollector = new AaptResourceCollector(rTypeResourceMap);
        ArrayList<RDotTxtEntry> references = new ArrayList<RDotTxtEntry>();
        for (String resourceDirectory : resourceDirectoryList) {
            try {
                AaptUtil.collectResources(resourceDirectory, resourceCollector);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (String resourceDirectory : resourceDirectoryList) {
            try {
                AaptUtil.processXmlFilesForIds(resourceDirectory, references, resourceCollector);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return resourceCollector;
    }

    public static void processXmlFilesForIds(String resourceDirectory, List<RDotTxtEntry> references, AaptResourceCollector resourceCollector) throws Exception {
        List<String> xmlFullFilenameList = FileUtil.findMatchFile(resourceDirectory, ".xml");
        if (xmlFullFilenameList != null) {
            for (String xmlFullFilename : xmlFullFilenameList) {
                File xmlFile = new File(xmlFullFilename);
                String parentFullFilename = xmlFile.getParent();
                File parentFile = new File(parentFullFilename);
                if (AaptUtil.isAValuesDirectory(parentFile.getName()) || parentFile.getName().startsWith("raw")) continue;
                AaptUtil.processXmlFile(xmlFullFilename, references, resourceCollector);
            }
        }
    }

    private static void collectResources(String resourceDirectory, AaptResourceCollector resourceCollector) throws Exception {
        File resourceDirectoryFile = new File(resourceDirectory);
        File[] fileArray = resourceDirectoryFile.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (!file.isDirectory()) continue;
                String directoryName = file.getName();
                if (directoryName.startsWith("values")) {
                    if (!AaptUtil.isAValuesDirectory(directoryName)) {
                        throw new AaptUtilException("'" + directoryName + "' is not a valid values directory.");
                    }
                    AaptUtil.processValues(file.getAbsolutePath(), resourceCollector);
                    continue;
                }
                AaptUtil.processFileNamesInDirectory(file.getAbsolutePath(), resourceCollector);
            }
        }
    }

    public static boolean isAValuesDirectory(String directoryName) {
        if (directoryName == null) {
            throw new NullPointerException("directoryName can not be null");
        }
        return directoryName.equals("values") || directoryName.startsWith("values-");
    }

    public static void processFileNamesInDirectory(String resourceDirectory, AaptResourceCollector resourceCollector) throws IOException {
        File resourceDirectoryFile = new File(resourceDirectory);
        String directoryName = resourceDirectoryFile.getName();
        int dashIndex = directoryName.indexOf(45);
        if (dashIndex != -1) {
            directoryName = directoryName.substring(0, dashIndex);
        }
        if (!RESOURCE_TYPES.containsKey(directoryName)) {
            throw new AaptUtilException(resourceDirectoryFile.getAbsolutePath() + " is not a valid resource sub-directory.");
        }
        File[] fileArray = resourceDirectoryFile.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (file.isHidden()) continue;
                String filename = file.getName();
                int dotIndex = filename.indexOf(46);
                String resourceName = dotIndex != -1 ? filename.substring(0, dotIndex) : filename;
                RDotTxtEntry.RType rType = RESOURCE_TYPES.get(directoryName);
                resourceCollector.addIntResourceIfNotPresent(rType, resourceName);
                ResourceDirectory resourceDirectoryBean = new ResourceDirectory(file.getParentFile().getName(), file.getAbsolutePath());
                resourceCollector.addRTypeResourceName(rType, resourceName, null, resourceDirectoryBean);
            }
        }
    }

    public static void processValues(String resourceDirectory, AaptResourceCollector resourceCollector) throws Exception {
        File resourceDirectoryFile = new File(resourceDirectory);
        File[] fileArray = resourceDirectoryFile.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (file.isHidden() || !file.isFile()) continue;
                AaptUtil.processValuesFile(file.getAbsolutePath(), resourceCollector);
            }
        }
    }

    public static void processValuesFile(String valuesFullFilename, AaptResourceCollector resourceCollector) throws Exception {
        Document document = JavaXmlUtil.parse(valuesFullFilename);
        String directoryName = new File(valuesFullFilename).getParentFile().getName();
        Element root = document.getDocumentElement();
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String resourceType = node.getNodeName();
            if (resourceType.equals(ITEM_TAG) && (resourceType = node.getAttributes().getNamedItem("type").getNodeValue()).equals("id")) {
                resourceCollector.addIgnoreId(node.getAttributes().getNamedItem("name").getNodeValue());
            }
            if (IGNORED_TAGS.contains(resourceType)) continue;
            if (!RESOURCE_TYPES.containsKey(resourceType)) {
                throw new AaptUtilException("Invalid resource type '<" + resourceType + ">' in '" + valuesFullFilename + "'.");
            }
            RDotTxtEntry.RType rType = RESOURCE_TYPES.get(resourceType);
            String resourceValue = null;
            switch (rType) {
                case STRING: 
                case COLOR: 
                case DIMEN: 
                case DRAWABLE: 
                case BOOL: 
                case INTEGER: {
                    resourceValue = node.getTextContent().trim();
                    break;
                }
                case ARRAY: 
                case PLURALS: 
                case STYLE: 
                case STYLEABLE: {
                    resourceValue = AaptUtil.subNodeToString(node);
                    break;
                }
                case FRACTION: {
                    resourceValue = AaptUtil.nodeToString(node, true);
                    break;
                }
                case ATTR: {
                    resourceValue = AaptUtil.nodeToString(node, true);
                    break;
                }
            }
            try {
                AaptUtil.addToResourceCollector(resourceCollector, new ResourceDirectory(directoryName, valuesFullFilename), node, rType, resourceValue);
                continue;
            }
            catch (Exception e) {
                throw new AaptUtilException(e.getMessage() + ",Process file error:" + valuesFullFilename, e);
            }
        }
    }

    public static void processXmlFile(String xmlFullFilename, List<RDotTxtEntry> references, AaptResourceCollector resourceCollector) throws IOException, XPathExpressionException {
        Document document = JavaXmlUtil.parse(xmlFullFilename);
        NodeList nodesWithIds = (NodeList)ANDROID_ID_DEFINITION.evaluate(document, XPathConstants.NODESET);
        for (int i = 0; i < nodesWithIds.getLength(); ++i) {
            String resourceName = nodesWithIds.item(i).getNodeValue();
            if (!resourceName.startsWith(ID_DEFINITION_PREFIX)) {
                throw new AaptUtilException("Invalid definition of a resource: '" + resourceName + "'");
            }
            resourceCollector.addIntResourceIfNotPresent(RDotTxtEntry.RType.ID, resourceName.substring(ID_DEFINITION_PREFIX.length()));
        }
        NodeList nodesUsingIds = (NodeList)ANDROID_ID_USAGE.evaluate(document, XPathConstants.NODESET);
        for (int i = 0; i < nodesUsingIds.getLength(); ++i) {
            String resourceName = nodesUsingIds.item(i).getNodeValue();
            int slashPosition = resourceName.indexOf(47);
            if (slashPosition < 0) continue;
            String rawRType = resourceName.substring(1, slashPosition);
            String name = resourceName.substring(slashPosition + 1);
            if (name.startsWith("android:") || rawRType.startsWith("tools:")) continue;
            if (!RESOURCE_TYPES.containsKey(rawRType)) {
                throw new AaptUtilException("Invalid reference '" + resourceName + "' in '" + xmlFullFilename + "'");
            }
            RDotTxtEntry.RType rType = RESOURCE_TYPES.get(rawRType);
            references.add(new FakeRDotTxtEntry(RDotTxtEntry.IdType.INT, rType, AaptUtil.sanitizeName(rType, resourceCollector, name)));
        }
    }

    private static void addToResourceCollector(AaptResourceCollector resourceCollector, ResourceDirectory resourceDirectory, Node node, RDotTxtEntry.RType rType, String resourceValue) {
        String resourceName = AaptUtil.sanitizeName(rType, resourceCollector, AaptUtil.extractNameAttribute(node));
        resourceCollector.addRTypeResourceName(rType, resourceName, resourceValue, resourceDirectory);
        if (rType.equals((Object)RDotTxtEntry.RType.STYLEABLE)) {
            int count = 0;
            for (Node attrNode = node.getFirstChild(); attrNode != null; attrNode = attrNode.getNextSibling()) {
                if (attrNode.getNodeType() != 1 || !attrNode.getNodeName().equals("attr")) continue;
                String rawAttrName = AaptUtil.extractNameAttribute(attrNode);
                String attrName = AaptUtil.sanitizeName(rType, resourceCollector, rawAttrName);
                resourceCollector.addResource(RDotTxtEntry.RType.STYLEABLE, RDotTxtEntry.IdType.INT, String.format("%s_%s", resourceName, attrName), Integer.toString(count++));
                if (rawAttrName.startsWith("android:")) continue;
                resourceCollector.addIntResourceIfNotPresent(RDotTxtEntry.RType.ATTR, rawAttrName);
                resourceCollector.addRTypeResourceName(RDotTxtEntry.RType.ATTR, rawAttrName, AaptUtil.nodeToString(attrNode, true), resourceDirectory);
            }
            resourceCollector.addIntArrayResourceIfNotPresent(rType, resourceName, count);
        } else {
            resourceCollector.addIntResourceIfNotPresent(rType, resourceName);
        }
    }

    private static String sanitizeName(RDotTxtEntry.RType rType, AaptResourceCollector resourceCollector, String rawName) {
        String sanitizeName = rawName.replaceAll("[.:]", "_");
        resourceCollector.putSanitizeName(rType, sanitizeName, rawName);
        return sanitizeName;
    }

    private static String extractNameAttribute(Node node) {
        return node.getAttributes().getNamedItem("name").getNodeValue();
    }

    public static Map<String, Map<RDotTxtEntry.RType, Set<RDotTxtEntry>>> mergePackageRTypeResourceMap(List<PackageRTypeResourceMap> packageRTypeResourceMapList) {
        HashMap<String, Map<RDotTxtEntry.RType, Set<RDotTxtEntry>>> packageRTypeResourceMergeMap = new HashMap<String, Map<RDotTxtEntry.RType, Set<RDotTxtEntry>>>();
        HashMap<String, AaptResourceCollector> aaptResourceCollectorMap = new HashMap<String, AaptResourceCollector>();
        for (PackageRTypeResourceMap packageRTypeResourceMap : packageRTypeResourceMapList) {
            String packageName = packageRTypeResourceMap.packageName;
            Map rTypeResourceMap = packageRTypeResourceMap.rTypeResourceMap;
            AaptResourceCollector aaptResourceCollector = null;
            if (aaptResourceCollectorMap.containsKey(packageName)) {
                aaptResourceCollector = (AaptResourceCollector)aaptResourceCollectorMap.get(packageName);
            } else {
                aaptResourceCollector = new AaptResourceCollector();
                aaptResourceCollectorMap.put(packageName, aaptResourceCollector);
            }
            for (Map.Entry entry : rTypeResourceMap.entrySet()) {
                RDotTxtEntry.RType rType = (RDotTxtEntry.RType)((Object)entry.getKey());
                Set rDotTxtEntrySet = (Set)entry.getValue();
                for (RDotTxtEntry rDotTxtEntry : rDotTxtEntrySet) {
                    if (rDotTxtEntry.idType.equals((Object)RDotTxtEntry.IdType.INT)) {
                        aaptResourceCollector.addIntResourceIfNotPresent(rType, rDotTxtEntry.name);
                        continue;
                    }
                    if (!rDotTxtEntry.idType.equals((Object)RDotTxtEntry.IdType.INT_ARRAY)) continue;
                    aaptResourceCollector.addResource(rType, rDotTxtEntry.idType, rDotTxtEntry.name, rDotTxtEntry.idValue.trim());
                }
            }
        }
        for (Map.Entry entry : aaptResourceCollectorMap.entrySet()) {
            packageRTypeResourceMergeMap.put((String)entry.getKey(), ((AaptResourceCollector)entry.getValue()).getRTypeResourceMap());
        }
        return packageRTypeResourceMergeMap;
    }

    public static void writeRJava(String outputDirectory, String packageName, Map<RDotTxtEntry.RType, Set<RDotTxtEntry>> rTypeResourceMap, boolean isFinal) {
        String outputFullFilename = new File(outputDirectory).getAbsolutePath() + "/" + packageName.replace(".", "/") + "/" + "R" + "." + "java";
        FileUtil.createFile(outputFullFilename);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileOutputStream(outputFullFilename));
            writer.format("package %s;\n\n", packageName);
            writer.println("public final class R {\n");
            for (RDotTxtEntry.RType rType : rTypeResourceMap.keySet()) {
                writer.format("  public static final class %s {\n", rType.toString());
                for (RDotTxtEntry rDotTxtEntry : rTypeResourceMap.get((Object)rType)) {
                    writer.format("    public static%s%s %s=%s;\n", new Object[]{isFinal ? " final " : " ", rDotTxtEntry.idType, rDotTxtEntry.name, rDotTxtEntry.idValue.trim()});
                }
                writer.println("  }\n");
            }
            writer.println("}");
        }
        catch (Exception e) {
            try {
                throw new AaptUtilException(e);
            }
            catch (Throwable throwable) {
                IOHelper.closeQuietly(writer);
                throw throwable;
            }
        }
        IOHelper.closeQuietly((Object)writer);
    }

    public static void writeRJava(String outputDirectory, Map<String, Map<RDotTxtEntry.RType, Set<RDotTxtEntry>>> packageRTypeResourceMap, boolean isFinal) {
        for (String packageName : packageRTypeResourceMap.keySet()) {
            Map<RDotTxtEntry.RType, Set<RDotTxtEntry>> rTypeResourceMap = packageRTypeResourceMap.get(packageName);
            AaptUtil.writeRJava(outputDirectory, packageName, rTypeResourceMap, isFinal);
        }
    }

    private static String subNodeToString(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            stringBuilder.append(AaptUtil.nodeToString(node, false));
            stringBuilder.append("\r\n");
            int nodeListLength = nodeList.getLength();
            for (int i = 0; i < nodeListLength; ++i) {
                Node childNode = nodeList.item(i);
                if (childNode.getNodeType() != 1) continue;
                stringBuilder.append(AaptUtil.nodeToString(childNode, true));
                stringBuilder.append("\r\n");
            }
            if (stringBuilder.length() > "\r\n".length()) {
                stringBuilder.delete(stringBuilder.length() - "\r\n".length(), stringBuilder.length());
            }
        }
        return stringBuilder.toString();
    }

    private static String nodeToString(Node node, boolean isNoChild) {
        StringBuilder stringBuilder = new StringBuilder();
        if (node != null) {
            stringBuilder.append(node.getNodeName());
            NamedNodeMap namedNodeMap = node.getAttributes();
            stringBuilder.append("[");
            int namedNodeMapLength = namedNodeMap.getLength();
            for (int j = 0; j < namedNodeMapLength; ++j) {
                Node attributeNode = namedNodeMap.item(j);
                stringBuilder.append("@" + attributeNode.getNodeName() + "=" + attributeNode.getNodeValue());
                if (j >= namedNodeMapLength - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("]");
            String value = StringUtil.nullToBlank(isNoChild ? node.getTextContent() : node.getNodeValue()).trim();
            if (StringUtil.isNotBlank(value)) {
                stringBuilder.append("=" + value);
            }
        }
        return stringBuilder.toString();
    }

    public static class AaptUtilException
    extends RuntimeException {
        private static final long serialVersionUID = 1702278793911780809L;

        public AaptUtilException(String message) {
            super(message);
        }

        public AaptUtilException(Throwable cause) {
            super(cause);
        }

        public AaptUtilException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class PackageRTypeResourceMap {
        private String packageName = null;
        private Map<RDotTxtEntry.RType, Set<RDotTxtEntry>> rTypeResourceMap = null;

        public PackageRTypeResourceMap(String packageName, Map<RDotTxtEntry.RType, Set<RDotTxtEntry>> rTypeResourceMap) {
            this.packageName = packageName;
            this.rTypeResourceMap = rTypeResourceMap;
        }
    }
}

