/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.dexpatcher.util;

public class PatternUtils {
    public static String dotClassNamePatternToDescriptorRegEx(String dotPattern) {
        int i;
        if (dotPattern.startsWith("L") && dotPattern.endsWith(";") || dotPattern.startsWith("[")) {
            return dotPattern.replace('.', '/').replace("[", "\\[");
        }
        String descriptor = dotPattern.replace('.', '/');
        StringBuilder sb = new StringBuilder();
        for (i = dotPattern.length() - 1; i >= 1; i -= 2) {
            char ch = dotPattern.charAt(i);
            char prevCh = dotPattern.charAt(i - 1);
            if (prevCh != '[' || ch != ']') break;
            sb.append("\\[");
        }
        if ("void".equals(descriptor = descriptor.substring(0, i + 1))) {
            descriptor = "V";
            sb.append(descriptor);
        } else if ("boolean".equals(descriptor)) {
            descriptor = "Z";
            sb.append(descriptor);
        } else if ("byte".equals(descriptor)) {
            descriptor = "B";
            sb.append(descriptor);
        } else if ("short".equals(descriptor)) {
            descriptor = "S";
            sb.append(descriptor);
        } else if ("char".equals(descriptor)) {
            descriptor = "C";
            sb.append(descriptor);
        } else if ("int".equals(descriptor)) {
            descriptor = "I";
            sb.append(descriptor);
        } else if ("long".equals(descriptor)) {
            descriptor = "J";
            sb.append(descriptor);
        } else if ("float".equals(descriptor)) {
            descriptor = "F";
            sb.append(descriptor);
        } else if ("double".equals(descriptor)) {
            descriptor = "D";
            sb.append(descriptor);
        } else {
            sb.append('L').append(descriptor);
            if (!descriptor.endsWith(";")) {
                sb.append(';');
            }
        }
        String regEx = sb.toString();
        regEx = regEx.replace("*", ".*");
        regEx = regEx.replace("?", ".?");
        regEx = regEx.replace("$", "\\$");
        regEx = '^' + regEx + '$';
        return regEx;
    }
}

