/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.apkparser;

import com.tencent.tinker.build.patch.Configuration;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tinker.net.dongliu.apk.parser.ApkParser;
import tinker.net.dongliu.apk.parser.bean.ApkMeta;
import tinker.net.dongliu.apk.parser.exception.ParserException;
import tinker.net.dongliu.apk.parser.parser.ApkMetaTranslator;
import tinker.net.dongliu.apk.parser.parser.BinaryXmlParser;
import tinker.net.dongliu.apk.parser.parser.CompositeXmlStreamer;
import tinker.net.dongliu.apk.parser.parser.ResourceTableParser;
import tinker.net.dongliu.apk.parser.parser.XmlStreamer;
import tinker.net.dongliu.apk.parser.parser.XmlTranslator;
import tinker.net.dongliu.apk.parser.struct.ResourceValue;
import tinker.net.dongliu.apk.parser.struct.StringPool;
import tinker.net.dongliu.apk.parser.struct.resource.ResourceTable;
import tinker.net.dongliu.apk.parser.struct.xml.Attribute;
import tinker.net.dongliu.apk.parser.utils.ParseUtils;
import tinker.net.dongliu.apk.parser.utils.Utils;

public class AndroidParser {
    public static final int TYPE_SERVICE = 1;
    public static final int TYPE_ACTIVITY = 2;
    public static final int TYPE_BROADCAST_RECEIVER = 3;
    public static final int TYPE_CONTENT_PROVIDER = 4;
    public final List<String> activities = new ArrayList<String>();
    public final List<String> receivers = new ArrayList<String>();
    public final List<String> services = new ArrayList<String>();
    public final List<String> providers = new ArrayList<String>();
    public final ApkMeta apkMeta;
    public final String xml;
    public final HashMap<String, String> metaDatas = new HashMap();

    public AndroidParser(ApkMeta apkMeta, String xml) throws ParserException {
        this.apkMeta = apkMeta;
        this.xml = xml;
        this.parse();
    }

    public static boolean resourceTableLogicalChange(Configuration config) throws IOException {
        ApkParser parser = new ApkParser(config.mOldApkFile);
        ApkParser newParser = new ApkParser(config.mNewApkFile);
        parser.parseResourceTable();
        newParser.parseResourceTable();
        return parser.getResourceTable().equals((Object)newParser.getResourceTable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void editResourceTableString(String from, String to, File originFile, File destFile) throws IOException {
        if (from == null || to == null) {
            return;
        }
        if (!originFile.exists()) {
            throw new RuntimeException("origin resources.arsc is not exist, path:" + originFile.getPath());
        }
        if (from.length() != to.length()) {
            throw new RuntimeException("only support the same string length now!");
        }
        ApkParser parser = new ApkParser();
        parser.parseResourceTable(originFile);
        ResourceTable resourceTable = parser.getResourceTable();
        StringPool stringPool = resourceTable.getStringPool();
        ByteBuffer buffer = resourceTable.getBuffers();
        byte[] array = buffer.array();
        int length = stringPool.getPool().length;
        boolean found = false;
        for (int i = 0; i < length; ++i) {
            byte[] tempByte;
            String value = stringPool.get(i);
            if (!value.equals(from)) continue;
            found = true;
            long offset = (Long)stringPool.getPoolOffsets().get(i);
            offset += 2L;
            if (stringPool.isUtf8()) {
                tempByte = to.getBytes(ParseUtils.charsetUTF8);
                if (to.length() != tempByte.length) {
                    throw new RuntimeException(String.format("editResourceTableString length is different, name %d, tempByte %d\n", to.length(), tempByte.length));
                }
            } else {
                tempByte = to.getBytes(ParseUtils.charsetUTF16);
                if (to.length() * 2 != tempByte.length) {
                    throw new RuntimeException(String.format("editResourceTableString length is different, name %d, tempByte %d\n", to.length(), tempByte.length));
                }
            }
            System.arraycopy(tempByte, 0, array, (int)offset, tempByte.length);
        }
        if (!found) {
            throw new RuntimeException("can't found string:" + from + " in the resources.arsc file's string pool!");
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(destFile);){
            fileOutputStream.write(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndroidParser getAndroidManifest(File file) throws IOException, ParseException {
        ZipFile zf = null;
        try {
            AndroidParser androidManifest;
            zf = new ZipFile(file);
            ByteBuffer arscData = AndroidParser.getZipEntryData(zf, "resources.arsc");
            ResourceTableParser resTableParser = new ResourceTableParser(arscData);
            resTableParser.parse();
            ResourceTable resTable = resTableParser.getResourceTable();
            ByteBuffer manifestData = AndroidParser.getZipEntryData(zf, "AndroidManifest.xml");
            BinaryXmlParser xmlParser = new BinaryXmlParser(manifestData, resTable);
            ApkMetaTranslator metaTranslator = new ApkMetaTranslator();
            XmlTranslatorForPatch xmlTranslator = new XmlTranslatorForPatch();
            CompositeXmlStreamer compositeStreamer = new CompositeXmlStreamer(new XmlStreamer[]{metaTranslator, xmlTranslator});
            xmlParser.setXmlStreamer((XmlStreamer)compositeStreamer);
            xmlParser.parse();
            AndroidParser androidParser = androidManifest = new AndroidParser(metaTranslator.getApkMeta(), xmlTranslator.getXml());
            return androidParser;
        }
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer getZipEntryData(ZipFile zf, String entryPath) throws IOException {
        ZipEntry entry = zf.getEntry(entryPath);
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(zf.getInputStream(entry));
            byte[] data = Utils.toByteArray((InputStream)is);
            ByteBuffer byteBuffer = ByteBuffer.wrap(data);
            return byteBuffer;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static String getAttribute(NamedNodeMap namedNodeMap, String name) {
        Node node = namedNodeMap.getNamedItem(name);
        if (node == null) {
            if (name.startsWith("android:")) {
                name = name.substring("android:".length());
            }
            if ((node = namedNodeMap.getNamedItem(name)) == null) {
                return null;
            }
        }
        return node.getNodeValue();
    }

    public List<String> getComponents() {
        ArrayList<String> components = new ArrayList<String>();
        components.addAll(this.activities);
        components.addAll(this.services);
        components.addAll(this.receivers);
        components.addAll(this.providers);
        return components;
    }

    private void parse() throws ParserException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(this.xml.getBytes("UTF-8")));
            Node manifestNode = document.getElementsByTagName("manifest").item(0);
            NodeList nodes = manifestNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (!nodeName.equals("application")) continue;
                NodeList children = node.getChildNodes();
                block17: for (int j = 0; j < children.getLength(); ++j) {
                    String childName;
                    Node child = children.item(j);
                    switch (childName = child.getNodeName()) {
                        case "service": {
                            this.services.add(this.getAndroidComponent(child, 1));
                            continue block17;
                        }
                        case "activity": {
                            this.activities.add(this.getAndroidComponent(child, 2));
                            continue block17;
                        }
                        case "receiver": {
                            this.receivers.add(this.getAndroidComponent(child, 3));
                            continue block17;
                        }
                        case "provider": {
                            this.providers.add(this.getAndroidComponent(child, 4));
                            continue block17;
                        }
                        case "meta-data": {
                            NamedNodeMap attributes = child.getAttributes();
                            this.metaDatas.put(AndroidParser.getAttribute(attributes, "android:name"), AndroidParser.getAttribute(attributes, "android:value"));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ParserException("Error parsing AndroidManifest.xml", (Throwable)e);
        }
    }

    private String getAndroidComponent(Node node, int type) {
        NamedNodeMap attributes = node.getAttributes();
        return AndroidParser.getAttribute(attributes, "android:name");
    }

    private static final class XmlTranslatorForPatch
    extends XmlTranslator {
        private XmlTranslatorForPatch() {
        }

        public void onAttribute(Attribute attribute) {
            ResourceValue attrVal = attribute.getTypedValue();
            if (attrVal != null && attrVal instanceof ResourceValue.ReferenceResourceValue) {
                attribute.setValue(attrVal.toString());
            }
            super.onAttribute(attribute);
        }
    }
}

