/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareDexDiffPatchInfo;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ShareTinkerInternals {
    private static final String TAG = "Tinker.TinkerInternals";
    private static final boolean VM_IS_ART = ShareTinkerInternals.isVmArt(System.getProperty("java.vm.version"));
    private static final boolean VM_IS_JIT = ShareTinkerInternals.isVmJitInternal();
    private static final String PATCH_PROCESS_NAME = ":patch";
    private static Boolean isPatchProcess = null;
    private static Boolean isARKHotRunning = null;
    private static final String[] processName = new String[]{null};
    private static String tinkerID = null;
    private static String currentInstructionSet = null;
    private static final String SAFEMODE_COUNT_REC_PREFIX = "safemode_count_rec_";

    public static boolean isVmArt() {
        return VM_IS_ART || Build.VERSION.SDK_INT >= 21;
    }

    public static boolean isVmJit() {
        return VM_IS_JIT && Build.VERSION.SDK_INT < 24;
    }

    public static boolean isArkHotRuning() {
        if (isARKHotRunning != null) {
            return isARKHotRunning;
        }
        isARKHotRunning = false;
        Class<?> arkApplicationInfo = null;
        try {
            arkApplicationInfo = ClassLoader.getSystemClassLoader().getParent().loadClass("com.huawei.ark.app.ArkApplicationInfo");
            Method isRunningInArkHot = null;
            isRunningInArkHot = arkApplicationInfo.getDeclaredMethod("isRunningInArk", new Class[0]);
            isRunningInArkHot.setAccessible(true);
            isARKHotRunning = (Boolean)isRunningInArkHot.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            ShareTinkerLog.i(TAG, "class not found exception", new Object[0]);
        }
        catch (NoSuchMethodException e) {
            ShareTinkerLog.i(TAG, "no such method exception", new Object[0]);
        }
        catch (SecurityException e) {
            ShareTinkerLog.i(TAG, "security exception", new Object[0]);
        }
        catch (IllegalAccessException e) {
            ShareTinkerLog.i(TAG, "illegal access exception", new Object[0]);
        }
        catch (InvocationTargetException e) {
            ShareTinkerLog.i(TAG, "invocation target exception", new Object[0]);
        }
        catch (IllegalArgumentException e) {
            ShareTinkerLog.i(TAG, "illegal argument exception", new Object[0]);
        }
        return isARKHotRunning;
    }

    public static boolean isAfterAndroidO() {
        return Build.VERSION.SDK_INT > 25;
    }

    public static String getCurrentInstructionSet() {
        if (currentInstructionSet != null) {
            return currentInstructionSet;
        }
        try {
            Class<?> clazz = Class.forName("dalvik.system.VMRuntime");
            Method currentGet = clazz.getDeclaredMethod("getCurrentInstructionSet", new Class[0]);
            currentGet.setAccessible(true);
            currentInstructionSet = (String)currentGet.invoke(null, new Object[0]);
        }
        catch (Throwable ignored) {
            switch (Build.CPU_ABI) {
                case "armeabi": 
                case "armeabi_v7a": {
                    currentInstructionSet = "arm";
                    break;
                }
                case "arm64_v8a": {
                    currentInstructionSet = "arm64";
                    break;
                }
                case "x86": {
                    currentInstructionSet = "x86";
                    break;
                }
                case "x86_64": {
                    currentInstructionSet = "x86_64";
                    break;
                }
                case "mips": {
                    currentInstructionSet = "mips";
                    break;
                }
                case "mips64": {
                    currentInstructionSet = "mips64";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported abi: " + Build.CPU_ABI);
                }
            }
        }
        ShareTinkerLog.d(TAG, "getCurrentInstructionSet:" + currentInstructionSet, new Object[0]);
        return currentInstructionSet;
    }

    public static boolean isSystemOTA(String lastFingerPrint) {
        String currentFingerprint = Build.FINGERPRINT;
        if (lastFingerPrint == null || lastFingerPrint.equals("") || currentFingerprint == null || currentFingerprint.equals("")) {
            ShareTinkerLog.d(TAG, "fingerprint empty:" + lastFingerPrint + ",current:" + currentFingerprint, new Object[0]);
            return false;
        }
        if (lastFingerPrint.equals(currentFingerprint)) {
            ShareTinkerLog.d(TAG, "same fingerprint:" + currentFingerprint, new Object[0]);
            return false;
        }
        ShareTinkerLog.d(TAG, "system OTA,fingerprint not equal:" + lastFingerPrint + "," + currentFingerprint, new Object[0]);
        return true;
    }

    public static ShareDexDiffPatchInfo changeTestDexToClassN(ShareDexDiffPatchInfo rawDexInfo, int index) {
        if (rawDexInfo.rawName.startsWith("test.dex")) {
            String newName = index != 1 ? "classes" + index + ".dex" : "classes.dex";
            return new ShareDexDiffPatchInfo(newName, rawDexInfo.path, rawDexInfo.destMd5InDvm, rawDexInfo.destMd5InArt, rawDexInfo.dexDiffMd5, rawDexInfo.oldDexCrC, rawDexInfo.newOrPatchedDexCrC, rawDexInfo.dexMode);
        }
        return null;
    }

    public static boolean isNullOrNil(String object) {
        return object == null || object.length() <= 0;
    }

    public static int checkTinkerPackage(Context context, int tinkerFlag, File patchFile, ShareSecurityCheck securityCheck) {
        int returnCode = ShareTinkerInternals.checkSignatureAndTinkerID(context, patchFile, securityCheck);
        if (returnCode == 0) {
            returnCode = ShareTinkerInternals.checkPackageAndTinkerFlag(securityCheck, tinkerFlag);
        }
        return returnCode;
    }

    public static int checkSignatureAndTinkerID(Context context, File patchFile, ShareSecurityCheck securityCheck) {
        if (!securityCheck.verifyPatchMetaSignature(patchFile)) {
            return -1;
        }
        String oldTinkerId = ShareTinkerInternals.getManifestTinkerID(context);
        if (oldTinkerId == null) {
            return -5;
        }
        HashMap<String, String> properties = securityCheck.getPackagePropertiesIfPresent();
        if (properties == null) {
            return -2;
        }
        String patchTinkerId = properties.get("TINKER_ID");
        if (patchTinkerId == null) {
            return -6;
        }
        if (!oldTinkerId.equals(patchTinkerId)) {
            ShareTinkerLog.e(TAG, "tinkerId in patch is not matched with the one in base pack, base: %s, patch: %s.", oldTinkerId, patchTinkerId);
            return -7;
        }
        return 0;
    }

    public static int checkPackageAndTinkerFlag(ShareSecurityCheck securityCheck, int tinkerFlag) {
        if (ShareTinkerInternals.isTinkerEnabledAll(tinkerFlag)) {
            return 0;
        }
        HashMap<String, String> metaContentMap = securityCheck.getMetaContentMap();
        boolean dexEnable = ShareTinkerInternals.isTinkerEnabledForDex(tinkerFlag);
        if (!dexEnable && metaContentMap.containsKey("assets/dex_meta.txt")) {
            return -9;
        }
        boolean nativeEnable = ShareTinkerInternals.isTinkerEnabledForNativeLib(tinkerFlag);
        if (!nativeEnable && metaContentMap.containsKey("assets/so_meta.txt")) {
            return -9;
        }
        boolean resEnable = ShareTinkerInternals.isTinkerEnabledForResource(tinkerFlag);
        if (!resEnable && metaContentMap.containsKey("assets/res_meta.txt")) {
            return -9;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Properties fastGetPatchPackageMeta(File patchFile) {
        ZipEntry packageEntry;
        ZipFile zipFile;
        block9: {
            if (patchFile == null || !patchFile.isFile() || patchFile.length() == 0L) {
                ShareTinkerLog.e(TAG, "patchFile is illegal", new Object[0]);
                return null;
            }
            zipFile = null;
            zipFile = new ZipFile(patchFile);
            packageEntry = zipFile.getEntry("assets/package_meta.txt");
            if (packageEntry != null) break block9;
            ShareTinkerLog.e(TAG, "patch meta entry not found", new Object[0]);
            Properties properties = null;
            SharePatchFileUtil.closeZip(zipFile);
            return properties;
        }
        InputStream inputStream = null;
        inputStream = zipFile.getInputStream(packageEntry);
        Properties properties = new Properties();
        properties.load(inputStream);
        Properties properties2 = properties;
        SharePatchFileUtil.closeQuietly(inputStream);
        SharePatchFileUtil.closeZip(zipFile);
        return properties2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        SharePatchFileUtil.closeQuietly(inputStream);
                        throw throwable;
                    }
                    catch (IOException e) {
                        ShareTinkerLog.e(TAG, "fastGetPatchPackageMeta exception:" + e.getMessage(), new Object[0]);
                        Properties properties3 = null;
                        SharePatchFileUtil.closeZip(zipFile);
                        return properties3;
                    }
                }
                catch (Throwable throwable2) {
                    SharePatchFileUtil.closeZip(zipFile);
                    throw throwable2;
                }
            }
        }
    }

    public static String getManifestTinkerID(Context context) {
        if (tinkerID != null) {
            return tinkerID;
        }
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Object object = appInfo.metaData.get("TINKER_ID");
            tinkerID = object != null ? String.valueOf(object) : null;
        }
        catch (Exception e) {
            ShareTinkerLog.e(TAG, "getManifestTinkerID exception:" + e.getMessage(), new Object[0]);
            return null;
        }
        return tinkerID;
    }

    public static boolean isTinkerEnabledForDex(int flag) {
        return (flag & 1) != 0;
    }

    public static boolean isTinkerEnabledForNativeLib(int flag) {
        return (flag & 2) != 0;
    }

    public static boolean isTinkerEnabledForResource(int flag) {
        return (flag & 4) != 0;
    }

    public static boolean isTinkerEnabledForArkHot(int flag) {
        return (flag & 8) != 0;
    }

    public static String getTypeString(int type) {
        switch (type) {
            case 3: {
                return "dex";
            }
            case 4: {
                return "dex_opt";
            }
            case 5: {
                return "lib";
            }
            case 1: {
                return "patch_file";
            }
            case 2: {
                return "patch_info";
            }
            case 6: {
                return "resource";
            }
        }
        return "unknown";
    }

    public static void setTinkerDisableWithSharedPreferences(Context context) {
        SharedPreferences sp = context.getSharedPreferences("tinker_share_config", 4);
        String keyName = ShareTinkerInternals.getTinkerSwitchSPKey(context);
        sp.edit().putBoolean(keyName, false).commit();
    }

    public static boolean isTinkerEnableWithSharedPreferences(Context context) {
        if (context == null) {
            return false;
        }
        SharedPreferences sp = context.getSharedPreferences("tinker_share_config", 4);
        String keyName = ShareTinkerInternals.getTinkerSwitchSPKey(context);
        return sp.getBoolean(keyName, true);
    }

    private static String getTinkerSwitchSPKey(Context context) {
        String tmpTinkerId = ShareTinkerInternals.getManifestTinkerID(context);
        if (ShareTinkerInternals.isNullOrNil(tmpTinkerId)) {
            tmpTinkerId = "@@";
        }
        return "tinker_enable_1.9.14.24_" + tmpTinkerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSafeModeCount(Context context) {
        int n;
        DataInputStream dis;
        String recFileName;
        block5: {
            String processName = ShareTinkerInternals.getProcessName(context);
            recFileName = SAFEMODE_COUNT_REC_PREFIX + processName;
            File safeModeRecFile = new File(SharePatchFileUtil.getPatchDirectory(context), recFileName);
            dis = null;
            dis = new DataInputStream(new FileInputStream(safeModeRecFile));
            String expectedKey = "safe_mode_count_1.9.14.24";
            String actualKey = dis.readUTF();
            if ("safe_mode_count_1.9.14.24".equals(actualKey)) break block5;
            ShareTinkerLog.w(TAG, "getSafeModeCount: key is not equal, expt: %s, actul: %s, return 0 instead.", "safe_mode_count_1.9.14.24", actualKey);
            int n2 = 0;
            SharePatchFileUtil.closeQuietly(dis);
            return n2;
        }
        try {
            int count = dis.readInt();
            ShareTinkerLog.i(TAG, "getSafeModeCount: count: %s", count);
            n = count;
        }
        catch (Throwable ignored) {
            int n3;
            try {
                ShareTinkerLog.w(TAG, "getSafeModeCount: recFileName:" + recFileName + " failed, return 0 instead.", new Object[0]);
                n3 = 0;
            }
            catch (Throwable throwable) {
                SharePatchFileUtil.closeQuietly(dis);
                throw throwable;
            }
            SharePatchFileUtil.closeQuietly(dis);
            return n3;
        }
        SharePatchFileUtil.closeQuietly(dis);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSafeModeCount(Context context, int count) {
        String processName = ShareTinkerInternals.getProcessName(context);
        String recFileName = SAFEMODE_COUNT_REC_PREFIX + processName;
        File safeModeRecFile = new File(SharePatchFileUtil.getPatchDirectory(context), recFileName);
        if (!safeModeRecFile.exists()) {
            safeModeRecFile.getParentFile().mkdirs();
        }
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(new FileOutputStream(safeModeRecFile));
            String key = "safe_mode_count_1.9.14.24";
            dos.writeUTF("safe_mode_count_1.9.14.24");
            dos.writeInt(count);
            ShareTinkerLog.i(TAG, "setSafeModeCount: count: %s", count);
        }
        catch (Throwable ignored) {
            try {
                ShareTinkerLog.w(TAG, "setSafeModeCount: recFileName:" + recFileName + " failed, return 0 instead.", new Object[0]);
            }
            catch (Throwable throwable) {
                SharePatchFileUtil.closeQuietly(dos);
                throw throwable;
            }
            SharePatchFileUtil.closeQuietly(dos);
        }
        SharePatchFileUtil.closeQuietly(dos);
    }

    public static boolean isTinkerEnabled(int flag) {
        return flag != 0;
    }

    public static boolean isTinkerEnabledAll(int flag) {
        return flag == 15;
    }

    public static boolean isInMainProcess(Context context) {
        String processName;
        String mainProcessName = null;
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (applicationInfo != null) {
            mainProcessName = applicationInfo.processName;
        }
        if (ShareTinkerInternals.isNullOrNil(mainProcessName)) {
            mainProcessName = context.getPackageName();
        }
        if ((processName = ShareTinkerInternals.getProcessName(context)) == null || processName.length() == 0) {
            processName = "";
        }
        return mainProcessName.equals(processName);
    }

    public static boolean isInPatchProcess(Context context) {
        if (isPatchProcess != null) {
            return isPatchProcess;
        }
        isPatchProcess = ShareTinkerInternals.getProcessName(context).endsWith(PATCH_PROCESS_NAME);
        return isPatchProcess;
    }

    public static String getCurrentOatMode(Context context, String current) {
        if (current.equals("changing")) {
            current = ShareTinkerInternals.isInMainProcess(context) ? "odex" : "interpet";
        }
        return current;
    }

    public static void killAllOtherProcess(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        if (am == null) {
            return;
        }
        List appProcessList = am.getRunningAppProcesses();
        if (appProcessList == null) {
            return;
        }
        for (ActivityManager.RunningAppProcessInfo ai : appProcessList) {
            if (ai.uid != Process.myUid() || ai.pid == Process.myPid()) continue;
            Process.killProcess((int)ai.pid);
        }
    }

    public static void killProcessExceptMain(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        if (am == null) {
            return;
        }
        List appProcessList = am.getRunningAppProcesses();
        if (appProcessList != null) {
            for (ActivityManager.RunningAppProcessInfo ai : appProcessList) {
                if (ai.uid != Process.myUid() || ai.processName.equals(context.getPackageName())) continue;
                Process.killProcess((int)ai.pid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String getProcessName(Context context) {
        if (processName[0] == null) {
            String[] stringArray = processName;
            // MONITORENTER : processName
            if (processName[0] == null) {
                ShareTinkerInternals.processName[0] = ShareTinkerInternals.getProcessNameInternal(context);
            }
            // MONITOREXIT : stringArray
        }
        if (processName[0] == null) return "";
        String string = processName[0];
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private static String getProcessNameInternal(Context context) {
        BufferedInputStream in;
        block11: {
            String string;
            String result;
            if (ShareTinkerInternals.isNewerOrEqualThanVersion(28, true) && !TextUtils.isEmpty((CharSequence)(result = Application.getProcessName()))) {
                return result;
            }
            if (context != null) {
                try {
                    List procInfos;
                    int myPid = Process.myPid();
                    int myUid = Process.myUid();
                    ActivityManager am = (ActivityManager)context.getSystemService("activity");
                    if (am != null && (procInfos = am.getRunningAppProcesses()) != null) {
                        for (ActivityManager.RunningAppProcessInfo procInfo : procInfos) {
                            if (procInfo.pid != myPid || procInfo.uid != myUid) continue;
                            return procInfo.processName;
                        }
                    }
                }
                catch (Throwable myPid) {
                    // empty catch block
                }
            }
            byte[] buf = new byte[2048];
            in = null;
            try {
                int len;
                in = new BufferedInputStream(new FileInputStream("/proc/self/cmdline"));
                for (len = ((InputStream)in).read(buf); len > 0 && (buf[len - 1] <= 0 || buf[len - 1] == 10 || buf[len - 1] == 13); --len) {
                }
                if (len <= 0) break block11;
                string = new String(buf, StandardCharsets.US_ASCII);
            }
            catch (Throwable thr) {
                try {
                    ShareTinkerLog.e(TAG, "getProcessNameInternal parse cmdline exception:" + thr.getMessage(), new Object[0]);
                }
                catch (Throwable throwable) {
                    SharePatchFileUtil.closeQuietly(in);
                    throw throwable;
                }
                SharePatchFileUtil.closeQuietly(in);
            }
            SharePatchFileUtil.closeQuietly(in);
            return string;
        }
        SharePatchFileUtil.closeQuietly(in);
        return null;
    }

    private static boolean isVmArt(String versionString) {
        Matcher matcher;
        boolean isArt = false;
        if (versionString != null && (matcher = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+)?").matcher(versionString)).matches()) {
            try {
                int major = Integer.parseInt(matcher.group(1));
                int minor = Integer.parseInt(matcher.group(2));
                isArt = major > 2 || major == 2 && minor >= 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return isArt;
    }

    private static boolean isVmJitInternal() {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method mthGet = clazz.getDeclaredMethod("get", String.class);
            String jit = (String)mthGet.invoke(null, "dalvik.vm.usejit");
            String jitProfile = (String)mthGet.invoke(null, "dalvik.vm.usejitprofiles");
            if (!ShareTinkerInternals.isNullOrNil(jit) && ShareTinkerInternals.isNullOrNil(jitProfile) && jit.equals("true")) {
                return true;
            }
        }
        catch (Throwable e) {
            ShareTinkerLog.e(TAG, "isVmJitInternal ex:" + e, new Object[0]);
        }
        return false;
    }

    public static boolean isNewerOrEqualThanVersion(int apiLevel, boolean includePreviewVer) {
        if (includePreviewVer && Build.VERSION.SDK_INT >= 23) {
            return Build.VERSION.SDK_INT >= apiLevel || Build.VERSION.SDK_INT == apiLevel - 1 && Build.VERSION.PREVIEW_SDK_INT > 0;
        }
        return Build.VERSION.SDK_INT >= apiLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExceptionCauseString(Throwable ex) {
        if (ex == null) {
            return "";
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        try {
            Throwable cause;
            Throwable t = ex;
            while ((cause = t.getCause()) != null) {
                t = cause;
            }
            t.printStackTrace(ps);
            String string = ShareTinkerInternals.toVisualString(bos.toString());
            return string;
        }
        finally {
            SharePatchFileUtil.closeQuietly(ps);
        }
    }

    public static String toVisualString(String src) {
        int i;
        boolean cutFlg = false;
        if (null == src) {
            return null;
        }
        char[] chr = src.toCharArray();
        if (null == chr) {
            return null;
        }
        for (i = 0; i < chr.length; ++i) {
            if (chr[i] <= '\u007f') continue;
            chr[i] = '\u0000';
            cutFlg = true;
            break;
        }
        if (cutFlg) {
            return new String(chr, 0, i);
        }
        return src;
    }

    public static void cleanPatch(Context context) {
        if (context == null) {
            throw new TinkerRuntimeException("context is null");
        }
        File tinkerDir = SharePatchFileUtil.getPatchDirectory(context);
        if (!tinkerDir.exists()) {
            ShareTinkerLog.printErrStackTrace(TAG, new Throwable(), "try to clean patch while there're not any applied patches.", new Object[0]);
            return;
        }
        File patchInfoFile = SharePatchFileUtil.getPatchInfoFile(tinkerDir.getAbsolutePath());
        if (!patchInfoFile.exists()) {
            ShareTinkerLog.printErrStackTrace(TAG, new Throwable(), "try to clean patch while patch info file does not exist.", new Object[0]);
            return;
        }
        File patchInfoLockFile = SharePatchFileUtil.getPatchInfoLockFile(tinkerDir.getAbsolutePath());
        SharePatchInfo patchInfo = SharePatchInfo.readAndCheckPropertyWithLock(patchInfoFile, patchInfoLockFile);
        if (patchInfo != null) {
            if (!patchInfo.newVersion.equals(patchInfo.oldVersion)) {
                String patchName = SharePatchFileUtil.getPatchVersionDirectory(patchInfo.newVersion);
                SharePatchFileUtil.deleteDir(new File(tinkerDir, patchName));
                patchInfo.newVersion = patchInfo.oldVersion;
                patchInfo.versionToRemove = "";
            } else {
                patchInfo.versionToRemove = patchInfo.newVersion;
            }
            SharePatchInfo.rewritePatchInfoFileWithLock(patchInfoFile, patchInfo, patchInfoLockFile);
        } else {
            ShareTinkerLog.printErrStackTrace(TAG, new Throwable(), "fail to get patchInfo.", new Object[0]);
        }
    }
}

