/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.ArrayMap;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TinkerResourcePatcher {
    private static final String TAG = "Tinker.ResourcePatcher";
    private static final String TEST_ASSETS_VALUE = "only_use_to_test_tinker_resource.txt";
    private static Collection<WeakReference<Resources>> references = null;
    private static Object currentActivityThread = null;
    private static AssetManager newAssetManager = null;
    private static Constructor<?> newAssetManagerCtor = null;
    private static Method addAssetPathMethod = null;
    private static Method addAssetPathAsSharedLibraryMethod = null;
    private static Method ensureStringBlocksMethod = null;
    private static Field assetsFiled = null;
    private static Field resourcesImplFiled = null;
    private static Field resDir = null;
    private static Field packagesFiled = null;
    private static Field resourcePackagesFiled = null;
    private static Field publicSourceDirField = null;
    private static Field stringBlocksField = null;
    private static long storedPatchedResModifiedTime = 0L;

    TinkerResourcePatcher() {
    }

    public static void isResourceCanPatch(Context context) throws Throwable {
        Class<?> loadedApkClass;
        Class<?> activityThread = Class.forName("android.app.ActivityThread");
        currentActivityThread = ShareReflectUtil.getActivityThread(context, activityThread);
        try {
            loadedApkClass = Class.forName("android.app.LoadedApk");
        }
        catch (ClassNotFoundException e) {
            loadedApkClass = Class.forName("android.app.ActivityThread$PackageInfo");
        }
        resDir = ShareReflectUtil.findField(loadedApkClass, "mResDir");
        packagesFiled = ShareReflectUtil.findField(activityThread, "mPackages");
        if (Build.VERSION.SDK_INT < 27) {
            resourcePackagesFiled = ShareReflectUtil.findField(activityThread, "mResourcePackages");
        }
        AssetManager assets = context.getAssets();
        addAssetPathMethod = ShareReflectUtil.findMethod(assets, "addAssetPath", String.class);
        if (TinkerResourcePatcher.shouldAddSharedLibraryAssets(context.getApplicationInfo())) {
            addAssetPathAsSharedLibraryMethod = ShareReflectUtil.findMethod(assets, "addAssetPathAsSharedLibrary", String.class);
        }
        try {
            stringBlocksField = ShareReflectUtil.findField(assets, "mStringBlocks");
            ensureStringBlocksMethod = ShareReflectUtil.findMethod(assets, "ensureStringBlocks", new Class[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        newAssetManagerCtor = ShareReflectUtil.findConstructor(assets, new Class[0]);
        if (Build.VERSION.SDK_INT >= 19) {
            Class<?> resourcesManagerClass = Class.forName("android.app.ResourcesManager");
            Method mGetInstance = ShareReflectUtil.findMethod(resourcesManagerClass, "getInstance", new Class[0]);
            Object resourcesManager = mGetInstance.invoke(null, new Object[0]);
            try {
                Field fMActiveResources = ShareReflectUtil.findField(resourcesManagerClass, "mActiveResources");
                ArrayMap activeResources19 = (ArrayMap)fMActiveResources.get(resourcesManager);
                references = activeResources19.values();
            }
            catch (NoSuchFieldException ignore) {
                Field mResourceReferences = ShareReflectUtil.findField(resourcesManagerClass, "mResourceReferences");
                references = (Collection)mResourceReferences.get(resourcesManager);
            }
        } else {
            Field fMActiveResources = ShareReflectUtil.findField(activityThread, "mActiveResources");
            HashMap activeResources7 = (HashMap)fMActiveResources.get(currentActivityThread);
            references = activeResources7.values();
        }
        if (references == null) {
            throw new IllegalStateException("resource references is null");
        }
        Resources resources = context.getResources();
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                resourcesImplFiled = ShareReflectUtil.findField(resources, "mResourcesImpl");
            }
            catch (Throwable ignore) {
                assetsFiled = ShareReflectUtil.findField(resources, "mAssets");
            }
        } else {
            assetsFiled = ShareReflectUtil.findField(resources, "mAssets");
        }
        try {
            publicSourceDirField = ShareReflectUtil.findField(ApplicationInfo.class, "publicSourceDir");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public static void monkeyPatchExistingResources(Context context, String externalResourceFile, boolean isReInject) throws Throwable {
        if (externalResourceFile == null) {
            return;
        }
        ApplicationInfo appInfo = context.getApplicationInfo();
        Field[] packagesFields = Build.VERSION.SDK_INT < 27 ? new Field[]{packagesFiled, resourcePackagesFiled} : new Field[]{packagesFiled};
        for (Field field : packagesFields) {
            Object value = field.get(currentActivityThread);
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String resDirPath;
                Object loadedApk = ((WeakReference)entry.getValue()).get();
                if (loadedApk == null || !appInfo.sourceDir.equals(resDirPath = (String)resDir.get(loadedApk))) continue;
                resDir.set(loadedApk, externalResourceFile);
            }
        }
        if (isReInject) {
            ShareTinkerLog.i(TAG, "Re-injecting, skip rest logic.", new Object[0]);
            TinkerResourcePatcher.recordCurrentPatchedResModifiedTime(externalResourceFile);
            return;
        }
        newAssetManager = (AssetManager)newAssetManagerCtor.newInstance(new Object[0]);
        if ((Integer)addAssetPathMethod.invoke((Object)newAssetManager, externalResourceFile) == 0) {
            throw new IllegalStateException("Could not create new AssetManager");
        }
        TinkerResourcePatcher.recordCurrentPatchedResModifiedTime(externalResourceFile);
        if (TinkerResourcePatcher.shouldAddSharedLibraryAssets(appInfo)) {
            for (String sharedLibrary : appInfo.sharedLibraryFiles) {
                if (!sharedLibrary.endsWith(".apk")) continue;
                if ((Integer)addAssetPathAsSharedLibraryMethod.invoke((Object)newAssetManager, sharedLibrary) == 0) {
                    throw new IllegalStateException("AssetManager add SharedLibrary Fail");
                }
                ShareTinkerLog.i(TAG, "addAssetPathAsSharedLibrary " + (String)sharedLibrary, new Object[0]);
            }
        }
        if (stringBlocksField != null && ensureStringBlocksMethod != null) {
            stringBlocksField.set(newAssetManager, null);
            ensureStringBlocksMethod.invoke((Object)newAssetManager, new Object[0]);
        }
        for (WeakReference weakReference : references) {
            Resources resources = (Resources)weakReference.get();
            if (resources == null) continue;
            try {
                assetsFiled.set(resources, newAssetManager);
            }
            catch (Throwable ignore) {
                Object resourceImpl = resourcesImplFiled.get(resources);
                Field implAssets = ShareReflectUtil.findField(resourceImpl, "mAssets");
                implAssets.set(resourceImpl, newAssetManager);
            }
            TinkerResourcePatcher.clearPreloadTypedArrayIssue(resources);
            resources.updateConfiguration(resources.getConfiguration(), resources.getDisplayMetrics());
        }
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                if (publicSourceDirField != null) {
                    publicSourceDirField.set(context.getApplicationInfo(), externalResourceFile);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!TinkerResourcePatcher.checkResUpdate(context)) {
            throw new TinkerRuntimeException("checkResInstall failed");
        }
        TinkerResourcePatcher.installResourceInsuranceHacks(context, externalResourceFile);
    }

    private static void installResourceInsuranceHacks(Context context, String patchedResApkPath) {
        try {
            Object activityThread = ShareReflectUtil.getActivityThread(context, null);
            Field mHField = ShareReflectUtil.findField(activityThread, "mH");
            Handler mH = (Handler)mHField.get(activityThread);
            Field mCallbackField = ShareReflectUtil.findField(Handler.class, "mCallback");
            Handler.Callback originCallback = (Handler.Callback)mCallbackField.get(mH);
            if (!(originCallback instanceof ResourceInsuranceHandlerCallback)) {
                ResourceInsuranceHandlerCallback hackCallback = new ResourceInsuranceHandlerCallback(context, patchedResApkPath, originCallback, mH.getClass());
                mCallbackField.set(mH, hackCallback);
            } else {
                ShareTinkerLog.w(TAG, "installResourceInsuranceHacks: already installed, skip rest logic.", new Object[0]);
            }
        }
        catch (Throwable thr) {
            ShareTinkerLog.printErrStackTrace(TAG, thr, "failed to install resource insurance hack.", new Object[0]);
        }
    }

    private static boolean isPatchedResModifiedAfterLastLoad(String patchedResPath) {
        long patchedResModifiedTime;
        try {
            patchedResModifiedTime = new File(patchedResPath).lastModified();
        }
        catch (Throwable thr) {
            ShareTinkerLog.printErrStackTrace(TAG, thr, "Fail to get patched res modified time.", new Object[0]);
            patchedResModifiedTime = 0L;
        }
        if (patchedResModifiedTime == 0L) {
            return false;
        }
        return patchedResModifiedTime != storedPatchedResModifiedTime;
    }

    private static void recordCurrentPatchedResModifiedTime(String patchedResPath) {
        try {
            storedPatchedResModifiedTime = new File(patchedResPath).lastModified();
        }
        catch (Throwable thr) {
            ShareTinkerLog.printErrStackTrace(TAG, thr, "Fail to store patched res modified time.", new Object[0]);
            storedPatchedResModifiedTime = 0L;
        }
    }

    private static void clearPreloadTypedArrayIssue(Resources resources) {
        ShareTinkerLog.w(TAG, "try to clear typedArray cache!", new Object[0]);
        try {
            Field typedArrayPoolField = ShareReflectUtil.findField(Resources.class, "mTypedArrayPool");
            Object origTypedArrayPool = typedArrayPoolField.get(resources);
            Method acquireMethod = ShareReflectUtil.findMethod(origTypedArrayPool, "acquire", new Class[0]);
            while (acquireMethod.invoke(origTypedArrayPool, new Object[0]) != null) {
            }
        }
        catch (Throwable ignored) {
            ShareTinkerLog.e(TAG, "clearPreloadTypedArrayIssue failed, ignore error: " + ignored, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkResUpdate(Context context) {
        InputStream is = null;
        try {
            is = context.getAssets().open(TEST_ASSETS_VALUE);
        }
        catch (Throwable e) {
            boolean bl;
            try {
                ShareTinkerLog.e(TAG, "checkResUpdate failed, can't find test resource assets file only_use_to_test_tinker_resource.txt e:" + e.getMessage(), new Object[0]);
                bl = false;
            }
            catch (Throwable throwable) {
                SharePatchFileUtil.closeQuietly(is);
                throw throwable;
            }
            SharePatchFileUtil.closeQuietly(is);
            return bl;
        }
        SharePatchFileUtil.closeQuietly(is);
        ShareTinkerLog.i(TAG, "checkResUpdate success, found test resource assets file only_use_to_test_tinker_resource.txt", new Object[0]);
        return true;
    }

    private static boolean shouldAddSharedLibraryAssets(ApplicationInfo applicationInfo) {
        return Build.VERSION.SDK_INT >= 24 && applicationInfo != null && applicationInfo.sharedLibraryFiles != null;
    }

    private static final class ResourceInsuranceHandlerCallback
    implements Handler.Callback {
        private static final String LAUNCH_ACTIVITY_LIFECYCLE_ITEM_CLASSNAME = "android.app.servertransaction.LaunchActivityItem";
        private final Context mContext;
        private final String mPatchResApkPath;
        private final Handler.Callback mOriginalCallback;
        private final int LAUNCH_ACTIVITY;
        private final int RELAUNCH_ACTIVITY;
        private final int EXECUTE_TRANSACTION;
        private Method mGetCallbacksMethod = null;
        private boolean mSkipInterceptExecuteTransaction = false;

        ResourceInsuranceHandlerCallback(Context context, String patchResApkPath, Handler.Callback original, Class<?> hClazz) {
            Context appContext = context.getApplicationContext();
            this.mContext = appContext != null ? appContext : context;
            this.mPatchResApkPath = patchResApkPath;
            this.mOriginalCallback = original;
            this.LAUNCH_ACTIVITY = this.fetchMessageId(hClazz, "LAUNCH_ACTIVITY", 100);
            this.RELAUNCH_ACTIVITY = this.fetchMessageId(hClazz, "RELAUNCH_ACTIVITY", 126);
            this.EXECUTE_TRANSACTION = ShareTinkerInternals.isNewerOrEqualThanVersion(28, true) ? this.fetchMessageId(hClazz, "EXECUTE_TRANSACTION ", 159) : -1;
        }

        private int fetchMessageId(Class<?> hClazz, String name, int defVal) {
            int value;
            try {
                value = ShareReflectUtil.findField(hClazz, name).getInt(null);
            }
            catch (Throwable e) {
                value = defVal;
            }
            return value;
        }

        public boolean handleMessage(Message msg) {
            boolean consume = false;
            if (this.hackMessage(msg)) {
                consume = true;
            } else if (this.mOriginalCallback != null) {
                consume = this.mOriginalCallback.handleMessage(msg);
            }
            return consume;
        }

        private boolean hackMessage(Message msg) {
            boolean shouldReInjectPatchedResources = false;
            if (!TinkerResourcePatcher.isPatchedResModifiedAfterLastLoad(this.mPatchResApkPath)) {
                shouldReInjectPatchedResources = false;
            } else if (msg.what == this.LAUNCH_ACTIVITY || msg.what == this.RELAUNCH_ACTIVITY) {
                shouldReInjectPatchedResources = true;
            } else if (msg.what == this.EXECUTE_TRANSACTION && !this.mSkipInterceptExecuteTransaction) {
                Object transaction = msg.obj;
                if (transaction == null) {
                    ShareTinkerLog.w(TinkerResourcePatcher.TAG, "transaction is null, skip rest insurance logic.", new Object[0]);
                } else {
                    if (this.mGetCallbacksMethod == null) {
                        try {
                            this.mGetCallbacksMethod = ShareReflectUtil.findMethod(transaction, "getCallbacks", new Class[0]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (this.mGetCallbacksMethod == null) {
                        ShareTinkerLog.e(TinkerResourcePatcher.TAG, "fail to find getLifecycleStateRequest method, skip rest insurance logic.", new Object[0]);
                        this.mSkipInterceptExecuteTransaction = true;
                    } else {
                        try {
                            List req = (List)this.mGetCallbacksMethod.invoke(transaction, new Object[0]);
                            if (req != null && req.size() > 0) {
                                Object cb = req.get(0);
                                shouldReInjectPatchedResources = cb != null && cb.getClass().getName().equals(LAUNCH_ACTIVITY_LIFECYCLE_ITEM_CLASSNAME);
                            }
                        }
                        catch (Throwable ignored) {
                            ShareTinkerLog.e(TinkerResourcePatcher.TAG, "fail to call getLifecycleStateRequest method, skip rest insurance logic.", new Object[0]);
                        }
                    }
                }
            }
            if (shouldReInjectPatchedResources) {
                try {
                    TinkerResourcePatcher.monkeyPatchExistingResources(this.mContext, this.mPatchResApkPath, true);
                }
                catch (Throwable thr) {
                    ShareTinkerLog.printErrStackTrace(TinkerResourcePatcher.TAG, thr, "fail to ensure patched resources available after it's modified.", new Object[0]);
                }
            }
            return false;
        }
    }
}

