/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.SystemClock;
import com.tencent.tinker.loader.AbstractTinkerLoader;
import com.tencent.tinker.loader.AppInfoChangedBlocker;
import com.tencent.tinker.loader.TinkerArkHotLoader;
import com.tencent.tinker.loader.TinkerDexLoader;
import com.tencent.tinker.loader.TinkerResourceLoader;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.TinkerSoLoader;
import com.tencent.tinker.loader.app.TinkerApplication;
import com.tencent.tinker.loader.hotplug.ComponentHotplug;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.io.File;
import java.io.Serializable;

public class TinkerLoader
extends AbstractTinkerLoader {
    private static final String TAG = "Tinker.TinkerLoader";
    private SharePatchInfo patchInfo;

    @Override
    public Intent tryLoad(TinkerApplication app) {
        ShareTinkerLog.d(TAG, "tryLoad test test", new Object[0]);
        Intent resultIntent = new Intent();
        long begin = SystemClock.elapsedRealtime();
        this.tryLoadPatchFilesInternal(app, resultIntent);
        long cost = SystemClock.elapsedRealtime() - begin;
        ShareIntentUtil.setIntentPatchCostTime(resultIntent, cost);
        return resultIntent;
    }

    private void tryLoadPatchFilesInternal(TinkerApplication app, Intent resultIntent) {
        boolean loadTinkerResources;
        boolean loadArkHotFixJars;
        boolean resourceCheck;
        boolean libCheck;
        boolean arkHotCheck;
        boolean dexCheck;
        File patchVersionFile;
        int tinkerFlag = app.getTinkerFlags();
        if (!ShareTinkerInternals.isTinkerEnabled(tinkerFlag)) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles: tinker is disable, just return", new Object[0]);
            ShareIntentUtil.setIntentReturnCode(resultIntent, -1);
            return;
        }
        if (ShareTinkerInternals.isInPatchProcess((Context)app)) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles: we don't load patch with :patch process itself, just return", new Object[0]);
            ShareIntentUtil.setIntentReturnCode(resultIntent, -1);
            return;
        }
        File patchDirectoryFile = SharePatchFileUtil.getPatchDirectory((Context)app);
        if (patchDirectoryFile == null) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles:getPatchDirectory == null", new Object[0]);
            ShareIntentUtil.setIntentReturnCode(resultIntent, -2);
            return;
        }
        String patchDirectoryPath = patchDirectoryFile.getAbsolutePath();
        if (!patchDirectoryFile.exists()) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles:patch dir not exist:" + patchDirectoryPath, new Object[0]);
            ShareIntentUtil.setIntentReturnCode(resultIntent, -2);
            return;
        }
        File patchInfoFile = SharePatchFileUtil.getPatchInfoFile(patchDirectoryPath);
        if (!patchInfoFile.exists()) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles:patch info not exist:" + patchInfoFile.getAbsolutePath(), new Object[0]);
            ShareIntentUtil.setIntentReturnCode(resultIntent, -3);
            return;
        }
        File patchInfoLockFile = SharePatchFileUtil.getPatchInfoLockFile(patchDirectoryPath);
        this.patchInfo = SharePatchInfo.readAndCheckPropertyWithLock(patchInfoFile, patchInfoLockFile);
        if (this.patchInfo == null) {
            ShareIntentUtil.setIntentReturnCode(resultIntent, -4);
            return;
        }
        boolean isProtectedApp = this.patchInfo.isProtectedApp;
        resultIntent.putExtra("intent_is_protected_app", isProtectedApp);
        String oldVersion = this.patchInfo.oldVersion;
        String newVersion = this.patchInfo.newVersion;
        String oatDex = this.patchInfo.oatDir;
        if (oldVersion == null || newVersion == null || oatDex == null) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles:onPatchInfoCorrupted", new Object[0]);
            ShareIntentUtil.setIntentReturnCode(resultIntent, -4);
            return;
        }
        boolean mainProcess = ShareTinkerInternals.isInMainProcess((Context)app);
        String versionToRemove = this.patchInfo.versionToRemove;
        if (mainProcess) {
            String patchName;
            if (!ShareTinkerInternals.isNullOrNil(versionToRemove)) {
                if (newVersion.equals(versionToRemove)) {
                    ShareTinkerLog.w(TAG, "found new version clean patch mark and we are in main process, delete patch file now.", new Object[0]);
                    patchName = SharePatchFileUtil.getPatchVersionDirectory(newVersion);
                    if (patchName != null) {
                        boolean isNewVersionLoadedBefore = oldVersion.equals(newVersion);
                        if (isNewVersionLoadedBefore) {
                            oldVersion = "";
                        }
                        newVersion = oldVersion;
                        this.patchInfo.oldVersion = oldVersion;
                        this.patchInfo.newVersion = newVersion;
                        this.patchInfo.versionToRemove = "";
                        SharePatchInfo.rewritePatchInfoFileWithLock(patchInfoFile, this.patchInfo, patchInfoLockFile);
                        String patchVersionDirFullPath = patchDirectoryPath + "/" + patchName;
                        if (isNewVersionLoadedBefore) {
                            ShareTinkerInternals.killProcessExceptMain((Context)app);
                            SharePatchFileUtil.deleteDir(patchVersionDirFullPath);
                            ShareIntentUtil.setIntentReturnCode(resultIntent, -2);
                            return;
                        }
                        SharePatchFileUtil.deleteDir(patchVersionDirFullPath);
                    }
                } else if (oldVersion.equals(versionToRemove)) {
                    ShareTinkerLog.w(TAG, "found old version clean patch mark and we are in main process, delete patch file now.", new Object[0]);
                    patchName = SharePatchFileUtil.getPatchVersionDirectory(oldVersion);
                    if (patchName != null) {
                        this.patchInfo.oldVersion = oldVersion = newVersion;
                        this.patchInfo.newVersion = newVersion;
                        this.patchInfo.versionToRemove = "";
                        SharePatchInfo.rewritePatchInfoFileWithLock(patchInfoFile, this.patchInfo, patchInfoLockFile);
                        String patchVersionDirFullPath = patchDirectoryPath + "/" + patchName;
                        ShareTinkerInternals.killProcessExceptMain((Context)app);
                        SharePatchFileUtil.deleteDir(patchVersionDirFullPath);
                    }
                } else {
                    this.patchInfo.versionToRemove = "";
                    SharePatchInfo.rewritePatchInfoFileWithLock(patchInfoFile, this.patchInfo, patchInfoLockFile);
                }
            }
            if (this.patchInfo.isRemoveInterpretOATDir) {
                ShareTinkerLog.i(TAG, "tryLoadPatchFiles: isRemoveInterpretOATDir is true, try to delete interpret optimize files", new Object[0]);
                this.patchInfo.isRemoveInterpretOATDir = false;
                SharePatchInfo.rewritePatchInfoFileWithLock(patchInfoFile, this.patchInfo, patchInfoLockFile);
                ShareTinkerInternals.killProcessExceptMain((Context)app);
                patchName = SharePatchFileUtil.getPatchVersionDirectory(newVersion);
                String patchVersionDirFullPath = patchDirectoryPath + "/" + patchName;
                SharePatchFileUtil.deleteDir(patchVersionDirFullPath + "/" + "interpet");
            }
        }
        resultIntent.putExtra("intent_patch_old_version", oldVersion);
        resultIntent.putExtra("intent_patch_new_version", newVersion);
        boolean versionChanged = !oldVersion.equals(newVersion);
        boolean oatModeChanged = oatDex.equals("changing");
        oatDex = ShareTinkerInternals.getCurrentOatMode((Context)app, oatDex);
        resultIntent.putExtra("intent_patch_oat_dir", oatDex);
        String version = oldVersion;
        if (versionChanged && mainProcess) {
            version = newVersion;
        }
        if (ShareTinkerInternals.isNullOrNil(version)) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles:version is blank, wait main process to restart", new Object[0]);
            ShareIntentUtil.setIntentReturnCode(resultIntent, -5);
            return;
        }
        String patchName = SharePatchFileUtil.getPatchVersionDirectory(version);
        if (patchName == null) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles:patchName is null", new Object[0]);
            ShareIntentUtil.setIntentReturnCode(resultIntent, -6);
            return;
        }
        String patchVersionDirectory = patchDirectoryPath + "/" + patchName;
        File patchVersionDirectoryFile = new File(patchVersionDirectory);
        if (!patchVersionDirectoryFile.exists()) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles:onPatchVersionDirectoryNotFound", new Object[0]);
            ShareIntentUtil.setIntentReturnCode(resultIntent, -6);
            return;
        }
        String patchVersionFileRelPath = SharePatchFileUtil.getPatchVersionFile(version);
        File file = patchVersionFile = patchVersionFileRelPath != null ? new File(patchVersionDirectoryFile.getAbsolutePath(), patchVersionFileRelPath) : null;
        if (!SharePatchFileUtil.isLegalFile(patchVersionFile)) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles:onPatchVersionFileNotFound", new Object[0]);
            ShareIntentUtil.setIntentReturnCode(resultIntent, -7);
            return;
        }
        ShareSecurityCheck securityCheck = new ShareSecurityCheck((Context)app);
        int returnCode = ShareTinkerInternals.checkTinkerPackage((Context)app, tinkerFlag, patchVersionFile, securityCheck);
        if (returnCode != 0) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles:checkTinkerPackage", new Object[0]);
            resultIntent.putExtra("intent_patch_package_patch_check", returnCode);
            ShareIntentUtil.setIntentReturnCode(resultIntent, -8);
            return;
        }
        resultIntent.putExtra("intent_patch_package_config", securityCheck.getPackagePropertiesIfPresent());
        boolean isEnabledForDex = ShareTinkerInternals.isTinkerEnabledForDex(tinkerFlag);
        boolean isArkHotRuning = ShareTinkerInternals.isArkHotRuning();
        if (!isArkHotRuning && isEnabledForDex && !(dexCheck = TinkerDexLoader.checkComplete(patchVersionDirectory, securityCheck, oatDex, resultIntent))) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles:dex check fail", new Object[0]);
            return;
        }
        boolean isEnabledForArkHot = ShareTinkerInternals.isTinkerEnabledForArkHot(tinkerFlag);
        if (isArkHotRuning && isEnabledForArkHot && !(arkHotCheck = TinkerArkHotLoader.checkComplete(patchVersionDirectory, securityCheck, resultIntent))) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles:dex check fail", new Object[0]);
            return;
        }
        boolean isEnabledForNativeLib = ShareTinkerInternals.isTinkerEnabledForNativeLib(tinkerFlag);
        if (isEnabledForNativeLib && !(libCheck = TinkerSoLoader.checkComplete(patchVersionDirectory, securityCheck, resultIntent))) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles:native lib check fail", new Object[0]);
            return;
        }
        boolean isEnabledForResource = ShareTinkerInternals.isTinkerEnabledForResource(tinkerFlag);
        ShareTinkerLog.w(TAG, "tryLoadPatchFiles:isEnabledForResource:" + isEnabledForResource, new Object[0]);
        if (isEnabledForResource && !(resourceCheck = TinkerResourceLoader.checkComplete((Context)app, patchVersionDirectory, securityCheck, resultIntent))) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles:resource check fail", new Object[0]);
            return;
        }
        boolean isSystemOTA = ShareTinkerInternals.isVmArt() && ShareTinkerInternals.isSystemOTA(this.patchInfo.fingerPrint) && Build.VERSION.SDK_INT >= 21 && !ShareTinkerInternals.isAfterAndroidO();
        resultIntent.putExtra("intent_patch_system_ota", isSystemOTA);
        if (mainProcess) {
            if (versionChanged) {
                this.patchInfo.oldVersion = version;
            }
            if (oatModeChanged) {
                this.patchInfo.oatDir = oatDex;
                this.patchInfo.isRemoveInterpretOATDir = true;
            }
        }
        if (!this.checkSafeModeCount(app)) {
            if (mainProcess) {
                this.patchInfo.oldVersion = "";
                this.patchInfo.newVersion = "";
                this.patchInfo.versionToRemove = "";
                SharePatchInfo.rewritePatchInfoFileWithLock(patchInfoFile, this.patchInfo, patchInfoLockFile);
                ShareTinkerInternals.killProcessExceptMain((Context)app);
                String patchVersionDirFullPath = patchDirectoryPath + "/" + patchName;
                SharePatchFileUtil.deleteDir(patchVersionDirFullPath);
                resultIntent.putExtra("intent_patch_exception", (Serializable)new TinkerRuntimeException("checkSafeModeCount fail"));
                ShareIntentUtil.setIntentReturnCode(resultIntent, -25);
                ShareTinkerLog.w(TAG, "tryLoadPatchFiles:checkSafeModeCount fail, patch was deleted.", new Object[0]);
                return;
            }
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles:checkSafeModeCount fail, but we are not in main process, mark the patch to be deleted and continue load patch.", new Object[0]);
            ShareTinkerInternals.cleanPatch((Context)app);
        }
        if (!isArkHotRuning && isEnabledForDex) {
            boolean loadTinkerJars = TinkerDexLoader.loadTinkerJars(app, patchVersionDirectory, oatDex, resultIntent, isSystemOTA, isProtectedApp);
            if (isSystemOTA) {
                this.patchInfo.fingerPrint = Build.FINGERPRINT;
                this.patchInfo.oatDir = loadTinkerJars ? "interpet" : "odex";
                oatModeChanged = false;
                if (!SharePatchInfo.rewritePatchInfoFileWithLock(patchInfoFile, this.patchInfo, patchInfoLockFile)) {
                    ShareIntentUtil.setIntentReturnCode(resultIntent, -19);
                    ShareTinkerLog.w(TAG, "tryLoadPatchFiles:onReWritePatchInfoCorrupted", new Object[0]);
                    return;
                }
                resultIntent.putExtra("intent_patch_oat_dir", this.patchInfo.oatDir);
            }
            if (!loadTinkerJars) {
                ShareTinkerLog.w(TAG, "tryLoadPatchFiles:onPatchLoadDexesFail", new Object[0]);
                return;
            }
        }
        if (isArkHotRuning && isEnabledForArkHot && !(loadArkHotFixJars = TinkerArkHotLoader.loadTinkerArkHot(app, patchVersionDirectory, resultIntent))) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles:onPatchLoadArkApkFail", new Object[0]);
            return;
        }
        if (isEnabledForResource && !(loadTinkerResources = TinkerResourceLoader.loadTinkerResources(app, patchVersionDirectory, resultIntent))) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles:onPatchLoadResourcesFail", new Object[0]);
            return;
        }
        if ((isEnabledForDex || isEnabledForArkHot) && isEnabledForResource) {
            ComponentHotplug.install(app, securityCheck);
        }
        if (!AppInfoChangedBlocker.tryStart(app)) {
            ShareTinkerLog.w(TAG, "tryLoadPatchFiles:AppInfoChangedBlocker install fail.", new Object[0]);
            ShareIntentUtil.setIntentReturnCode(resultIntent, -28);
            return;
        }
        if (mainProcess && (versionChanged || oatModeChanged)) {
            if (!SharePatchInfo.rewritePatchInfoFileWithLock(patchInfoFile, this.patchInfo, patchInfoLockFile)) {
                ShareIntentUtil.setIntentReturnCode(resultIntent, -19);
                ShareTinkerLog.w(TAG, "tryLoadPatchFiles:onReWritePatchInfoCorrupted", new Object[0]);
                return;
            }
            ShareTinkerInternals.killProcessExceptMain((Context)app);
        }
        ShareIntentUtil.setIntentReturnCode(resultIntent, 0);
        ShareTinkerLog.i(TAG, "tryLoadPatchFiles: load end, ok!", new Object[0]);
    }

    private boolean checkSafeModeCount(TinkerApplication application) {
        int count = ShareTinkerInternals.getSafeModeCount((Context)application);
        if (count >= 2) {
            ShareTinkerInternals.setSafeModeCount((Context)application, 0);
            return false;
        }
        application.setUseSafeMode(true);
        ShareTinkerInternals.setSafeModeCount((Context)application, count + 1);
        return true;
    }
}

