/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.android.dex;

import com.tencent.tinker.android.dex.Leb128;
import com.tencent.tinker.android.dex.TableOfContents;
import com.tencent.tinker.android.dex.util.CompareUtils;
import com.tencent.tinker.android.dex.util.HashCodeHelper;

public class DebugInfoItem
extends TableOfContents.Section.Item<DebugInfoItem> {
    public static final byte DBG_END_SEQUENCE = 0;
    public static final byte DBG_ADVANCE_PC = 1;
    public static final byte DBG_ADVANCE_LINE = 2;
    public static final byte DBG_START_LOCAL = 3;
    public static final byte DBG_START_LOCAL_EXTENDED = 4;
    public static final byte DBG_END_LOCAL = 5;
    public static final byte DBG_RESTART_LOCAL = 6;
    public static final byte DBG_SET_PROLOGUE_END = 7;
    public static final byte DBG_SET_EPILOGUE_BEGIN = 8;
    public static final byte DBG_SET_FILE = 9;
    public int lineStart;
    public int[] parameterNames;
    public byte[] infoSTM;

    public DebugInfoItem(int off, int lineStart, int[] parameterNames, byte[] infoSTM) {
        super(off);
        this.lineStart = lineStart;
        this.parameterNames = parameterNames;
        this.infoSTM = infoSTM;
    }

    @Override
    public int compareTo(DebugInfoItem o) {
        int origLineStart = this.lineStart;
        int destLineStart = o.lineStart;
        if (origLineStart != destLineStart) {
            return origLineStart - destLineStart;
        }
        int cmpRes = CompareUtils.uArrCompare(this.parameterNames, o.parameterNames);
        if (cmpRes != 0) {
            return cmpRes;
        }
        cmpRes = CompareUtils.uArrCompare(this.infoSTM, o.infoSTM);
        return cmpRes;
    }

    @Override
    public int hashCode() {
        return HashCodeHelper.hash(this.lineStart, this.parameterNames, this.infoSTM);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DebugInfoItem)) {
            return false;
        }
        return this.compareTo((DebugInfoItem)obj) == 0;
    }

    @Override
    public int byteCountInDex() {
        int byteCount = Leb128.unsignedLeb128Size(this.lineStart) + Leb128.unsignedLeb128Size(this.parameterNames.length);
        for (int pn : this.parameterNames) {
            byteCount += Leb128.unsignedLeb128p1Size(pn);
        }
        return byteCount += this.infoSTM.length * 1;
    }
}

