/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.android.dex.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class FileUtils {
    private FileUtils() {
    }

    public static byte[] readFile(String fileName) throws IOException {
        File file = new File(fileName);
        return FileUtils.readFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file) throws IOException {
        if (!file.exists()) {
            throw new RuntimeException(file + ": file not found");
        }
        if (!file.isFile()) {
            throw new RuntimeException(file + ": not a file");
        }
        if (!file.canRead()) {
            throw new RuntimeException(file + ": file not readable");
        }
        long longLength = file.length();
        int length = (int)longLength;
        if ((long)length != longLength) {
            throw new RuntimeException(file + ": file too long");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(length);
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            while ((bytesRead = in.read(buffer)) > 0) {
                baos.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return baos.toByteArray();
    }

    public static byte[] readStream(InputStream is) throws IOException {
        return FileUtils.readStream(is, 32768);
    }

    public static byte[] readStream(InputStream is, int initSize) throws IOException {
        int bytesRead;
        if (initSize <= 0) {
            initSize = 32768;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(initSize);
        byte[] buffer = new byte[8192];
        while ((bytesRead = is.read(buffer)) > 0) {
            baos.write(buffer, 0, bytesRead);
        }
        return baos.toByteArray();
    }

    public static boolean hasArchiveSuffix(String fileName) {
        return fileName.endsWith(".zip") || fileName.endsWith(".jar") || fileName.endsWith(".apk");
    }
}

